/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.InternalManagedConnectionPool;

public class IdleRemover {
    private final Logger log = Logger.getLogger(this.getClass());
    private final Collection pools = new ArrayList();
    private long interval = Long.MAX_VALUE;
    private long next = Long.MAX_VALUE;
    private static final IdleRemover remover = new IdleRemover();
    private final Thread removerThread = new Thread(new Runnable(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Collection collection = IdleRemover.this.pools;
            synchronized (collection) {
                try {
                    block4: while (true) {
                        IdleRemover.this.pools.wait(IdleRemover.this.interval);
                        IdleRemover.this.log.debug((Object)("run: IdleRemover notifying pools, interval: " + IdleRemover.this.interval));
                        Iterator i = IdleRemover.this.pools.iterator();
                        while (true) {
                            if (!i.hasNext()) {
                                IdleRemover.this.next = System.currentTimeMillis() + IdleRemover.this.interval;
                                if (IdleRemover.this.next >= 0L) continue block4;
                                IdleRemover.this.next = Long.MAX_VALUE;
                                continue block4;
                            }
                            ((InternalManagedConnectionPool)i.next()).removeTimedOut();
                        }
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    IdleRemover.this.log.info((Object)"run: IdleRemover has been interrupted, returning");
                    return;
                }
            }
        }
    });

    public static void registerPool(InternalManagedConnectionPool mcp, long interval) {
        remover.internalRegisterPool(mcp, interval);
    }

    public static void unregisterPool(InternalManagedConnectionPool mcp) {
        remover.internalUnregisterPool(mcp);
    }

    private IdleRemover() {
        this.removerThread.start();
    }

    private void internalRegisterPool(InternalManagedConnectionPool mcp, long interval) {
        this.log.debug((Object)("internalRegisterPool: registering pool with interval " + interval + " old interval: " + this.interval));
        Collection collection = this.pools;
        synchronized (collection) {
            this.pools.add(mcp);
            if (interval > 1L && interval / 2L < this.interval) {
                this.interval = interval / 2L;
                long maybeNext = System.currentTimeMillis() + this.interval;
                if (this.next > maybeNext && maybeNext > 0L) {
                    this.next = maybeNext;
                    this.log.debug((Object)("internalRegisterPool: about to notify thread: old next: " + this.next + ", new next: " + maybeNext));
                    this.pools.notify();
                }
            }
        }
    }

    private void internalUnregisterPool(InternalManagedConnectionPool mcp) {
        Collection collection = this.pools;
        synchronized (collection) {
            this.pools.remove(mcp);
            if (this.pools.size() == 0) {
                this.log.debug((Object)"internalUnregisterPool: setting interval to Long.MAX_VALUE");
                this.interval = Long.MAX_VALUE;
            }
        }
    }

    private void stop() {
        this.interval = -1L;
        this.log.debug((Object)"stop: stopping IdleRemover");
        this.removerThread.interrupt();
    }
}

