/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.resource.connectionmanager.BaseConnectionManager2;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.ConnectionRecord;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;
import org.jboss.resource.connectionmanager.XATxConnectionManagerMBean;

public class XATxConnectionManager
extends BaseConnectionManager2
implements XATxConnectionManagerMBean {
    private String tmName;
    private TransactionManager tm;

    public XATxConnectionManager() {
    }

    public XATxConnectionManager(ManagedConnectionFactory mcf, CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy, TransactionManager tm) {
        super(mcf, ccm, poolingStrategy);
        this.tm = tm;
    }

    public void setTransactionManager(String tmName) {
        this.tmName = tmName;
    }

    public String getTransactionManager() {
        return this.tmName;
    }

    protected void startService() throws Exception {
        this.tm = (TransactionManager)new InitialContext().lookup(this.tmName);
        super.startService();
    }

    protected void stopService() throws Exception {
        this.tm = null;
        super.stopService();
    }

    protected BaseConnectionManager2.ConnectionListener registerConnectionEventListener(ManagedConnection mc) throws ResourceException {
        XAConnectionEventListener cli = new XAConnectionEventListener(mc);
        mc.addConnectionEventListener((ConnectionEventListener)cli);
        return cli;
    }

    public void transactionStarted(Collection crs) throws SystemException {
        HashSet<ManagedConnection> mcs = new HashSet<ManagedConnection>();
        Iterator i = crs.iterator();
        while (i.hasNext()) {
            ConnectionRecord cr = (ConnectionRecord)i.next();
            ManagedConnection mc = cr.mc;
            if (mcs.contains(mc)) continue;
            mcs.add(mc);
            XAConnectionEventListener cel = (XAConnectionEventListener)this.getConnectionEventListener(mc);
            cel.enlist();
        }
        mcs.clear();
    }

    protected void managedConnectionReconnected(ManagedConnection mc) throws ResourceException {
        XAConnectionEventListener cel = (XAConnectionEventListener)this.getConnectionEventListener(mc);
        try {
            cel.enlist();
        }
        catch (SystemException se) {
            this.log.info((Object)"Could not enlist in transaction on entering meta-aware object!", (Throwable)se);
            throw new ResourceException("Could not enlist in transaction on entering meta-aware object!" + (Object)((Object)se));
        }
    }

    protected void managedConnectionDisconnected(ManagedConnection mc) throws ResourceException {
        XAConnectionEventListener cel = (XAConnectionEventListener)this.getConnectionEventListener(mc);
        if (cel == null) {
            throw new IllegalStateException("ManagedConnection with no ConnectionEventListener! " + mc);
        }
        cel.delist();
        if (cel.isManagedConnectionFree()) {
            this.returnManagedConnection(mc, false);
        }
    }

    private class XAConnectionEventListener
    extends BaseConnectionManager2.BaseConnectionEventListener {
        private Transaction currentTx;

        public XAConnectionEventListener(ManagedConnection mc) throws ResourceException {
            super(mc);
        }

        public void enlist() throws SystemException {
            if (this.currentTx != null) {
                this.log.warn((Object)("in Enlisting tx, illegal state: " + this.currentTx));
                throw new IllegalStateException("Can't enlist - already a tx!");
            }
            if (XATxConnectionManager.this.tm.getStatus() != 6) {
                this.currentTx = XATxConnectionManager.this.tm.getTransaction();
            }
            if (this.currentTx != null) {
                try {
                    XAResource xar = this.getManagedConnection().getXAResource();
                    this.currentTx.enlistResource(xar);
                }
                catch (ResourceException re) {
                    throw new SystemException("Could not get XAResource from ManagedConnection!" + (Object)((Object)re));
                }
                catch (RollbackException re) {
                    this.log.info((Object)"Could not enlist XAResource!", (Throwable)re);
                    throw new SystemException("Could not enlist XAResource!" + (Object)((Object)re));
                }
            }
        }

        public void delist() throws ResourceException {
            try {
                if (XATxConnectionManager.this.tm.getStatus() != 6) {
                    XATxConnectionManager.this.tm.getTransaction().delistResource(this.getManagedConnection().getXAResource(), 0x4000000);
                }
            }
            catch (SystemException se) {
                throw new ResourceException("SystemException in delist!" + (Object)((Object)se));
            }
            if (this.log.isTraceEnabled()) {
                this.log.info((Object)("about to set currentTx null, managedCOnnection: " + this.getManagedConnection() + ", thread: " + Thread.currentThread()));
            }
            this.currentTx = null;
        }

        public void connectionClosed(ConnectionEvent ce) {
            this.log.trace((Object)"connectionClosed called");
            if (this.getManagedConnection() != (ManagedConnection)ce.getSource()) {
                throw new IllegalArgumentException("ConnectionClosed event received from wrong ManagedConnection! Expected: " + this.getManagedConnection() + ", actual: " + ce.getSource());
            }
            try {
                XATxConnectionManager.this.getCcm().unregisterConnection(XATxConnectionManager.this, ce.getConnectionHandle());
            }
            catch (Throwable t) {
                this.log.info((Object)"throwable from unregister connection", t);
            }
            try {
                XATxConnectionManager.this.unregisterAssociation(this.getManagedConnection(), ce.getConnectionHandle());
                if (this.isManagedConnectionFree()) {
                    this.delist();
                    XATxConnectionManager.this.returnManagedConnection(this.getManagedConnection(), false);
                }
            }
            catch (ResourceException re) {
                this.log.error((Object)"ResourceException while closing connection handle!", (Throwable)re);
            }
        }

        public void localTransactionStarted(ConnectionEvent ce) {
            if (this.currentTx != null) {
                throw new IllegalStateException("Attempt to start local transaction while xa transaction is active!");
            }
        }

        public void localTransactionCommitted(ConnectionEvent ce) {
            if (this.currentTx != null) {
                throw new IllegalStateException("Attempt to commit local transaction while xa transaction is active!");
            }
        }

        public void localTransactionRolledback(ConnectionEvent ce) {
            if (this.currentTx != null) {
                throw new IllegalStateException("Attempt to roll back local transaction while xa transaction is active!");
            }
        }

        public void connectionErrorOccurred(ConnectionEvent ce) {
            XATxConnectionManager.this.getCcm().unregisterConnection(XATxConnectionManager.this, ce.getConnectionHandle());
            ManagedConnection mc = (ManagedConnection)ce.getSource();
            XATxConnectionManager.this.returnManagedConnection(mc, true);
        }
    }
}

