/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups;

import java.io.Serializable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.BlockEvent;
import org.javagroups.Channel;
import org.javagroups.ChannelClosedException;
import org.javagroups.ChannelException;
import org.javagroups.ChannelNotConnectedException;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.SuspectEvent;
import org.javagroups.TimeoutException;
import org.javagroups.View;
import org.javagroups.ensemble.Hot_Callbacks;
import org.javagroups.ensemble.Hot_Endpoint;
import org.javagroups.ensemble.Hot_Ensemble;
import org.javagroups.ensemble.Hot_Error;
import org.javagroups.ensemble.Hot_GroupContext;
import org.javagroups.ensemble.Hot_JoinOps;
import org.javagroups.ensemble.Hot_Message;
import org.javagroups.ensemble.Hot_ObjectMessage;
import org.javagroups.ensemble.Hot_ViewID;
import org.javagroups.ensemble.Hot_ViewState;
import org.javagroups.log.Trace;
import org.javagroups.util.Queue;
import org.javagroups.util.QueueClosedException;

public class EnsChannel
extends Channel
implements Hot_Callbacks {
    private Hot_Ensemble ensemble = null;
    private Thread ens_thread = null;
    private Hot_GroupContext channel_id = null;
    private String channel_name = null;
    private Hot_JoinOps options = new Hot_JoinOps();
    private Queue mq = new Queue();
    private Address my_addr = null;
    private View my_view = null;
    private final String default_properties = "Gmp:Sync:Heal:Frag:Suspect:Flow:Total";
    private final int CAST_MSG = 0;
    private final int SEND_MSG = 1;
    private final int VIEW_MSG = 2;
    private final int EXIT_MSG = 3;
    private final int BLOCK_MSG = 4;
    private boolean receive_views = true;
    private boolean receive_suspects = true;
    private boolean receive_blocks = false;
    private boolean receive_local_msgs = true;

    private void checkConnection() throws ChannelNotConnectedException {
        if (this.channel_id == null) {
            throw new ChannelNotConnectedException();
        }
    }

    private void checkClosed() throws ChannelClosedException {
        if (this.ensemble == null) {
            throw new ChannelClosedException();
        }
    }

    public EnsChannel() throws ChannelException {
        this(null);
    }

    public EnsChannel(Object props) throws ChannelException {
        String properties = null;
        try {
            properties = (String)props;
        }
        catch (ClassCastException cce) {
            throw new ChannelException("EnsChannel(): properties argument must be of type String !");
        }
        this.options.heartbeat_rate = 5000;
        this.options.transports = "UDP";
        this.options.properties = properties == null ? "Gmp:Sync:Heal:Frag:Suspect:Flow:Total" : properties;
        this.options.params = "suspect_max_idle=3:int;suspect_sweep=3.000:time";
        this.options.conf = this;
        this.options.use_properties = true;
        this.ensemble = new Hot_Ensemble();
        this.ens_thread = new Thread((Runnable)this.ensemble, "EnsembleThread");
        this.ens_thread.start();
    }

    public EnsChannel(Object props, String transport_props, int outboard_port) throws ChannelException {
        String properties = null;
        try {
            properties = (String)props;
        }
        catch (ClassCastException cce) {
            throw new ChannelException("EnsChannel(): properties argument must be of type String !");
        }
        this.options.heartbeat_rate = 5000;
        this.options.transports = "UDP";
        if (transport_props != null) {
            this.options.transports = transport_props;
        }
        this.options.properties = properties == null ? "Gmp:Sync:Heal:Frag:Suspect:Flow:Total" : properties;
        this.options.params = "suspect_max_idle=3:int;suspect_sweep=3.000:time";
        this.options.conf = this;
        this.options.use_properties = true;
        this.ensemble = outboard_port == 0 ? new Hot_Ensemble() : new Hot_Ensemble(outboard_port);
        this.ens_thread = new Thread((Runnable)this.ensemble, "EnsembleThread");
        this.ens_thread.start();
    }

    public void connect(String channel_name) throws ChannelClosedException {
        Hot_GroupContext[] tmp = new Hot_GroupContext[1];
        this.checkClosed();
        this.channel_name = channel_name;
        this.options.group_name = channel_name;
        if (this.channel_id != null) {
            Trace.error("EnsChannel.join()", "already connected to " + channel_name);
            return;
        }
        if (this.ensemble == null || this.ens_thread == null) {
            Trace.error("EnsChannel.connect()", "Ensemble has not been started");
            return;
        }
        Hot_Error rc = this.ensemble.join(this.options, tmp);
        if (rc != null) {
            Trace.error("EnsChannel.connect()", rc.toString());
            return;
        }
        this.channel_id = tmp[0];
        if (this.channel_listener != null) {
            this.channel_listener.channelConnected(this);
        }
    }

    public void disconnect() {
        if (this.channel_id == null) {
            Trace.error("EnsChannel.disconnect()", "cannot disconnect as channel id is null");
            return;
        }
        Hot_Error rc = this.ensemble.leave(this.channel_id);
        if (rc != null) {
            Trace.error("EnsChannel.disconnect()", "rc=" + rc);
        }
        this.channel_id = null;
        if (this.channel_listener != null) {
            this.channel_listener.channelDisconnected(this);
        }
    }

    public void close() {
        if (this.ensemble != null) {
            if (this.ens_thread != null) {
                this.ensemble.stopEnsThread();
                this.ens_thread.interrupt();
                this.ens_thread = null;
            }
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception e) {
                Trace.error("EnsChannel.close()", "exception=" + e);
            }
            this.ensemble.destroyOutboard();
            this.ensemble = null;
            try {
                this.mq.close(false);
            }
            catch (Exception e) {
                Trace.error("EnsChannel.close()", "exception=" + e);
            }
            this.mq.reset();
            if (this.channel_listener != null) {
                this.channel_listener.channelClosed(this);
            }
        }
    }

    public boolean isOpen() {
        return this.channel_id != null;
    }

    public boolean isConnected() {
        return this.isOpen();
    }

    public void finalize() {
        if (this.channel_id != null) {
            this.disconnect();
        }
        this.close();
    }

    private void cast(byte[] msg) throws ChannelNotConnectedException, ChannelClosedException {
        int[] tmp = new int[1];
        this.checkConnection();
        this.checkClosed();
        Hot_ObjectMessage m = new Hot_ObjectMessage(new Message(null, null, msg));
        Hot_Error rc = this.ensemble.cast(this.channel_id, m, tmp);
        if (rc != null) {
            Trace.error("EnsChannel.cast()", "rc=" + rc);
        }
    }

    private void send(Object dest_addr, byte[] msg) throws ChannelNotConnectedException, ChannelClosedException {
        int[] tmp = new int[1];
        this.checkConnection();
        this.checkClosed();
        if (dest_addr == null) {
            Trace.error("EnsChannel.send()", "destination is null");
            return;
        }
        Hot_Endpoint dest = (Hot_Endpoint)dest_addr;
        if (dest == null) {
            Trace.error("EnsChannel.send()", "destination object is not of type Hot_Endpoint, but of type " + dest_addr.getClass().getName());
            return;
        }
        Hot_ObjectMessage m = new Hot_ObjectMessage(new Message((Address)dest, null, msg));
        Hot_Error rc = this.ensemble.send(this.channel_id, dest, m, tmp);
        if (rc != null) {
            Trace.error("EnsChannel.send()", "rc=" + rc);
        }
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        Address dest = msg.getDest();
        Hot_ObjectMessage m = new Hot_ObjectMessage(msg);
        Hot_Error rc = null;
        int[] tmp = new int[1];
        this.checkConnection();
        this.checkClosed();
        if (dest == null || dest instanceof String || dest instanceof Vector) {
            rc = this.ensemble.cast(this.channel_id, m, tmp);
        } else if (dest instanceof Hot_Endpoint) {
            rc = this.ensemble.send(this.channel_id, (Hot_Endpoint)dest, m, tmp);
        } else {
            Trace.error("EnsChannel.send()", "dest address is wrong (" + dest + ")");
            return;
        }
        if (rc != null) {
            Trace.error("EnsChannel.send()", "rc=" + rc);
        }
    }

    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        Object retval = null;
        this.checkConnection();
        this.checkClosed();
        if (this.mq == null) {
            throw new ChannelNotConnectedException();
        }
        try {
            Event evt;
            Event event = evt = timeout <= 0L ? (Event)this.mq.remove() : (Event)this.mq.remove(timeout);
            if (evt == null) {
                return null;
            }
            switch (evt.getType()) {
                case 5: {
                    return evt.getArg();
                }
                case 10: {
                    this.my_view = (View)evt.getArg();
                    return this.my_view;
                }
                case 15: {
                    return new SuspectEvent(evt.getArg());
                }
                case 16: {
                    return new BlockEvent();
                }
            }
            Trace.error("EnsChannel.receive()", "event is neither message nor view nor block");
            return null;
        }
        catch (TimeoutException tex) {
            throw tex;
        }
        catch (QueueClosedException queue_closed) {
            Trace.error("EnsChannel.receive()", "exception=" + queue_closed);
            throw new ChannelNotConnectedException();
        }
        catch (Exception e) {
            Trace.error("EnsChannel.receive()", "exception=" + e);
            return null;
        }
    }

    public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        Object retval = null;
        this.checkConnection();
        this.checkClosed();
        if (this.mq == null) {
            throw new ChannelNotConnectedException();
        }
        try {
            Event evt;
            Event event = evt = timeout <= 0L ? (Event)this.mq.peek() : (Event)this.mq.peek(timeout);
            if (evt == null) {
                return null;
            }
            switch (evt.getType()) {
                case 5: {
                    return evt.getArg();
                }
                case 10: {
                    return evt.getArg();
                }
                case 15: {
                    return new SuspectEvent(evt.getArg());
                }
                case 16: {
                    return new BlockEvent();
                }
            }
            Trace.error("EnsChannel.peek()", "event is neither message nor view nor block");
            return null;
        }
        catch (TimeoutException tex) {
            throw tex;
        }
        catch (QueueClosedException queue_closed) {
            Trace.error("EnsChannel.peek()", "exception=" + queue_closed);
            throw new ChannelNotConnectedException();
        }
        catch (Exception e) {
            Trace.error("EnsChannel.peek()", "exception=" + e);
            return null;
        }
    }

    public View getView() {
        return this.my_view;
    }

    public Address getLocalAddress() {
        return this.my_addr;
    }

    public String getChannelName() {
        return this.channel_name;
    }

    public void setOpt(int option, Object value) {
        switch (option) {
            case 1: {
                if (value instanceof Boolean) {
                    this.receive_views = (Boolean)value;
                    break;
                }
                Trace.error("EnsChannel.setOpt()", "(" + option + ", " + value + "): value has " + "to be Boolean");
                break;
            }
            case 2: {
                if (value instanceof Boolean) {
                    this.receive_suspects = (Boolean)value;
                    break;
                }
                Trace.error("EnsChannel.setOpt()", "(" + option + ", " + value + "): value has " + "to be Boolean");
                break;
            }
            case 0: {
                if (value instanceof Boolean) {
                    this.receive_blocks = (Boolean)value;
                } else {
                    Trace.error("EnsChannel.setOpt()", "(" + option + ", " + value + "): value has " + "to be Boolean");
                }
                if (!this.receive_blocks) break;
                this.receive_views = true;
                break;
            }
            case 3: {
                if (value instanceof Boolean) {
                    this.receive_local_msgs = (Boolean)value;
                    break;
                }
                Trace.error("EnsChannel.setOpt()", "(" + option + ", " + value + "): value has " + "to be Boolean");
                break;
            }
            default: {
                Trace.error("EnsChannel.setOpt()", "(" + option + ", " + value + "): option not known");
            }
        }
    }

    public Object getOpt(int option) {
        switch (option) {
            case 1: {
                return new Boolean(this.receive_views);
            }
            case 2: {
                return new Boolean(this.receive_suspects);
            }
            case 0: {
                return new Boolean(this.receive_blocks);
            }
            case 3: {
                return new Boolean(this.receive_local_msgs);
            }
        }
        Trace.error("EnsChannel.getOpt()", "(" + option + "): option not known");
        return null;
    }

    public void blockOk() {
    }

    public boolean getState(Address target, long timeout) {
        return false;
    }

    public boolean getAllStates(Vector targets, long timeout) {
        return false;
    }

    public void returnState(Object state) {
    }

    public void receiveCast(Hot_GroupContext gctx, Object env, Hot_Endpoint origin, Hot_Message msg) {
        Hot_ObjectMessage tmp = new Hot_ObjectMessage(msg);
        Message m = (Message)tmp.getObject();
        if (m == null) {
            Trace.warn("EnsChannel.receiveCast()", "received message that is not of type Message. Discarding.");
            return;
        }
        if (m.getSrc() == null) {
            m.setSrc(origin);
        }
        if (!this.receive_local_msgs && this.my_addr != null && m.getSrc() != null && this.my_addr.equals(m.getSrc())) {
            return;
        }
        try {
            this.mq.add(new Event(5, m));
        }
        catch (Exception e) {
            Trace.error("EnsChannel.receiveCast()", "exception=" + e);
        }
    }

    public void receiveSend(Hot_GroupContext gctx, Object env, Hot_Endpoint origin, Hot_Message msg) {
        this.receiveCast(gctx, env, origin, msg);
    }

    public void acceptedView(Hot_GroupContext gctx, Object env, Hot_ViewState viewState) {
        Hot_ViewID vid = viewState.view_id;
        Hot_Endpoint coord = vid.coord;
        long id = vid.ltime;
        Vector<Hot_Endpoint> members = new Vector<Hot_Endpoint>();
        if (this.my_addr == null && viewState.members != null && viewState.nmembers == 1) {
            this.my_addr = viewState.members[0];
            Trace.info("EnsChannel.acceptedView()", "my address is " + this.my_addr);
        }
        int i = 0;
        while (i < viewState.members.length) {
            members.addElement(viewState.members[i]);
            ++i;
        }
        View v = new View(coord, id, members);
        if (this.my_view == null) {
            this.my_view = v;
        }
        if (!this.receive_views) {
            return;
        }
        try {
            this.mq.add(new Event(10, v));
        }
        catch (Exception e) {
            Trace.error("EnsChannel.acceptedView()", "exception=" + e);
        }
    }

    public void heartbeat(Hot_GroupContext gctx, Object env, int rate) {
    }

    public void block(Hot_GroupContext gctx, Object env) {
        if (!this.receive_blocks) {
            return;
        }
        try {
            this.mq.add(new Event(16));
        }
        catch (Exception e) {
            Trace.error("EnsChannel.block()", "exception=" + e);
        }
    }

    public void exit(Hot_GroupContext gctx, Object env) {
        Trace.info("EnsChannel.exit()", "received EXIT message !");
    }
}

