/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups;

import java.io.Serializable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.BlockEvent;
import org.javagroups.Channel;
import org.javagroups.ChannelClosedException;
import org.javagroups.ChannelException;
import org.javagroups.ChannelNotConnectedException;
import org.javagroups.Event;
import org.javagroups.ExitEvent;
import org.javagroups.GetStateEvent;
import org.javagroups.Message;
import org.javagroups.SetStateEvent;
import org.javagroups.SuspectEvent;
import org.javagroups.TimeoutException;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.ProtocolStack;
import org.javagroups.stack.StateTransferInfo;
import org.javagroups.util.Queue;
import org.javagroups.util.QueueClosedException;
import org.javagroups.util.Util;

public class JChannel
extends Channel {
    private String props = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32):PING(timeout=3000;num_initial_members=6):FD(timeout=5000):VERIFY_SUSPECT(timeout=1500):pbcast.STABLE(desired_avg_gossip=10000):pbcast.NAKACK(gc_lag=10;retransmit_timeout=3000):UNICAST(timeout=5000;min_wait_time=2000):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=false)";
    private Address my_addr = null;
    private String channel_name = null;
    private View my_view = null;
    private Queue mq = new Queue();
    private ProtocolStack prot_stack = null;
    private Object cleanup_mutex = new Object();
    private Object connect_mutex = new Object();
    private Object disconnect_mutex = new Object();
    private Object get_state_mutex = new Object();
    private Object flow_control_mutex = new Object();
    private long timeout = 5000L;
    private long CLOSER_THREAD_TIMEOUT = 2000L;
    private long GET_STATE_DEFAULT_TIMEOUT = 5000L;
    private boolean receive_views = true;
    private boolean receive_suspects = true;
    private boolean receive_blocks = false;
    private boolean receive_local_msgs = true;
    private boolean receive_get_states = false;
    private boolean auto_reconnect = false;
    private boolean auto_getstate = false;
    private boolean connected = false;
    private boolean block_sending = false;
    private boolean closed = false;
    private Object state = null;

    private void checkNotConnected() throws ChannelNotConnectedException {
        if (!this.connected) {
            throw new ChannelNotConnectedException();
        }
    }

    private void checkClosed() throws ChannelClosedException {
        if (this.closed) {
            throw new ChannelClosedException();
        }
    }

    protected JChannel(boolean dummy) throws ChannelException {
    }

    public JChannel() throws ChannelException {
        this(null);
    }

    public JChannel(Object properties) throws ChannelException {
        if (properties != null) {
            if (properties instanceof String) {
                this.props = (String)properties;
            } else {
                throw new ChannelException("JChannel: properties must be of type String");
            }
        }
        this.prot_stack = new ProtocolStack(this, this.props);
        try {
            this.prot_stack.setup();
        }
        catch (Throwable e) {
            throw new ChannelException("JChannel(): " + e);
        }
    }

    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    public String getProperties() {
        return this.props;
    }

    public String printProtocolSpec(boolean include_properties) {
        return this.prot_stack != null ? this.prot_stack.printProtocolSpec(include_properties) : null;
    }

    public synchronized void connect(String channel_name) throws ChannelClosedException {
        this.checkClosed();
        if (this.connected) {
            Trace.error("JChannel.connect()", "already connected to " + channel_name);
            return;
        }
        if (channel_name == null) {
            Trace.error("JChannel.connect()", "channel_name is null");
            return;
        }
        this.channel_name = channel_name;
        try {
            this.prot_stack.start();
        }
        catch (Throwable e) {
            Trace.error("JChannel.connect()", "exception: " + e);
            return;
        }
        Vector<Address> t = new Vector<Address>();
        t.addElement(this.my_addr);
        this.my_view = new View(this.my_addr, 0L, t);
        Object object = this.connect_mutex;
        synchronized (object) {
            Event connect_event = new Event(6, channel_name);
            this.down(connect_event);
            try {
                this.connect_mutex.wait();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.connected = true;
        if (this.channel_listener != null) {
            this.channel_listener.channelConnected(this);
        }
    }

    public synchronized void disconnect() {
        if (this.closed) {
            return;
        }
        if (this.connected) {
            Event disconnect_event = new Event(8, this.my_addr);
            Object object = this.disconnect_mutex;
            synchronized (object) {
                try {
                    long t1 = System.currentTimeMillis();
                    this.down(disconnect_event);
                    this.disconnect_mutex.wait();
                }
                catch (Exception e) {
                    Trace.error("JChannel.disconnect()", "exception: " + e);
                }
            }
            this.down(new Event(29));
            Event cleanup_event = new Event(13);
            Object object2 = this.cleanup_mutex;
            synchronized (object2) {
                try {
                    this.down(cleanup_event);
                    this.cleanup_mutex.wait(5000L);
                }
                catch (Exception e) {
                    Trace.error("JChannel.disconnect()", "exception: " + e);
                }
            }
            this.connected = false;
            try {
                this.prot_stack.stop();
            }
            catch (Exception e) {
                Trace.error("JChannel.disconnect()", "exception: " + e);
            }
            if (this.channel_listener != null) {
                this.channel_listener.channelDisconnected(this);
            }
        }
    }

    public synchronized void close() {
        this._close(true, true);
    }

    public synchronized void open() throws ChannelException {
        if (!this.closed) {
            throw new ChannelException("JChannel.open(): channel is already open");
        }
        try {
            this.mq.reset();
            this.prot_stack.setup();
            this.closed = false;
        }
        catch (Exception e) {
            throw new ChannelException("JChannel().open(): " + e.getMessage());
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.checkClosed();
        this.checkNotConnected();
        if (this.block_sending) {
            Object object = this.flow_control_mutex;
            synchronized (object) {
                while (this.block_sending) {
                    try {
                        if (Trace.trace) {
                            Trace.info("JChannel.send()", "send() blocks because block_sending == true");
                        }
                        this.flow_control_mutex.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.down(new Event(5, msg));
    }

    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        Object retval = null;
        this.checkClosed();
        this.checkNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.remove() : (Event)this.mq.remove(timeout);
            return this.getEvent(evt);
        }
        catch (QueueClosedException queue_closed) {
            throw new ChannelClosedException();
        }
        catch (TimeoutException t) {
            throw t;
        }
        catch (Exception e) {
            Trace.error("JChannel.receive()", "exception: " + e);
            return null;
        }
    }

    public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        Object retval = null;
        this.checkClosed();
        this.checkNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.peek() : (Event)this.mq.peek(timeout);
            return this.getEvent(evt);
        }
        catch (QueueClosedException queue_closed) {
            Trace.error("JChannel.peek()", "exception: " + queue_closed);
            return null;
        }
        catch (TimeoutException t) {
            return null;
        }
        catch (Exception e) {
            Trace.error("JChannel.peek()", "exception: " + e);
            return null;
        }
    }

    private Object getEvent(Event evt) {
        if (evt == null) {
            return null;
        }
        switch (evt.getType()) {
            case 5: {
                return evt.getArg();
            }
            case 10: {
                return evt.getArg();
            }
            case 15: {
                return new SuspectEvent(evt.getArg());
            }
            case 16: {
                return new BlockEvent();
            }
            case 23: {
                return new GetStateEvent(evt.getArg());
            }
            case 27: {
                return new SetStateEvent(evt.getArg());
            }
            case 52: {
                return new ExitEvent();
            }
        }
        return evt;
    }

    public View getView() {
        return this.closed || !this.connected ? null : this.my_view;
    }

    public Address getLocalAddress() {
        return this.closed ? null : this.my_addr;
    }

    public String getChannelName() {
        return this.closed ? null : (!this.connected ? null : this.channel_name);
    }

    public void setOpt(int option, Object value) {
        if (this.closed) {
            Trace.warn("JChannel.setOpt()", "channel is closed; option not set !");
            return;
        }
        switch (option) {
            case 1: {
                if (value instanceof Boolean) {
                    this.receive_views = (Boolean)value;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 2: {
                if (value instanceof Boolean) {
                    this.receive_suspects = (Boolean)value;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 0: {
                if (value instanceof Boolean) {
                    this.receive_blocks = (Boolean)value;
                } else {
                    Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                }
                if (!this.receive_blocks) break;
                this.receive_views = true;
                break;
            }
            case 4: {
                if (value instanceof Boolean) {
                    this.receive_get_states = (Boolean)value;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 3: {
                if (value instanceof Boolean) {
                    this.receive_local_msgs = (Boolean)value;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 5: {
                if (value instanceof Boolean) {
                    this.auto_reconnect = (Boolean)value;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            case 6: {
                if (value instanceof Boolean) {
                    this.auto_getstate = (Boolean)value;
                    if (!this.auto_getstate) break;
                    this.auto_reconnect = true;
                    break;
                }
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean");
                break;
            }
            default: {
                Trace.error("JChannel.setOpt()", "option " + Channel.option2String(option) + " not known");
            }
        }
    }

    public Object getOpt(int option) {
        if (this.closed) {
            return null;
        }
        switch (option) {
            case 1: {
                return new Boolean(this.receive_views);
            }
            case 0: {
                return new Boolean(this.receive_blocks);
            }
            case 2: {
                return new Boolean(this.receive_suspects);
            }
            case 4: {
                return new Boolean(this.receive_get_states);
            }
            case 3: {
                return new Boolean(this.receive_local_msgs);
            }
        }
        Trace.error("JChannel.getOpt()", "option " + Channel.option2String(option) + " not known");
        return null;
    }

    public void blockOk() {
        this.down(new Event(17));
        this.down(new Event(28));
    }

    public boolean getState(Address target, long timeout) {
        StateTransferInfo info = new StateTransferInfo(1, target);
        return this._getState(new Event(25, info), timeout);
    }

    public boolean getAllStates(Vector targets, long timeout) {
        StateTransferInfo info = new StateTransferInfo(2, targets);
        return this._getState(new Event(25, info), timeout);
    }

    public void returnState(Object state) {
        this.down(new Event(24, state));
    }

    private boolean _getState(Event evt, long timeout) {
        Object object = this.get_state_mutex;
        synchronized (object) {
            this.state = null;
            this.down(evt);
            try {
                if (timeout <= 0L) {
                    this.get_state_mutex.wait();
                } else {
                    this.get_state_mutex.wait(timeout);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.state != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public void up(Event evt) {
        int type = evt.getType();
        if (this.mq == null) {
            Trace.error("JChannel.up()", "message queue is null");
            return;
        }
        switch (type) {
            case 5: {
                Message msg = (Message)evt.getArg();
                if (this.receive_local_msgs || this.my_addr == null || msg.getSrc() == null || !this.my_addr.equals(msg.getSrc())) break;
                return;
            }
            case 10: {
                this.my_view = (View)evt.getArg();
                this.down(new Event(29));
                if (this.receive_views) break;
                return;
            }
            case 15: {
                if (this.receive_suspects) break;
                return;
            }
            case 23: {
                if (this.receive_get_states) break;
                this.down(new Event(24, null));
                return;
            }
            case 16: {
                if (this.receive_blocks) break;
                this.down(new Event(17));
                this.down(new Event(28));
                return;
            }
            case 7: {
                Object object = this.connect_mutex;
                synchronized (object) {
                    this.connect_mutex.notify();
                    break;
                }
            }
            case 9: {
                Object object = this.disconnect_mutex;
                synchronized (object) {
                    this.disconnect_mutex.notifyAll();
                    break;
                }
            }
            case 14: {
                Object object = this.cleanup_mutex;
                synchronized (object) {
                    this.cleanup_mutex.notifyAll();
                    break;
                }
            }
            case 26: {
                try {
                    this.mq.add(new Event(27, evt.getArg()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                Object object = this.get_state_mutex;
                synchronized (object) {
                    this.state = evt.getArg();
                    this.get_state_mutex.notify();
                    break;
                }
            }
            case 12: {
                this.my_addr = (Address)evt.getArg();
                break;
            }
            case 52: {
                this.handleExit(evt);
                return;
            }
            case 60: {
                Object object = this.flow_control_mutex;
                synchronized (object) {
                    if (Trace.trace) {
                        Trace.info("JChannel.up()", "received BLOCK_SEND");
                    }
                    this.block_sending = true;
                    this.flow_control_mutex.notifyAll();
                    break;
                }
            }
            case 61: {
                Object object = this.flow_control_mutex;
                synchronized (object) {
                    if (Trace.trace) {
                        Trace.info("JChannel.up()", "received UNBLOCK_SEND");
                    }
                    this.block_sending = false;
                    this.flow_control_mutex.notifyAll();
                    break;
                }
            }
        }
        if (this.up_handler != null) {
            this.up_handler.up(evt);
            return;
        }
        if (type == 5 || type == 10 || type == 15 || type == 23 || type == 16 || type == 52) {
            try {
                this.mq.add(evt);
            }
            catch (Exception e) {
                Trace.error("JChannel.up()", "exception: " + e);
            }
        }
    }

    public void down(Event evt) {
        if (this.prot_stack != null) {
            this.prot_stack.down(evt);
        } else {
            Trace.error("JChannel.down()", "no protocol stack available");
        }
    }

    void _close(boolean disconnect, boolean close_mq) {
        if (this.closed) {
            return;
        }
        if (disconnect) {
            this.disconnect();
        }
        if (close_mq) {
            try {
                this.mq.close(false);
            }
            catch (Exception e) {
                Trace.error("JChannel._close()", "exception: " + e);
            }
        }
        if (this.prot_stack != null) {
            try {
                this.prot_stack.stop();
                this.prot_stack.destroy();
            }
            catch (Exception e) {
                Trace.error("JChannel._close()", "exception: " + e);
            }
        }
        this.closed = true;
        this.connected = false;
        if (this.channel_listener != null) {
            this.channel_listener.channelClosed(this);
        }
    }

    void handleExit(Event evt) {
        if (this.channel_listener != null) {
            this.channel_listener.channelShunned();
        }
        new CloserThread(evt);
    }

    class CloserThread
    implements Runnable {
        Event evt;
        Thread t = null;

        CloserThread(Event evt) {
            this.evt = evt;
            this.start();
        }

        public void start() {
            this.t = new Thread((Runnable)this, "CloserThread");
            this.t.start();
        }

        public void run() {
            try {
                JChannel.this._close(false, false);
                if (JChannel.this.up_handler != null) {
                    JChannel.this.up_handler.up(this.evt);
                } else {
                    try {
                        JChannel.this.mq.add(this.evt);
                    }
                    catch (Exception ex) {
                        Trace.error("JChannel.CloserThread.run()", "exception: " + ex);
                    }
                }
                if (JChannel.this.mq != null) {
                    Util.sleep(500L);
                    try {
                        JChannel.this.mq.close(false);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (JChannel.this.auto_reconnect) {
                    try {
                        Trace.info("JChannel.CloserThread.run()", "reconnecting to group " + JChannel.this.channel_name);
                        JChannel.this.open();
                        JChannel.this.connect(JChannel.this.channel_name);
                        if (JChannel.this.channel_listener != null) {
                            JChannel.this.channel_listener.channelReconnected(JChannel.this.my_addr);
                        }
                    }
                    catch (Exception ex) {
                        Trace.error("JChannel.CloserThread.run()", "failure reopening channel: " + ex);
                        return;
                    }
                }
                if (JChannel.this.auto_getstate) {
                    boolean rc = JChannel.this.getState(null, JChannel.this.GET_STATE_DEFAULT_TIMEOUT);
                    if (rc) {
                        Trace.info("JChannel.CloserThread.run()", "state was retrieved successfully");
                    } else {
                        Trace.info("JChannel.CloserThread.run()", "state transfer failed");
                    }
                }
            }
            catch (Exception ex) {
                Trace.error("JChannel.CloserThread.run()", "exception: " + ex);
            }
        }
    }
}

