/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Header;
import org.javagroups.log.Trace;
import org.javagroups.util.Stack;

public class Message
implements Externalizable {
    protected Address dest_addr = null;
    protected Address src_addr = null;
    protected byte[] buf = null;
    protected Stack headers = new Stack();
    static final long ADDRESS_OVERHEAD = 200L;

    public Message(Address dest, Address src, byte[] buf) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.buf = buf;
    }

    public Message(Address dest, Address src, Serializable obj) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setObject(obj);
    }

    public Message() {
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = new_dest;
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = new_src;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void setBuffer(byte[] b) {
        this.buf = b;
    }

    public Stack getHeaders() {
        return this.headers;
    }

    public void setHeaders(Stack h) {
        this.headers = h;
    }

    public void setObject(Serializable obj) {
        if (obj == null) {
            return;
        }
        try {
            ByteArrayOutputStream out_stream = new ByteArrayOutputStream(256);
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            this.buf = out_stream.toByteArray();
        }
        catch (Exception e) {
            Trace.error("Message.setObject()", "exception=" + e);
        }
    }

    public Object getObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            ByteArrayInputStream in_stream = new ByteArrayInputStream(this.buf);
            ObjectInputStream in = new ObjectInputStream(in_stream);
            return in.readObject();
        }
        catch (Exception e) {
            Trace.error("Message.getObject()", "exception=" + e);
            return null;
        }
    }

    public void addHeader(Header hdr) {
        this.headers.push(hdr);
    }

    public Header removeHeader() {
        return (Header)this.headers.pop();
    }

    public void removeHeaders() {
        this.headers.removeAll();
    }

    public Header peekHeader() {
        return (Header)this.headers.peek();
    }

    public Message copy() {
        Message retval = new Message();
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        if (this.buf != null) {
            retval.buf = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, retval.buf, 0, this.buf.length);
        }
        retval.headers = (Stack)this.headers.copy();
        return retval;
    }

    public Message makeReply() {
        return new Message(this.src_addr, null, null);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        if (!this.headers.empty()) {
            ret.append(" (" + this.headers.size() + " headers)");
        }
        ret.append(", size = ");
        if (this.buf != null && this.buf.length > 0) {
            ret.append(this.buf.length);
        } else {
            ret.append("0");
        }
        ret.append(" bytes");
        ret.append("]");
        return ret.toString();
    }

    public String toStringAsObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            Object obj = this.getObject();
            return obj != null ? obj.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public long size() {
        long retval = this.buf != null ? (long)this.buf.length : 0L;
        long hdr_size = 0L;
        if (this.dest_addr != null) {
            retval += 200L;
        }
        if (this.src_addr != null) {
            retval += 200L;
        }
        Enumeration e = this.headers.elements();
        while (e.hasMoreElements()) {
            Header hdr = (Header)e.nextElement();
            if (hdr == null) continue;
            hdr_size = 0L;
            hdr_size = hdr.size();
            if (hdr_size <= 0L) {
                hdr_size = 255L;
            }
            retval += hdr_size;
        }
        return retval;
    }

    public String printObjectHeaders() {
        StringBuffer retval = new StringBuffer();
        Vector contents = this.headers.getContents();
        int i = 0;
        while (i < contents.size()) {
            Object hdr = contents.elementAt(i);
            if (hdr != null) {
                retval.append("\nHeader #" + i + ": " + hdr.toString());
            }
            ++i;
        }
        return retval.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.dest_addr);
        out.writeObject(this.src_addr);
        if (this.buf == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.buf.length);
            out.write(this.buf);
        }
        this.headers.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dest_addr = (Address)in.readObject();
        this.src_addr = (Address)in.readObject();
        int i = in.readInt();
        if (i != 0) {
            this.buf = new byte[i];
            in.readFully(this.buf);
        }
        if (this.headers != null) {
            this.headers.removeAll();
        } else {
            this.headers = new Stack();
        }
        this.headers.readExternal(in);
    }
}

