/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.stack.IpAddress;
import org.javagroups.util.Util;

public class ConnectionTable
implements Runnable {
    Hashtable conns = new Hashtable();
    Receiver receiver = null;
    ServerSocket srv_sock = null;
    InetAddress bind_addr = null;
    Address local_addr = null;
    int srv_port = 7800;
    Thread acceptor = null;
    Vector members = new Vector();
    final int backlog = 20;
    Vector conn_listeners = new Vector();
    Object recv_mutex = new Object();

    private ConnectionTable() {
    }

    public ConnectionTable(int srv_port) throws Exception {
        this.srv_port = srv_port;
        this.start();
    }

    public ConnectionTable(Receiver r, InetAddress bind_addr, int srv_port) throws Exception {
        this.setReceiver(r);
        this.bind_addr = bind_addr;
        this.srv_port = srv_port;
        this.start();
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public void addConnectionListener(ConnectionListener l) {
        if (l != null && !this.conn_listeners.contains(l)) {
            this.conn_listeners.addElement(l);
        }
    }

    public void removeConnectionListener(ConnectionListener l) {
        if (l != null) {
            this.conn_listeners.removeElement(l);
        }
    }

    public Address getLocalAddress() {
        if (this.local_addr == null) {
            this.local_addr = this.bind_addr != null ? new IpAddress(this.bind_addr, this.srv_port) : null;
        }
        return this.local_addr;
    }

    public void setMembers(Vector m) {
        if (m == null || m.size() == 0) {
            return;
        }
        Vector vector = this.members;
        synchronized (vector) {
            this.members.removeAllElements();
            int i = 0;
            while (i < m.size()) {
                this.members.addElement(m.elementAt(i));
                ++i;
            }
        }
    }

    public void send(Message msg) {
        Address dest;
        Address address = dest = msg != null ? msg.getDest() : null;
        if (dest == null) {
            Trace.error("ConnectionTable.send()", "msg is null or message's destination is null");
            return;
        }
        Connection conn = this.getConnection(dest);
        if (conn == null) {
            Trace.info("ConnectionTable.send()", "connection to " + dest + " could not be established");
            return;
        }
        conn.send(msg);
    }

    Connection getConnection(Address dest) {
        Connection conn = null;
        Hashtable hashtable = this.conns;
        synchronized (hashtable) {
            conn = (Connection)this.conns.get(dest);
            if (conn == null) {
                try {
                    Socket sock = new Socket(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort());
                    conn = new Connection(sock, dest);
                    conn.sendLocalAddress(this.local_addr);
                    this.notifyConnectionOpened(dest);
                    this.conns.put(dest, conn);
                    conn.init();
                    if (Trace.trace) {
                        Trace.info("ConnectionTable.getConnection()", "created socket to " + dest);
                    }
                }
                catch (Throwable e) {
                    if (Trace.trace) {
                        Trace.info("ConnectionTable.getConnection()", "to " + dest + ", exception=" + e);
                    }
                    Connection connection = null;
                    return connection;
                }
            }
            Connection connection = conn;
            return connection;
        }
    }

    public void start() throws Exception {
        this.srv_sock = this.createServerSocket(this.srv_port);
        this.local_addr = this.bind_addr != null ? new IpAddress(this.bind_addr, this.srv_sock.getLocalPort()) : new IpAddress(this.srv_sock.getLocalPort());
        if (Trace.trace) {
            if (this.bind_addr != null) {
                Trace.info("ConnectionTable.start()", "server socket created on " + this.bind_addr + ":" + this.srv_port);
            } else {
                Trace.info("ConnectionTable.start()", "server socket listening on port " + this.srv_port);
            }
        }
        this.acceptor = new Thread((Runnable)this, "ConnectionTable.AcceptorThread");
        this.acceptor.start();
    }

    public void stop() {
        Iterator it = null;
        if (this.srv_sock != null) {
            try {
                ServerSocket tmp = this.srv_sock;
                this.srv_sock = null;
                tmp.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Hashtable hashtable = this.conns;
        synchronized (hashtable) {
            it = this.conns.values().iterator();
            while (it.hasNext()) {
                Connection conn = (Connection)it.next();
                conn.destroy();
            }
            this.conns.clear();
        }
        this.local_addr = null;
    }

    public void remove(Address addr) {
        Hashtable hashtable = this.conns;
        synchronized (hashtable) {
            Connection conn = (Connection)this.conns.get(addr);
            if (conn != null) {
                try {
                    conn.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.conns.remove(addr);
            }
            if (Trace.trace) {
                Trace.info("ConnectionTable.remove()", "addr=" + addr + ", connections are " + this.toString());
            }
        }
    }

    public void adjustOutgoingConnections(Vector new_mbrship) {
        if (new_mbrship == null || new_mbrship.size() == 0) {
            return;
        }
        Hashtable hashtable = this.conns;
        synchronized (hashtable) {
            Enumeration en = this.conns.keys();
            while (en.hasMoreElements()) {
                Address addr = (Address)en.nextElement();
                if (new_mbrship.contains(addr)) continue;
                this.remove(addr);
            }
        }
    }

    public void run() {
        Connection conn = null;
        while (this.srv_sock != null) {
            try {
                Socket client_sock = this.srv_sock.accept();
                if (Trace.trace) {
                    Trace.info("ConnectionTable.run()", "accepted connection, client_sock=" + client_sock);
                }
                conn = new Connection(client_sock, null);
                Address peer_addr = conn.readPeerAddress();
                conn.setPeerAddress(peer_addr);
                Hashtable hashtable = this.conns;
                synchronized (hashtable) {
                    if (this.conns.contains(peer_addr)) {
                        if (Trace.trace) {
                            Trace.warn("ConnectionTable.run()", peer_addr + " is already there, will terminate connection");
                        }
                        conn.destroy();
                        return;
                    }
                    this.conns.put(peer_addr, conn);
                }
                this.notifyConnectionOpened(peer_addr);
                conn.init();
            }
            catch (SocketException sock_ex) {
                if (Trace.trace) {
                    Trace.info("ConnectionTable.run()", "exception is " + sock_ex);
                }
                if (conn != null) {
                    conn.destroy();
                }
                if (this.srv_sock != null) continue;
                break;
            }
            catch (Throwable ex) {
                if (!Trace.trace) continue;
                Trace.warn("ConnectionTable.run()", "exception is " + ex);
            }
        }
    }

    public void receive(Message msg) {
        if (this.receiver != null) {
            Object object = this.recv_mutex;
            synchronized (object) {
                this.receiver.receive(msg);
            }
        } else {
            Trace.error("ConnectionTable.receive()", "receiver is null (not set) !");
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Hashtable hashtable = this.conns;
        synchronized (hashtable) {
            ret.append("connections (" + this.conns.size() + "):\n");
            Enumeration e = this.conns.keys();
            while (e.hasMoreElements()) {
                Address key = (Address)e.nextElement();
                Connection val = (Connection)this.conns.get(key);
                ret.append("key: " + key.toString() + ": " + val.toString() + "\n");
            }
        }
        ret.append("\n");
        return ret.toString();
    }

    ServerSocket createServerSocket(int start_port) throws Exception {
        ServerSocket ret = null;
        while (true) {
            try {
                if (this.bind_addr == null) {
                    ret = new ServerSocket(start_port);
                    break;
                }
                ret = new ServerSocket(start_port, 20, this.bind_addr);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                Trace.error("ConnectionTable.createServerSocket()", "exception is " + io_ex);
            }
            break;
        }
        this.srv_port = start_port;
        return ret;
    }

    void notifyConnectionOpened(Address peer) {
        if (peer == null) {
            return;
        }
        int i = 0;
        while (i < this.conn_listeners.size()) {
            ((ConnectionListener)this.conn_listeners.elementAt(i)).connectionOpened(peer);
            ++i;
        }
    }

    void notifyConnectionClosed(Address peer) {
        if (peer == null) {
            return;
        }
        int i = 0;
        while (i < this.conn_listeners.size()) {
            ((ConnectionListener)this.conn_listeners.elementAt(i)).connectionClosed(peer);
            ++i;
        }
    }

    class Connection
    implements Runnable {
        Socket sock = null;
        DataOutputStream out = null;
        DataInputStream in = null;
        Thread handler = null;
        Address peer_addr = null;
        Object send_mutex = new Object();
        final byte[] cookie = new byte[]{98, 101, 108, 97};

        Connection(Socket s, Address peer_addr) {
            this.sock = s;
            this.peer_addr = peer_addr;
            try {
                this.out = new DataOutputStream(this.sock.getOutputStream());
                this.in = new DataInputStream(this.sock.getInputStream());
            }
            catch (Exception ex) {
                Trace.error("ConnectionTable.Connection()", "exception is " + ex);
            }
        }

        void setPeerAddress(Address peer_addr) {
            this.peer_addr = peer_addr;
        }

        void init() {
            if (Trace.trace) {
                Trace.info("ConnectionTable.Connection.init()", "connection was created to " + this.peer_addr);
            }
            if (this.handler == null) {
                this.handler = new Thread((Runnable)this, "ConnectionTable.Connection.HandlerThread");
                this.handler.start();
            }
        }

        void destroy() {
            this.closeSocket();
            this.handler = null;
        }

        void send(Message msg) {
            Object object = this.send_mutex;
            synchronized (object) {
                block12: {
                    try {
                        this.doSend(msg);
                    }
                    catch (IOException io_ex) {
                        if (Trace.trace) {
                            Trace.warn("ConnectionTable.Connection.Send()", "peer closed connection, trying to re-establish connection and re-send msg.");
                        }
                        try {
                            this.doSend(msg);
                        }
                        catch (IOException io_ex2) {
                            if (Trace.trace) {
                                Trace.error("ConnectionTable.Connection.send()", "2nd attempt to send data failed too");
                            }
                        }
                        catch (Exception ex2) {
                            if (Trace.trace) {
                                Trace.error("ConnectionTable.Connection.send()", "exception is " + ex2);
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!Trace.trace) break block12;
                        Trace.error("ConnectionTable.Connection.send()", "exception is " + ex);
                    }
                }
            }
        }

        void doSend(Message msg) throws Exception {
            IpAddress dst_addr = (IpAddress)msg.getDest();
            byte[] buffie = null;
            if (dst_addr == null || dst_addr.getIpAddress() == null) {
                Trace.error("ConnectionTable.Connection.doSend()", "the destination address is null; aborting send");
                return;
            }
            try {
                if (msg.getSrc() == null) {
                    msg.setSrc(ConnectionTable.this.local_addr);
                }
                if ((buffie = Util.objectToByteBuffer(msg)).length <= 0) {
                    Trace.error("ConnectionTable.Connection.doSend()", "buffer.length is 0. Will not send message");
                    return;
                }
                if (this.out != null) {
                    this.out.writeInt(buffie.length);
                    Util.doubleWrite(buffie, this.out);
                    this.out.flush();
                }
            }
            catch (Exception ex) {
                if (Trace.trace) {
                    Trace.error("ConnectionTable.Connection.doSend()", "to " + dst_addr + ", exception is " + ex + ", stack trace:\n" + Util.getStackTrace(ex));
                }
                ConnectionTable.this.remove(dst_addr);
                throw ex;
            }
        }

        Address readPeerAddress() throws Exception {
            Address peer_addr = null;
            int len = 0;
            if (this.in != null) {
                byte[] input_cookie = new byte[this.cookie.length];
                this.initCookie(input_cookie);
                this.in.read(input_cookie, 0, input_cookie.length);
                if (!this.matchCookie(input_cookie)) {
                    throw new SocketException("ConnectionTable.Connection.readPeerAddress(): cookie sent by " + peer_addr + " does not match own cookie; terminating connection");
                }
                len = this.in.readInt();
                byte[] buf = new byte[len];
                this.in.readFully(buf, 0, len);
                peer_addr = (Address)Util.objectFromByteBuffer(buf);
            }
            return peer_addr;
        }

        void sendLocalAddress(Address local_addr) {
            if (local_addr == null) {
                Trace.warn("ConnectionTable.Connection.sendLocalAddress()", "local_addr is null");
                return;
            }
            if (this.out != null) {
                try {
                    byte[] buf = Util.objectToByteBuffer(local_addr);
                    this.out.write(this.cookie, 0, this.cookie.length);
                    this.out.writeInt(buf.length);
                    this.out.write(buf, 0, buf.length);
                    this.out.flush();
                }
                catch (Exception ex) {
                    Trace.error("ConnectionTable.Connection.sendLocalAddress()", "exception is " + ex);
                }
            }
        }

        void initCookie(byte[] c) {
            if (c != null) {
                int i = 0;
                while (i < c.length) {
                    c[i] = 0;
                    ++i;
                }
            }
        }

        boolean matchCookie(byte[] input) {
            if (input == null || input.length != this.cookie.length) {
                return false;
            }
            if (Trace.trace) {
                Trace.info("ConnectionTable.Connection.matchCookie()", "input_cookie is " + this.printCookie(input));
            }
            int i = 0;
            while (i < this.cookie.length) {
                if (this.cookie[i] != input[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        String printCookie(byte[] c) {
            if (c == null) {
                return "";
            }
            return new String(c);
        }

        public void run() {
            byte[] buf = new byte[256];
            int len = 0;
            while (this.handler != null) {
                try {
                    if (this.in == null) {
                        Trace.error("ConnectionTable.Connection.run()", "input stream is null !");
                        break;
                    }
                    len = this.in.readInt();
                    if (len > buf.length) {
                        buf = new byte[len];
                    }
                    this.in.readFully(buf, 0, len);
                    Message msg = (Message)Util.objectFromByteBuffer(buf);
                    ConnectionTable.this.receive(msg);
                }
                catch (OutOfMemoryError mem_ex) {
                    Trace.warn("ConnectionTable.Connection.run()", "dropped invalid message, closing connection");
                    break;
                }
                catch (EOFException eof_ex) {
                    Trace.info("ConnectionTable.Connection.run()", "exception is " + eof_ex);
                    ConnectionTable.this.notifyConnectionClosed(this.peer_addr);
                    break;
                }
                catch (IOException io_ex) {
                    Trace.info("ConnectionTable.Connection.run()", "exception is " + io_ex);
                    ConnectionTable.this.notifyConnectionClosed(this.peer_addr);
                    break;
                }
                catch (Exception e) {
                    Trace.warn("ConnectionTable.Connection.run()", "exception is " + e);
                }
            }
            this.handler = null;
            this.closeSocket();
            ConnectionTable.this.remove(this.peer_addr);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            InetAddress local = null;
            InetAddress remote = null;
            if (this.sock == null) {
                ret.append("<null socket>");
            } else {
                local = this.sock.getLocalAddress();
                remote = this.sock.getInetAddress();
                String local_str = local != null ? Util.shortName(local.getHostName()) : "<null>";
                String remote_str = remote != null ? Util.shortName(local.getHostName()) : "<null>";
                ret.append("<local: " + local_str + ":" + this.sock.getLocalPort() + ", remote: " + remote_str + ":" + this.sock.getPort() + ">");
            }
            return ret.toString();
        }

        void closeSocket() {
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sock = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.out = null;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.in = null;
            }
        }
    }

    public static interface ConnectionListener {
        public void connectionOpened(Address var1);

        public void connectionClosed(Address var1);
    }

    public static interface Receiver {
        public void receive(Message var1);
    }
}

