/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.ChannelFactory;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.View;
import org.javagroups.blocks.RpcDispatcher;
import org.javagroups.log.Trace;

public class DistributedHashtable
extends Hashtable
implements MessageListener,
MembershipListener,
Cloneable {
    private transient Channel channel;
    private transient RpcDispatcher disp = null;
    private transient String groupname = null;
    private transient Vector notifs = new Vector();
    private transient Vector members = new Vector();

    public DistributedHashtable(String groupname, ChannelFactory factory, String properties, long state_timeout) {
        this.groupname = groupname;
        try {
            this.channel = factory != null ? factory.createChannel(properties) : new JChannel(properties);
            this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, this);
            this.channel.connect(groupname);
            this.channel.setOpt(4, new Boolean(true));
            boolean rc = this.channel.getState(null, state_timeout);
            if (rc) {
                Trace.info("DistributedHashtable.DistributedHashtable()", "state was retrieved successfully");
            } else {
                Trace.info("DistributedHashtable.DistributedHashtable()", "state could not be retrieved (first member)");
            }
        }
        catch (Exception e) {
            Trace.error("DistributedHashtable.DistributedHashtable()", "exception=" + e);
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public void addNotifier(Notification n) {
        if (!this.notifs.contains(n)) {
            this.notifs.addElement(n);
        }
    }

    public Object put(Object key, Object value) {
        Object prev_val = this.get(key);
        try {
            this.disp.callRemoteMethods(null, "_put", key, value, 2, 0L);
            return prev_val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void clear() {
        try {
            this.disp.callRemoteMethods(null, "_clear", 2, 0L);
        }
        catch (Exception e) {
            Trace.error("DistributedHashtable.clear()", "exception=" + e);
        }
    }

    public Object remove(Object key) {
        Object retval = this.get(key);
        try {
            this.disp.callRemoteMethods(null, "_remove", key, 2, 0L);
            return retval;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object _put(Object key, Object value) {
        Object retval = super.put(key, value);
        int i = 0;
        while (i < this.notifs.size()) {
            ((Notification)this.notifs.elementAt(i)).entrySet(key, value);
            ++i;
        }
        return retval;
    }

    public void _clear() {
        super.clear();
    }

    public Object _remove(Object key) {
        Object retval = super.remove(key);
        int i = 0;
        while (i < this.notifs.size()) {
            ((Notification)this.notifs.elementAt(i)).entryRemoved(key);
            ++i;
        }
        return retval;
    }

    public void receive(Message msg) {
    }

    public Object getState() {
        Hashtable copy = new Hashtable();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = this.get(key);
            copy.put(key, val);
        }
        return copy;
    }

    public void setState(Object new_state) {
        Hashtable new_copy = (Hashtable)new_state;
        if (new_copy == null) {
            return;
        }
        this._clear();
        Enumeration e = new_copy.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this._put(key, new_copy.get(key));
        }
    }

    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            int i = 0;
            while (i < new_mbrs.size()) {
                this.members.addElement(new_mbrs.elementAt(i));
                ++i;
            }
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        if (this.notifs.size() == 0 || old_mbrs == null || new_mbrs == null || old_mbrs.size() == 0 || new_mbrs.size() == 0) {
            return;
        }
        Vector joined = new Vector();
        int i = 0;
        while (i < new_mbrs.size()) {
            mbr = new_mbrs.elementAt(i);
            if (!old_mbrs.contains(mbr)) {
                joined.addElement(mbr);
            }
            ++i;
        }
        Vector left = new Vector();
        int i2 = 0;
        while (i2 < old_mbrs.size()) {
            mbr = old_mbrs.elementAt(i2);
            if (!new_mbrs.contains(mbr)) {
                left.addElement(mbr);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.notifs.size()) {
            Notification n = (Notification)this.notifs.elementAt(i3);
            n.viewChange(joined, left);
            ++i3;
        }
    }

    public static interface Notification {
        public void entrySet(Object var1, Object var2);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);
    }
}

