/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.View;
import org.javagroups.blocks.RpcDispatcher;
import org.javagroups.log.Trace;

public class DistributedTree
implements MessageListener,
org.javagroups.MembershipListener,
Cloneable {
    Node root = null;
    Vector listeners = new Vector();
    Vector view_listeners = new Vector();
    Vector members = new Vector();
    Channel channel = null;
    RpcDispatcher disp = null;
    String groupname = "DistributedTreeGroup";
    String channel_properties = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=0):PING(timeout=5000;num_initial_members=6):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.STABLE(desired_avg_gossip=10000):pbcast.NAKACK(gc_lag=5;retransmit_timeout=3000;trace=true):UNICAST(timeout=5000;min_wait_time=2000):FRAG(down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER(trace=true)";
    long state_timeout = 5000L;

    public DistributedTree() {
    }

    public DistributedTree(String groupname, String channel_properties) {
        this.groupname = groupname;
        if (channel_properties != null) {
            this.channel_properties = channel_properties;
        }
    }

    public Object getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public void start() throws Exception {
        if (this.channel != null) {
            return;
        }
        this.channel = new JChannel(this.channel_properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (org.javagroups.MembershipListener)this, this);
        this.channel.connect(this.groupname);
        this.channel.setOpt(4, new Boolean(true));
        boolean rc = this.channel.getState(null, 8000L);
        if (rc) {
            Trace.info("DistributedTree.start()", "state was retrieved successfully");
        } else {
            Trace.info("DistributedTree.start()", "state could not be retrieved (must be first member in group)");
        }
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.close();
            this.disp.stop();
        }
        this.channel = null;
        this.disp = null;
    }

    public void addDistributedTreeListener(DistributedTreeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeDistributedTreeListener(DistributedTreeListener listener) {
        this.listeners.removeElement(listener);
    }

    public void addMembershipListener(MembershipListener listener) {
        if (!this.view_listeners.contains(listener)) {
            this.view_listeners.addElement(listener);
        }
    }

    public void removeMembershipListener(MembershipListener listener) {
        this.view_listeners.removeElement(listener);
    }

    public void add(String fqn) {
        try {
            this.disp.callRemoteMethods(null, "_add", fqn, 2, 0L);
        }
        catch (Exception ex) {
            Trace.error("DistributedTree.add()", "exception=" + ex);
        }
    }

    public void add(String fqn, Serializable element) {
        try {
            this.disp.callRemoteMethods(null, "_add", fqn, element, 2, 0L);
        }
        catch (Exception ex) {
            Trace.error("DistributedTree.add()", "exception=" + ex);
        }
    }

    public void remove(String fqn) {
        try {
            this.disp.callRemoteMethods(null, "_remove", fqn, 2, 0L);
        }
        catch (Exception ex) {
            Trace.error("DistributedTree.remove()", "exception=" + ex);
        }
    }

    public boolean exists(String fqn) {
        if (fqn == null) {
            return false;
        }
        return this.findNode(fqn) != null;
    }

    public Serializable get(String fqn) {
        Node n = null;
        if (fqn == null) {
            return null;
        }
        n = this.findNode(fqn);
        if (n != null) {
            return n.element;
        }
        return null;
    }

    public void set(String fqn, Serializable element) {
        try {
            this.disp.callRemoteMethods(null, "_set", fqn, element, 2, 0L);
        }
        catch (Exception ex) {
            Trace.error("DistributedTree.set()", "exception=" + ex);
        }
    }

    public Vector getChildrenNames(String fqn) {
        Vector<String> ret = new Vector<String>();
        if (fqn == null) {
            return ret;
        }
        Node n = this.findNode(fqn);
        if (n == null || n.children == null) {
            return ret;
        }
        int i = 0;
        while (i < n.children.size()) {
            ret.addElement(((Node)n.children.elementAt((int)i)).name);
            ++i;
        }
        return ret;
    }

    public String print() {
        StringBuffer sb = new StringBuffer();
        int indent = 0;
        Node curr = this.root;
        if (this.root == null) {
            return "/";
        }
        sb.append(this.root.print(indent));
        return sb.toString();
    }

    Vector getChildren(String fqn) {
        if (fqn == null) {
            return null;
        }
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.children;
    }

    public void _add(String fqn) {
        this._add(fqn, null);
    }

    public void _add(String fqn, Serializable element) {
        String tmp_fqn = "";
        if (this.root == null) {
            this.root = new Node("/", null);
            this.notifyNodeAdded("/", null);
        }
        if (fqn == null) {
            return;
        }
        Node curr = this.root;
        StringTokenizer tok = new StringTokenizer(fqn, "/");
        while (tok.hasMoreTokens()) {
            String child_name = tok.nextToken();
            tmp_fqn = tmp_fqn + "/" + child_name;
            Node n = curr.findChild(child_name);
            if (n == null) {
                n = new Node(child_name, null);
                curr.addChild(n);
                if (!tok.hasMoreTokens()) {
                    n.element = element;
                    this.notifyNodeAdded(tmp_fqn, element);
                    return;
                }
                this.notifyNodeAdded(tmp_fqn, null);
            }
            curr = n;
        }
        curr.element = element;
        this.notifyNodeModified(fqn, null, element);
    }

    public void _remove(String fqn) {
        Node n;
        String child_name = null;
        String tmp_fqn = "";
        if (fqn == null || this.root == null) {
            return;
        }
        Node curr = this.root;
        StringTokenizer tok = new StringTokenizer(fqn, "/");
        while (tok.countTokens() > 1) {
            child_name = tok.nextToken();
            n = curr.findChild(child_name);
            if (n == null) {
                return;
            }
            curr = n;
        }
        try {
            child_name = tok.nextToken();
            if (child_name != null && (n = curr.removeChild(child_name)) != null) {
                this.notifyNodeRemoved(fqn);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void _set(String fqn, Serializable element) {
        Serializable old_el = null;
        if (fqn == null || element == null) {
            return;
        }
        Node n = this.findNode(fqn);
        if (n == null) {
            Trace.error("DistributedTree._set()", "node " + fqn + " not found");
            return;
        }
        old_el = n.element;
        n.element = element;
        this.notifyNodeModified(fqn, old_el, element);
    }

    public void receive(Message msg) {
    }

    public Object getState() {
        Node copy = this.root != null ? this.root.copy() : null;
        return copy;
    }

    public void setState(Object new_state) {
        if (new_state == null) {
            return;
        }
        if (!(new_state instanceof Node)) {
            Trace.error("DistributedTree.setState()", "object is not of type 'Node'");
            return;
        }
        this.root = ((Node)new_state).copy();
    }

    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            int i = 0;
            while (i < new_mbrs.size()) {
                this.members.addElement(new_mbrs.elementAt(i));
                ++i;
            }
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        if (this.view_listeners.size() == 0 || old_mbrs == null || new_mbrs == null) {
            return;
        }
        Vector joined = new Vector();
        int i = 0;
        while (i < new_mbrs.size()) {
            mbr = new_mbrs.elementAt(i);
            if (!old_mbrs.contains(mbr)) {
                joined.addElement(mbr);
            }
            ++i;
        }
        Vector left = new Vector();
        int i2 = 0;
        while (i2 < old_mbrs.size()) {
            mbr = old_mbrs.elementAt(i2);
            if (!new_mbrs.contains(mbr)) {
                left.addElement(mbr);
            }
            ++i2;
        }
        this.notifyViewChange(joined, left);
    }

    Node findNode(String fqn) {
        Node curr = this.root;
        if (fqn == null || this.root == null) {
            return null;
        }
        if (fqn.equals("/") || fqn.equals("")) {
            return this.root;
        }
        StringTokenizer tok = new StringTokenizer(fqn, "/");
        while (tok.hasMoreTokens()) {
            String child_name = tok.nextToken();
            if ((curr = curr.findChild(child_name)) != null) continue;
            return null;
        }
        return curr;
    }

    void notifyNodeAdded(String fqn, Serializable element) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DistributedTreeListener)this.listeners.elementAt(i)).nodeAdded(fqn, element);
            ++i;
        }
    }

    void notifyNodeRemoved(String fqn) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DistributedTreeListener)this.listeners.elementAt(i)).nodeRemoved(fqn);
            ++i;
        }
    }

    void notifyNodeModified(String fqn, Serializable old_element, Serializable new_element) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DistributedTreeListener)this.listeners.elementAt(i)).nodeModified(fqn, old_element, new_element);
            ++i;
        }
    }

    void notifyAllNodesCreated(Node curr, String tmp_fqn) {
        if (curr == null) {
            return;
        }
        if (curr.name == null) {
            Trace.error("DistributedTree.notifyAllNodesCreated()", "curr.name is null");
            return;
        }
        if (curr.children != null) {
            int i = 0;
            while (i < curr.children.size()) {
                Node n = (Node)curr.children.elementAt(i);
                System.out.println("*** nodeAdded(): tmp_fqn is " + tmp_fqn);
                this.notifyNodeAdded(tmp_fqn, n.element);
                this.notifyAllNodesCreated(n, tmp_fqn + "/" + n.name);
                ++i;
            }
        }
    }

    void notifyViewChange(Vector new_mbrs, Vector old_mbrs) {
        int i = 0;
        while (i < this.view_listeners.size()) {
            ((MembershipListener)this.view_listeners.elementAt(i)).viewChange(new_mbrs, old_mbrs);
            ++i;
        }
    }

    private static class Node
    implements Serializable {
        String name = null;
        Vector children = null;
        Serializable element = null;

        Node() {
        }

        Node(String name, Serializable element) {
            this.name = name;
            this.element = element;
        }

        void addChild(String relative_name, Serializable element) {
            if (relative_name == null) {
                return;
            }
            if (this.children == null) {
                this.children = new Vector();
            } else if (!this.children.contains(relative_name)) {
                this.children.addElement(new Node(relative_name, element));
            }
        }

        void addChild(Node n) {
            if (n == null) {
                return;
            }
            if (this.children == null) {
                this.children = new Vector();
            }
            if (!this.children.contains(n)) {
                this.children.addElement(n);
            }
        }

        Node removeChild(String rel_name) {
            Node n = this.findChild(rel_name);
            if (n != null) {
                this.children.removeElement(n);
            }
            return n;
        }

        Node findChild(String relative_name) {
            if (this.children == null || relative_name == null) {
                return null;
            }
            int i = 0;
            while (i < this.children.size()) {
                Node child = (Node)this.children.elementAt(i);
                if (child.name == null) {
                    Trace.error("Node.findChild()", "child.name is null for " + relative_name);
                } else if (child.name.equals(relative_name)) {
                    return child;
                }
                ++i;
            }
            return null;
        }

        public boolean equals(Object other) {
            return other != null && ((Node)other).name != null && this.name != null && this.name.equals(((Node)other).name);
        }

        Node copy() {
            Node ret = new Node(this.name, this.element);
            if (this.children != null) {
                ret.children = (Vector)this.children.clone();
            }
            return ret;
        }

        String print(int indent) {
            StringBuffer sb = new StringBuffer();
            boolean is_root = this.name != null && this.name.equals("/");
            int i = 0;
            while (i < indent) {
                sb.append(" ");
                ++i;
            }
            if (!is_root) {
                if (this.name == null) {
                    sb.append("/<unnamed>");
                } else {
                    sb.append("/" + this.name);
                }
            }
            sb.append("\n");
            if (this.children != null) {
                indent = is_root ? 0 : (indent += 4);
                int i2 = 0;
                while (i2 < this.children.size()) {
                    sb.append(((Node)this.children.elementAt(i2)).print(indent));
                    ++i2;
                }
            }
            return sb.toString();
        }

        public String toString() {
            if (this.element != null) {
                return "[name: " + this.name + ", element: " + this.element + "]";
            }
            return "[name: " + this.name + "]";
        }
    }

    public static interface MembershipListener {
        public void viewChange(Vector var1, Vector var2);
    }

    public static interface DistributedTreeListener {
        public void nodeAdded(String var1, Serializable var2);

        public void nodeRemoved(String var1);

        public void nodeModified(String var1, Serializable var2, Serializable var3);
    }
}

