/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.blocks.RequestCorrelator;
import org.javagroups.blocks.RspCollector;
import org.javagroups.log.Trace;
import org.javagroups.util.Command;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;

public class GroupRequest
implements RspCollector,
Command {
    public static final int GET_FIRST = 1;
    public static final int GET_ALL = 2;
    public static final int GET_MAJORITY = 3;
    public static final int GET_ABS_MAJORITY = 4;
    public static final int GET_N = 5;
    public static final int GET_NONE = 6;
    private final short NOT_RECEIVED = 0;
    private final short RECEIVED = 1;
    private final short SUSPECTED = (short)2;
    private Address[] membership = null;
    private Object[] responses = null;
    private short[] received = null;
    private Vector suspects = new Vector();
    protected Message request_msg = null;
    protected RequestCorrelator corr = null;
    protected int rsp_mode = 2;
    protected boolean done = false;
    protected Object rsp_mutex = new Object();
    protected long timeout = 0L;
    protected int expected_mbrs = 0;

    public GroupRequest(Message m, RequestCorrelator corr, Vector members, int rsp_mode) {
        this.request_msg = m;
        this.corr = corr;
        this.rsp_mode = rsp_mode;
        this.reset(members);
        this.suspects.removeAllElements();
    }

    public GroupRequest(Message m, RequestCorrelator corr, Vector members, int rsp_mode, long timeout, int expected_mbrs) {
        this(m, corr, members, rsp_mode);
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.expected_mbrs = expected_mbrs;
    }

    public synchronized boolean execute() {
        if (this.corr == null) {
            Trace.error("GroupRequest.execute()", "corr == null");
            return false;
        }
        Object object = this.rsp_mutex;
        synchronized (object) {
            this.done = false;
            boolean retval = this.doExecute(this.timeout);
            this.done = true;
            boolean bl = retval;
            return bl;
        }
    }

    public void reset(Message m, int mode, long timeout) {
        Object object = this.rsp_mutex;
        synchronized (object) {
            this.done = false;
            this.request_msg = m;
            this.rsp_mode = mode;
            this.timeout = timeout;
        }
    }

    public void reset(Message m, Vector members, int rsp_mode, long timeout, int expected_rsps) {
        Object object = this.rsp_mutex;
        synchronized (object) {
            this.reset(m, rsp_mode, timeout);
            this.reset(members);
            this.suspects.removeAllElements();
            this.expected_mbrs = this.expected_mbrs;
        }
    }

    public void reset(Vector members) {
        block3: {
            block2: {
                if (members == null) break block2;
                int size = members.size();
                this.membership = new Address[size];
                this.responses = new Object[size];
                this.received = new short[size];
                int i = 0;
                while (i < size) {
                    this.membership[i] = (Address)members.elementAt(i);
                    this.responses[i] = null;
                    this.received[i] = 0;
                    ++i;
                }
                break block3;
            }
            if (this.membership == null) break block3;
            int i = 0;
            while (i < this.membership.length) {
                this.responses[i] = null;
                this.received[i] = 0;
                ++i;
            }
        }
    }

    public void receiveResponse(Message m) {
        Address sender = m.getSrc();
        Object val = null;
        if (this.done) {
            Trace.warn("GroupRequest.receiveResponse()", "command is done; cannot add response !");
            return;
        }
        if (this.suspects != null && this.suspects.size() > 0 && this.suspects.contains(sender)) {
            Trace.warn("GroupRequest.receiveResponse()", "received response from suspected member " + sender + "; discarding");
            return;
        }
        if (m.getBuffer() != null) {
            try {
                val = Util.objectFromByteBuffer(m.getBuffer());
            }
            catch (Exception e) {
                Trace.error("GroupRequest.receiveResponse()", "exception=" + e);
            }
        }
        Object object = this.rsp_mutex;
        synchronized (object) {
            int i = 0;
            while (i < this.membership.length) {
                Address mbr = this.membership[i];
                if (mbr.equals(sender) && this.received[i] == 0) {
                    this.responses[i] = val;
                    this.received[i] = 1;
                    this.rsp_mutex.notifyAll();
                    break;
                }
                ++i;
            }
        }
    }

    public void suspect(Address suspected_member) {
        Object object = this.rsp_mutex;
        synchronized (object) {
            int i = 0;
            while (i < this.membership.length) {
                Address mbr = this.membership[i];
                if (mbr.equals(suspected_member) && !this.suspects.contains(suspected_member)) {
                    this.suspects.addElement(suspected_member);
                    this.responses[i] = null;
                    this.received[i] = 2;
                    this.rsp_mutex.notifyAll();
                    break;
                }
                ++i;
            }
        }
    }

    public void viewChange(View new_view) {
        Vector mbrs;
        Vector vector = mbrs = new_view != null ? new_view.getMembers() : null;
        if (this.membership == null || this.membership.length == 0 || mbrs == null) {
            return;
        }
        int i = 0;
        while (i < this.membership.length) {
            Address mbr = this.membership[i];
            if (!mbrs.contains(mbr)) {
                this.suspect(mbr);
            }
            ++i;
        }
    }

    public RspList getResults() {
        RspList retval = new RspList();
        Object object = this.rsp_mutex;
        synchronized (object) {
            int i = 0;
            while (i < this.membership.length) {
                Address sender = this.membership[i];
                switch (this.received[i]) {
                    case 2: {
                        retval.addSuspect(sender);
                        break;
                    }
                    case 1: {
                        retval.addRsp(sender, this.responses[i]);
                        break;
                    }
                    case 0: {
                        retval.addNotReceived(sender);
                    }
                }
                ++i;
            }
            RspList rspList = retval;
            return rspList;
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("[GroupRequest:\n");
        ret.append("members: ");
        int i = 0;
        while (i < this.membership.length) {
            ret.append(this.membership[i] + " ");
            ++i;
        }
        ret.append("\nresponses: ");
        int i2 = 0;
        while (i2 < this.responses.length) {
            ret.append(this.responses[i2] + " ");
            ++i2;
        }
        if (this.suspects.size() > 0) {
            ret.append("\nsuspects: " + this.suspects);
        }
        ret.append("\nrequest_msg: " + this.request_msg);
        ret.append("\nrsp_mode: " + this.rsp_mode);
        ret.append("\ndone: " + this.done);
        ret.append("\ntimeout: " + this.timeout);
        ret.append("\nexpected_mbrs: " + this.expected_mbrs);
        ret.append("\n]");
        return ret.toString();
    }

    public int getNumSuspects() {
        return this.suspects.size();
    }

    public Vector getSuspects() {
        return this.suspects;
    }

    public boolean isDone() {
        return this.done;
    }

    protected int determineMajority(int i) {
        return i < 2 ? i : i / 2 + 1;
    }

    protected boolean doExecute(long timeout) {
        boolean retval = false;
        long start_time = 0L;
        long req_id = System.currentTimeMillis();
        this.reset(null);
        if (this.suspects != null) {
            int i = 0;
            while (i < this.suspects.size()) {
                Address suspect = (Address)this.suspects.elementAt(i);
                int j = 0;
                while (j < this.membership.length) {
                    Address mbr = this.membership[j];
                    if (mbr.equals(suspect)) {
                        this.received[j] = 2;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        try {
            if (this.rsp_mode == 6) {
                this.corr.sendRequest(req_id, this.request_msg, null);
                return true;
            }
            this.corr.sendRequest(req_id, this.request_msg, this);
        }
        catch (Exception e) {
            Trace.error("GroupRequest.doExecute()", "exception=" + e);
            this.corr.done(req_id);
            return false;
        }
        if (timeout <= 0L) {
            while (true) {
                if (this.getResponses()) {
                    this.corr.done(req_id);
                    return true;
                }
                try {
                    this.rsp_mutex.wait();
                }
                catch (Exception e) {}
            }
        }
        start_time = System.currentTimeMillis();
        while (timeout > 0L) {
            if (this.getResponses()) {
                this.corr.done(req_id);
                return true;
            }
            if ((timeout -= System.currentTimeMillis() - start_time) <= 0L) continue;
            try {
                this.rsp_mutex.wait(timeout);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.corr.done(req_id);
        return false;
    }

    protected boolean getResponses() {
        int num_not_received = this.getNum(0);
        int num_received = this.getNum(1);
        int num_suspected = this.getNum(2);
        int num_total = this.membership.length;
        int majority = this.determineMajority(num_total);
        switch (this.rsp_mode) {
            case 1: {
                if (num_received > 0) {
                    return true;
                }
                if (num_suspected < num_total) break;
                return true;
            }
            case 2: {
                return num_not_received <= 0;
            }
            case 3: {
                if (num_received + num_suspected < majority) break;
                return true;
            }
            case 4: {
                if (num_received < majority) break;
                return true;
            }
            case 5: {
                if (this.expected_mbrs >= num_total) {
                    this.rsp_mode = 2;
                    return this.getResponses();
                }
                if (num_received >= this.expected_mbrs) {
                    return true;
                }
                if (num_received + num_not_received < this.expected_mbrs) {
                    return num_received + num_suspected >= this.expected_mbrs;
                }
                return false;
            }
            case 6: {
                return true;
            }
            default: {
                Trace.error("GroupRequest.execute()", "rsp_mode " + this.rsp_mode + " unknown !");
            }
        }
        return false;
    }

    int getNum(int type) {
        int retval = 0;
        int i = 0;
        while (i < this.received.length) {
            if (this.received[i] == type) {
                ++retval;
            }
            ++i;
        }
        return retval;
    }

    void printReceived() {
        int i = 0;
        while (i < this.received.length) {
            System.out.println(this.membership[i] + ": " + (this.received[i] == 0 ? "NOT_RECEIVED" : (this.received[i] == 1 ? "RECEIVED" : "SUSPECTED")));
            ++i;
        }
    }
}

