/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.ChannelClosedException;
import org.javagroups.ChannelNotConnectedException;
import org.javagroups.Event;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.SuspectedException;
import org.javagroups.TimeoutException;
import org.javagroups.UpHandler;
import org.javagroups.View;
import org.javagroups.blocks.GroupRequest;
import org.javagroups.blocks.RequestCorrelator;
import org.javagroups.blocks.RequestHandler;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Rsp;
import org.javagroups.util.RspList;

public class MessageDispatcher
extends Protocol
implements UpHandler,
RequestHandler {
    protected Channel channel = null;
    protected RequestCorrelator corr = null;
    protected MessageListener msg_listener = null;
    protected MembershipListener membership_listener = null;
    protected RequestHandler req_handler = null;
    protected Vector members = new Vector();
    protected Address local_addr = null;
    protected boolean deadlock_detection = true;

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2) {
        this.channel = channel;
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, boolean deadlock_detection) {
        this.channel = channel;
        this.deadlock_detection = deadlock_detection;
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this(channel, l, l2);
        this.setRequestHandler(req_handler);
    }

    public void finalize() {
        this.stop();
    }

    public void start() {
        if (this.corr == null) {
            this.corr = new RequestCorrelator("MessageDispatcher", this, this, this.deadlock_detection);
            this.corr.start();
        }
    }

    public void stop() {
        if (this.corr != null) {
            this.corr.stop();
            this.corr = null;
        }
    }

    public void setMessageListener(MessageListener l) {
        this.channel.setOpt(4, new Boolean(true));
        this.msg_listener = l;
    }

    public void setMembershipListener(MembershipListener l) {
        this.channel.setOpt(1, new Boolean(true));
        this.membership_listener = l;
    }

    public void setRequestHandler(RequestHandler rh) {
        this.req_handler = rh;
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        if (this.channel != null) {
            this.channel.send(msg);
        } else {
            Trace.error("MessageDispatcher.send()", "channel == null");
        }
    }

    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        Vector real_dests;
        GroupRequest _req = null;
        Vector vector = real_dests = dests != null ? dests : this.members;
        if (this.channel.getOpt(3).equals(new Boolean(false))) {
            if (this.local_addr == null) {
                this.local_addr = this.channel.getLocalAddress();
            }
            if (this.local_addr != null) {
                real_dests.removeElement(this.local_addr);
            }
        }
        _req = new GroupRequest(msg, this.corr, real_dests, mode, timeout, 0);
        _req.execute();
        return _req.getResults();
    }

    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        Rsp rsp;
        Vector<Address> mbrs = new Vector<Address>();
        RspList rsp_list = null;
        Address dest = msg.getDest();
        GroupRequest _req = null;
        if (dest == null) {
            Trace.error("MessageProtocol.sendMessage()", "the message's destination is null, cannot send message");
            return null;
        }
        mbrs.addElement(dest);
        _req = new GroupRequest(msg, this.corr, mbrs, mode, timeout, 0);
        _req.execute();
        if (mode == 6) {
            return null;
        }
        rsp_list = _req.getResults();
        if (rsp_list.size() == 0) {
            Trace.warn("MessageProtocol.sendMessage()", " response list is empty");
            return null;
        }
        if (rsp_list.size() > 1) {
            Trace.warn("MessageProtocol.sendMessage()", "response list contains more that 1 response; returning first response !");
        }
        if ((rsp = (Rsp)rsp_list.elementAt(0)).wasSuspected()) {
            throw new SuspectedException(dest);
        }
        if (!rsp.wasReceived()) {
            throw new TimeoutException();
        }
        return rsp.getValue();
    }

    public Object handle(Message msg) {
        if (this.req_handler != null) {
            return this.req_handler.handle(msg);
        }
        return null;
    }

    public String getName() {
        return "MessageDispatcher";
    }

    public void startUpHandler() {
    }

    public void startDownHandler() {
    }

    public void stopInternal() {
    }

    protected void receiveUpEvent(Event evt) {
    }

    protected void receiveDownEvent(Event evt) {
    }

    public void passUp(Event evt) {
        switch (evt.getType()) {
            case 5: {
                if (this.msg_listener == null) break;
                this.msg_listener.receive((Message)evt.getArg());
                break;
            }
            case 23: {
                if (this.msg_listener != null) {
                    this.channel.returnState(this.msg_listener.getState());
                    break;
                }
                this.channel.returnState(null);
                break;
            }
            case 26: {
                if (this.msg_listener == null) break;
                try {
                    this.msg_listener.setState(evt.getArg());
                }
                catch (ClassCastException cast_ex) {
                    Trace.error("MessageDispatcher.passUp()", "received SetStateEvent, but argument " + evt.getArg() + " is not serializable. Discarding message.");
                }
                break;
            }
            case 10: {
                View v = (View)evt.getArg();
                Vector new_mbrs = v.getMembers();
                if (new_mbrs != null) {
                    this.members.removeAllElements();
                    int i = 0;
                    while (i < new_mbrs.size()) {
                        this.members.addElement(new_mbrs.elementAt(i));
                        ++i;
                    }
                }
                if (this.membership_listener == null) break;
                this.membership_listener.viewAccepted(v);
                break;
            }
            case 15: {
                if (this.membership_listener == null) break;
                this.membership_listener.suspect((Address)evt.getArg());
                break;
            }
            case 16: {
                if (this.membership_listener == null) break;
                this.membership_listener.block();
            }
        }
    }

    public void passDown(Event evt) {
        this.down(evt);
    }

    public void up(Event evt) {
        if (this.corr != null) {
            this.corr.receive(evt);
        } else {
            Trace.error("MessageDispatcher.up()", "corr == null");
        }
    }

    public void down(Event evt) {
        if (this.channel != null) {
            this.channel.down(evt);
        } else {
            Trace.error("MessageDispatcher.down()", "channel == null");
        }
    }
}

