/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.javagroups.blocks.MethodLookup;
import org.javagroups.log.Trace;

public class MethodCall
implements Serializable {
    protected String method_name = null;
    protected Vector args = new Vector();

    public MethodCall() {
    }

    public MethodCall(String name) {
        this.method_name = name;
    }

    public MethodCall(String name, Object[] args) {
        this(name);
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                this.addArg(args[i]);
                ++i;
            }
        }
    }

    public MethodCall(String name, Object arg1) {
        this(name, new Object[]{arg1});
    }

    public MethodCall(String name, Object arg1, Object arg2) {
        this(name, new Object[]{arg1, arg2});
    }

    public MethodCall(String name, Object arg1, Object arg2, Object arg3) {
        this(name, new Object[]{arg1, arg2, arg3});
    }

    public MethodCall(String name, Object arg1, Object arg2, Object arg3, Object arg4) {
        this(name, new Object[]{arg1, arg2, arg3, arg4});
    }

    public MethodCall(String name, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this(name, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public String getName() {
        return this.method_name;
    }

    public void setName(String n) {
        this.method_name = n;
    }

    public Vector getArgs() {
        return this.args;
    }

    public void addArg(Object arg) {
        if (arg != null) {
            this.args.addElement(arg);
        }
    }

    public void addArg(byte b) {
        Byte obj = new Byte(b);
        this.args.addElement(obj);
    }

    public void addArg(char c) {
        Character obj = new Character(c);
        this.args.addElement(obj);
    }

    public void addArg(boolean b) {
        Boolean obj = new Boolean(b);
        this.args.addElement(obj);
    }

    public void addArg(int i) {
        Integer obj = new Integer(i);
        this.args.addElement(obj);
    }

    public void addArg(long l) {
        Long obj = new Long(l);
        this.args.addElement(obj);
    }

    Method findMethod(Class target_class, String method_name, Vector args) throws Exception {
        int len = args != null ? args.size() : 0;
        Class[] formal_parms = new Class[len];
        int i = 0;
        while (i < len) {
            formal_parms[i] = args.elementAt(i).getClass();
            ++i;
        }
        Method retval = target_class.getMethod(method_name, formal_parms);
        return retval;
    }

    /*
     * Unable to fully structure code
     */
    public Object invoke(Object target, MethodLookup lookup) {
        cl = target.getClass();
        retval = null;
        if (this.method_name == null) {
            System.out.println("Method name is not provided");
            return null;
        }
        try {
            meth = lookup == null ? this.findMethod(cl, this.method_name, this.args) : lookup.findMethod(cl, this.method_name, this.args);
            obj_args = new Object[this.args.size()];
            i = 0;
            while (i < this.args.size()) {
                obj_args[i] = this.args.elementAt(i);
                ++i;
            }
            if (meth != null) {
                retval = meth.invoke(target, obj_args);
            } else {
                Trace.error("MethodCall.invoke()", "method " + this.method_name + " not found");
            }
            return retval;
        }
        catch (IllegalArgumentException illegal_arg) {
            retval = illegal_arg;
        }
        catch (IllegalAccessException illegal_access) {
            retval = illegal_access;
            illegal_access.printStackTrace();
        }
        catch (InvocationTargetException inv_ex) {
            retval = inv_ex.getTargetException();
        }
        catch (NoSuchMethodException no) {
            System.out.print("MethodCall.invoke(): found no method called " + this.method_name + " in class " + cl.getName() + " with [");
            i = 0;
            ** while (i < this.args.size())
        }
lbl-1000:
        // 1 sources

        {
            if (i > 0) {
                System.out.print(", ");
            }
            System.out.print(this.args.elementAt(i).getClass());
            ++i;
            continue;
        }
lbl38:
        // 1 sources

        System.out.println("] formal parameters");
        return null;
        catch (Exception e) {
            Trace.error("MethodCall.invoke()", "exception=" + e);
        }
        return retval;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("MethodCall (name=" + this.method_name);
        ret.append(", number of args=" + this.args.size() + ")");
        ret.append("\nArgs:");
        int i = 0;
        while (i < this.args.size()) {
            ret.append("\n[" + this.args.elementAt(i) + " (" + this.args.elementAt(i).getClass().getName() + ")]");
            ++i;
        }
        return ret.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.method_name);
        out.writeObject(this.args);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.method_name = (String)in.readObject();
        this.args = (Vector)in.readObject();
    }
}

