/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.lang.reflect.Method;
import java.util.Vector;
import org.javagroups.blocks.MethodLookup;

public class MethodLookupClos
implements MethodLookup {
    static Class boolean_type = new Boolean(true).getClass();
    static Class char_type = new Character('0').getClass();
    static Class byte_type = new Byte(0).getClass();
    static Class short_type = new Short(0).getClass();
    static Class int_type = new Integer(0).getClass();
    static Class long_type = new Long(0L).getClass();
    static Class float_type = new Float(0.0f).getClass();
    static Class double_type = new Double(0.0).getClass();

    public Method findMethod(Class target_class, String method_name, Vector args) throws Exception {
        Method method;
        Method retval = null;
        Method[] methods = target_class.getMethods();
        Vector<Method> matching_methods = new Vector<Method>();
        int num_args = args.size();
        int rank = 1000;
        int new_rank = 0;
        int i = 0;
        while (i < methods.length) {
            method = methods[i];
            if (method.getName().equals(method_name) && method.getParameterTypes().length == num_args) {
                matching_methods.addElement(method);
            }
            ++i;
        }
        if (matching_methods.size() == 1) {
            return (Method)matching_methods.elementAt(0);
        }
        if (matching_methods.size() < 1) {
            throw new NoSuchMethodException();
        }
        int i2 = 0;
        while (i2 < matching_methods.size()) {
            method = (Method)matching_methods.elementAt(i2);
            new_rank = this.matchParameters(method, args);
            if (new_rank >= 0 && new_rank <= rank) {
                retval = method;
                rank = new_rank;
            }
            ++i2;
        }
        if (retval != null) {
            return retval;
        }
        throw new NoSuchMethodException();
    }

    int computeDistance(Class from, Class to) {
        int retval = 0;
        Class current = from;
        while (current != null) {
            if ((current = current.getSuperclass()) == null) break;
            if (current.equals(to)) {
                return ++retval;
            }
            ++retval;
        }
        return 0;
    }

    int computeDistanceFromPrimitive(Class primitive, Class arg) {
        if (primitive == Boolean.TYPE) {
            if (arg == boolean_type) {
                return 0;
            }
            return -1;
        }
        if (primitive == Character.TYPE) {
            if (arg == char_type) {
                return 0;
            }
            return -1;
        }
        if (primitive == Byte.TYPE) {
            if (arg == byte_type) {
                return 0;
            }
            return -1;
        }
        if (primitive == Short.TYPE) {
            if (arg == byte_type || arg == short_type || arg == int_type || arg == long_type || arg == float_type || arg == double_type) {
                if (arg == short_type) {
                    return 0;
                }
                if (arg == byte_type) {
                    return 1;
                }
                if (arg == int_type) {
                    return 2;
                }
                if (arg == long_type) {
                    return 3;
                }
                if (arg == float_type) {
                    return 4;
                }
                if (arg == double_type) {
                    return 5;
                }
            } else {
                return -1;
            }
        }
        if (primitive == Integer.TYPE) {
            if (arg == byte_type || arg == short_type || arg == int_type || arg == long_type || arg == float_type || arg == double_type) {
                if (arg == int_type) {
                    return 0;
                }
                if (arg == byte_type) {
                    return 1;
                }
                if (arg == short_type) {
                    return 2;
                }
                if (arg == long_type) {
                    return 3;
                }
                if (arg == float_type) {
                    return 4;
                }
                if (arg == double_type) {
                    return 5;
                }
            } else {
                return -1;
            }
        }
        if (primitive == Long.TYPE) {
            if (arg == byte_type || arg == short_type || arg == int_type || arg == long_type || arg == float_type || arg == double_type) {
                if (arg == long_type) {
                    return 0;
                }
                if (arg == byte_type) {
                    return 1;
                }
                if (arg == int_type) {
                    return 2;
                }
                if (arg == short_type) {
                    return 3;
                }
                if (arg == float_type) {
                    return 4;
                }
                if (arg == double_type) {
                    return 5;
                }
            } else {
                return -1;
            }
        }
        if (primitive == Float.TYPE) {
            if (arg == byte_type || arg == short_type || arg == int_type || arg == long_type || arg == float_type || arg == double_type) {
                if (arg == float_type) {
                    return 0;
                }
                if (arg == byte_type) {
                    return 1;
                }
                if (arg == int_type) {
                    return 2;
                }
                if (arg == long_type) {
                    return 3;
                }
                if (arg == short_type) {
                    return 4;
                }
                if (arg == double_type) {
                    return 5;
                }
            } else {
                return -1;
            }
        }
        if (primitive == Double.TYPE) {
            if (arg == byte_type || arg == short_type || arg == int_type || arg == long_type || arg == float_type || arg == double_type) {
                if (arg == double_type) {
                    return 0;
                }
                if (arg == byte_type) {
                    return 1;
                }
                if (arg == short_type) {
                    return 2;
                }
                if (arg == int_type) {
                    return 3;
                }
                if (arg == long_type) {
                    return 4;
                }
                if (arg == float_type) {
                    return 5;
                }
            } else {
                return -1;
            }
        }
        return -1;
    }

    int matchParameters(Method method, Vector args) {
        Class<?>[] formal_parms = method.getParameterTypes();
        int retval = 0;
        int i = 0;
        while (i < formal_parms.length) {
            Object arg = args.elementAt(i);
            Class<?> formal_parm = formal_parms[i];
            if (formal_parm.isPrimitive()) {
                int distance = this.computeDistanceFromPrimitive(formal_parm, arg.getClass());
                if (distance < 0) {
                    return -1;
                }
                retval += distance;
            } else if (formal_parm.equals(arg.getClass())) {
                retval += 0;
            } else {
                if (formal_parm.isInstance(arg)) {
                    int t = this.computeDistance(arg.getClass(), formal_parm);
                    return t;
                }
                return -1;
            }
            ++i;
        }
        return retval;
    }
}

