/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import org.javagroups.Address;
import org.javagroups.BlockEvent;
import org.javagroups.Channel;
import org.javagroups.ChannelNotConnectedException;
import org.javagroups.GetStateEvent;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.SetStateEvent;
import org.javagroups.SuspectEvent;
import org.javagroups.Transport;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.util.Util;

public class PullPushAdapter
implements Runnable {
    protected Transport transport = null;
    protected MessageListener listener = null;
    protected MembershipListener membership_listener = null;
    protected Thread receiver_thread = null;

    public PullPushAdapter(Transport transport) {
        this.transport = transport;
        this.start();
    }

    public PullPushAdapter(Transport transport, MessageListener l) {
        this.transport = transport;
        this.setListener(l);
        this.start();
    }

    public PullPushAdapter(Transport transport, MembershipListener ml) {
        this.transport = transport;
        this.setMembershipListener(ml);
        this.start();
    }

    public PullPushAdapter(Transport transport, MessageListener l, MembershipListener ml) {
        this.transport = transport;
        this.setListener(l);
        this.setMembershipListener(ml);
        this.start();
    }

    public void start() {
        if (this.receiver_thread == null) {
            this.receiver_thread = new Thread((Runnable)this, "PullPushAdapterThread");
            this.receiver_thread.start();
        }
    }

    public void stop() {
        Thread tmp = null;
        if (this.receiver_thread != null && this.receiver_thread.isAlive()) {
            tmp = this.receiver_thread;
            this.receiver_thread = null;
            tmp.interrupt();
            try {
                tmp.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.receiver_thread = null;
    }

    public void setListener(MessageListener l) {
        this.listener = l;
    }

    public void setMembershipListener(MembershipListener ml) {
        this.membership_listener = ml;
    }

    public void run() {
        while (this.receiver_thread != null) {
            try {
                Object obj = this.transport.receive(0L);
                if (obj == null) continue;
                if (obj instanceof Message) {
                    if (this.listener == null) continue;
                    this.listener.receive((Message)obj);
                    continue;
                }
                if (obj instanceof GetStateEvent) {
                    if (this.listener == null) continue;
                    if (this.transport instanceof Channel) {
                        ((Channel)this.transport).returnState(this.listener.getState());
                        continue;
                    }
                    Trace.error("PullPushAdapter.run()", "underlying transport is not a Channel, but a " + this.transport.getClass().getName() + ": cannot fetch state using returnState()");
                    continue;
                }
                if (obj instanceof SetStateEvent) {
                    if (this.listener == null) continue;
                    try {
                        this.listener.setState(((SetStateEvent)obj).getArg());
                    }
                    catch (ClassCastException cast_ex) {
                        Trace.error("PullPushAdapter.run()", "received SetStateEvent, but argument " + ((SetStateEvent)obj).getArg() + " is not serializable ! Discarding message.");
                    }
                    continue;
                }
                if (obj instanceof View) {
                    if (this.membership_listener == null) continue;
                    this.membership_listener.viewAccepted((View)obj);
                    continue;
                }
                if (obj instanceof SuspectEvent) {
                    if (this.membership_listener == null) continue;
                    this.membership_listener.suspect((Address)((SuspectEvent)obj).getMember());
                    continue;
                }
                if (!(obj instanceof BlockEvent) || this.membership_listener == null) continue;
                this.membership_listener.block();
            }
            catch (ChannelNotConnectedException conn) {
                Address local_addr = ((Channel)this.transport).getLocalAddress();
                Trace.warn("PullPushAdapter.run()", "[" + (local_addr == null ? "<null>" : local_addr.toString()) + "] channel not connected, exception is " + conn);
                Util.sleep(1000L);
                break;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }
}

