/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.ChannelFactory;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.View;
import org.javagroups.blocks.PullPushAdapter;
import org.javagroups.log.Trace;

public class ReplicatedHashtable
extends Hashtable
implements MessageListener,
MembershipListener,
Cloneable {
    private transient Channel channel;
    private transient PullPushAdapter adapter = null;
    private transient String groupname = null;
    private transient Vector notifs = new Vector();
    private transient Vector members = new Vector();

    public ReplicatedHashtable(String groupname, ChannelFactory factory, String properties, long state_timeout) {
        this.groupname = groupname;
        try {
            this.channel = factory != null ? factory.createChannel(properties) : new JChannel(properties);
            this.channel.connect(groupname);
            this.adapter = new PullPushAdapter(this.channel, this, this);
            this.adapter.setListener(this);
            this.channel.setOpt(4, new Boolean(true));
            boolean rc = this.channel.getState(null, state_timeout);
            if (rc) {
                Trace.info("ReplicatedHashtable.ReplicatedHashtable()", "state was retrieved successfully");
            } else {
                Trace.info("ReplicatedHashtable.ReplicatedHashtable()", "state could not be retrieved (first member)");
            }
        }
        catch (Exception e) {
            Trace.error("ReplicatedHashtable.ReplicatedHashtable()", "exception=" + e);
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public void addNotifier(Notification n) {
        if (!this.notifs.contains(n)) {
            this.notifs.addElement(n);
        }
    }

    public Object put(Object key, Object value) {
        Object prev_val = this.get(key);
        try {
            Message msg = new Message(null, null, new Request(1, key, value));
            this.channel.send(msg);
            return prev_val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void clear() {
        try {
            Message msg = new Message(null, null, new Request(3, null, null));
            this.channel.send(msg);
        }
        catch (Exception e) {
            Trace.error("ReplicatedHashtable.clear()", "exception=" + e);
        }
    }

    public Object remove(Object key) {
        Object retval = this.get(key);
        try {
            Message msg = new Message(null, null, new Request(2, key, null));
            this.channel.send(msg);
            return retval;
        }
        catch (Exception e) {
            return null;
        }
    }

    Object _put(Object key, Object value) {
        Object retval = super.put(key, value);
        int i = 0;
        while (i < this.notifs.size()) {
            ((Notification)this.notifs.elementAt(i)).entrySet(key, value);
            ++i;
        }
        return retval;
    }

    void _clear() {
        super.clear();
    }

    Object _remove(Object key) {
        Object retval = super.remove(key);
        int i = 0;
        while (i < this.notifs.size()) {
            ((Notification)this.notifs.elementAt(i)).entryRemoved(key);
            ++i;
        }
        return retval;
    }

    public void receive(Message msg) {
        if (msg == null) {
            return;
        }
        Request req = (Request)msg.getObject();
        if (req == null) {
            return;
        }
        switch (req.req_type) {
            case 1: {
                if (req.key == null || req.val == null) break;
                this._put(req.key, req.val);
                break;
            }
            case 2: {
                if (req.key == null) break;
                this._remove(req.key);
                break;
            }
            case 3: {
                this._clear();
                break;
            }
        }
    }

    public Object getState() {
        Hashtable copy = new Hashtable();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = this.get(key);
            copy.put(key, val);
        }
        return copy;
    }

    public void setState(Object new_state) {
        Hashtable new_copy = (Hashtable)new_state;
        if (new_copy == null) {
            return;
        }
        this._clear();
        Enumeration e = new_copy.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this._put(key, new_copy.get(key));
        }
    }

    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            int i = 0;
            while (i < new_mbrs.size()) {
                this.members.addElement(new_mbrs.elementAt(i));
                ++i;
            }
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        if (this.notifs.size() == 0 || old_mbrs == null || new_mbrs == null || old_mbrs.size() == 0 || new_mbrs.size() == 0) {
            return;
        }
        Vector joined = new Vector();
        int i = 0;
        while (i < new_mbrs.size()) {
            mbr = new_mbrs.elementAt(i);
            if (!old_mbrs.contains(mbr)) {
                joined.addElement(mbr);
            }
            ++i;
        }
        Vector left = new Vector();
        int i2 = 0;
        while (i2 < old_mbrs.size()) {
            mbr = old_mbrs.elementAt(i2);
            if (!new_mbrs.contains(mbr)) {
                left.addElement(mbr);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.notifs.size()) {
            Notification n = (Notification)this.notifs.elementAt(i3);
            n.viewChange(joined, left);
            ++i3;
        }
    }

    private static class Request
    implements Serializable {
        static final int PUT = 1;
        static final int REMOVE = 2;
        static final int CLEAR = 3;
        int req_type = 0;
        Object key = null;
        Object val = null;

        Request(int req_type, Object key, Object val) {
            this.req_type = req_type;
            this.key = key;
            this.val = val;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.type2String(this.req_type));
            if (this.key != null) {
                sb.append("\nkey=" + this.key);
            }
            if (this.val != null) {
                sb.append("\nval=" + this.val);
            }
            return sb.toString();
        }

        String type2String(int t) {
            switch (t) {
                case 1: {
                    return "PUT";
                }
                case 2: {
                    return "REMOVE";
                }
                case 3: {
                    return "CLEAR";
                }
            }
            return "<unknown>";
        }
    }

    public static interface Notification {
        public void entrySet(Object var1, Object var2);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);
    }
}

