/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.blocks.RequestHandler;
import org.javagroups.blocks.RspCollector;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Scheduler;
import org.javagroups.util.SchedulerListener;
import org.javagroups.util.Util;

public class RequestCorrelator {
    protected Protocol transport = null;
    protected Hashtable requests = new Hashtable();
    protected RequestHandler request_handler = null;
    protected String name = null;
    protected Scheduler scheduler = null;
    protected Address local_addr = null;
    protected Stack call_stack = null;
    protected boolean deadlock_detection = true;
    protected CallStackSetter call_stack_setter = new CallStackSetter();

    private void addEntry(long id, RequestEntry entry) {
        Long id_obj = new Long(id);
        Hashtable hashtable = this.requests;
        synchronized (hashtable) {
            if (!this.requests.containsKey(id_obj)) {
                this.requests.put(id_obj, entry);
            } else {
                Trace.warn("RequestCorrelator.addEntry()", "entry " + entry + " already present !");
            }
        }
    }

    private void removeEntry(long id) {
        Long id_obj = new Long(id);
        Hashtable hashtable = this.requests;
        synchronized (hashtable) {
            this.requests.remove(id_obj);
        }
    }

    private RspCollector findEntry(long id) {
        RequestEntry entry;
        Long id_obj = new Long(id);
        Hashtable hashtable = this.requests;
        synchronized (hashtable) {
            entry = (RequestEntry)this.requests.get(id_obj);
        }
        return entry != null ? entry.coll : null;
    }

    private void handleRequest(Message req) {
        byte[] rsp_buf;
        Header hdr = (Header)req.removeHeader();
        Object retval = this.request_handler.handle(req);
        if (!hdr.rsp_expected) {
            return;
        }
        if (this.transport == null) {
            Trace.error("RequestCorrelator.handleRequest()", "failure sending response. No protocol available ! ");
            return;
        }
        try {
            rsp_buf = retval != null ? Util.objectToByteBuffer(retval) : null;
        }
        catch (Exception e) {
            Trace.error("RequestCorrelator.handleRequest()", "failed sending response: return value is not serializable. Sending null value");
            return;
        }
        Message rsp = req.makeReply();
        if (rsp_buf != null) {
            rsp.setBuffer(rsp_buf);
        }
        Header rsp_hdr = new Header(1, hdr.id, false, this.name);
        rsp.addHeader(rsp_hdr);
        try {
            this.transport.passDown(new Event(5, rsp));
        }
        catch (Exception e) {
            Trace.error("RequestCorrelator.handleRequest", this.throwableToString(e));
        }
    }

    private String throwableToString(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    protected boolean upSuspect(Address mbr) {
        Hashtable hashtable = this.requests;
        synchronized (hashtable) {
            Iterator it = this.requests.values().iterator();
            while (it.hasNext()) {
                RequestEntry entry = (RequestEntry)it.next();
                if (entry.coll == null) continue;
                entry.coll.suspect(mbr);
            }
        }
        return true;
    }

    protected boolean upViewChange(View new_view) {
        Hashtable hashtable = this.requests;
        synchronized (hashtable) {
            Iterator it = this.requests.values().iterator();
            while (it.hasNext()) {
                RequestEntry entry = (RequestEntry)it.next();
                if (entry.coll == null) continue;
                entry.coll.viewChange(new_view);
            }
        }
        return true;
    }

    protected boolean upMsg(Event e) {
        Message msg = (Message)e.getArg();
        org.javagroups.Header tmpHdr = msg.peekHeader();
        if (tmpHdr == null || !(tmpHdr instanceof Header)) {
            return true;
        }
        Header hdr = (Header)msg.peekHeader();
        if (hdr.name == null || !hdr.name.equals(this.name)) {
            Trace.debug("RequestCorrelator.upMsg()", "name of request correlator header (" + hdr.name + ") is different from ours (" + this.name + "). Msg not accepted, passed up");
            return true;
        }
        switch (hdr.type) {
            case 0: {
                if (this.request_handler == null) {
                    Trace.warn("RequestCorrelator.upMsg()", "there is no request handler installed to deliver request !");
                    return false;
                }
                Request req = new Request(msg);
                if (this.deadlock_detection) {
                    Stack stack = hdr.call_stack;
                    if (hdr.rsp_expected && stack != null && this.local_addr != null && stack.contains(this.local_addr)) {
                        this.scheduler.addPrio(req);
                        break;
                    }
                }
                this.scheduler.add(req);
                break;
            }
            case 1: {
                msg.removeHeader();
                RspCollector coll = this.findEntry(hdr.id);
                if (coll == null) break;
                coll.receiveResponse(msg);
                break;
            }
            default: {
                msg.removeHeader();
                Trace.error("RequestCorrelator.upMsg()", "header's type is neither REQ nor RSP !");
            }
        }
        return false;
    }

    public RequestCorrelator(String name, Protocol transport, RequestHandler handler) {
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Protocol transport, RequestHandler handler, boolean deadlock_detection) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    public void finalize() {
        this.stop();
    }

    public void setDeadlockDetection(boolean flag) {
        this.deadlock_detection = flag;
    }

    public void setRequestHandler(RequestHandler handler) {
        this.request_handler = handler;
        this.start();
    }

    public void sendRequest(long id, Message msg, RspCollector coll) {
        if (this.transport == null) {
            Trace.warn("RequestCorrelator.sendRequest()", "transport is not available !");
            return;
        }
        Header hdr = new Header(0, id, coll != null, this.name);
        if (coll != null) {
            if (this.deadlock_detection) {
                if (this.local_addr == null) {
                    Trace.error("RequestCorrelator.sendRequest()", "local address is null !");
                    return;
                }
                Stack new_call_stack = this.call_stack != null ? (Stack)this.call_stack.clone() : new Stack();
                new_call_stack.push(this.local_addr);
                hdr.call_stack = new_call_stack;
            }
            this.addEntry(hdr.id, new RequestEntry(coll));
        }
        msg.addHeader(hdr);
        try {
            this.transport.passDown(new Event(5, msg));
        }
        catch (Exception e) {
            Trace.warn("RequestCorrelator.sendRequest()", e.toString());
        }
    }

    public void done(long id) {
        this.removeEntry(id);
    }

    public void receive(Event evt) {
        switch (evt.getType()) {
            case 15: {
                if (this.upSuspect((Address)evt.getArg())) break;
                return;
            }
            case 10: {
                if (this.upViewChange((View)evt.getArg())) break;
                return;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 5: {
                if (this.upMsg(evt)) break;
                return;
            }
        }
        this.transport.passUp(evt);
    }

    public void start() {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler();
            if (this.deadlock_detection && this.call_stack_setter != null) {
                this.scheduler.setListener(this.call_stack_setter);
            }
            this.scheduler.start();
        }
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
    }

    private class Request
    implements Runnable {
        public Message req;

        public Request(Message req) {
            this.req = req;
        }

        public void run() {
            RequestCorrelator.this.handleRequest(this.req);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.req != null) {
                sb.append("req=" + this.req + ", headers=" + this.req.printObjectHeaders());
            }
            return sb.toString();
        }
    }

    private class CallStackSetter
    implements SchedulerListener {
        private CallStackSetter() {
        }

        public void started(Runnable r) {
            this.setCallStack(r);
        }

        public void stopped(Runnable r) {
            this.setCallStack(null);
        }

        public void suspended(Runnable r) {
            this.setCallStack(null);
        }

        public void resumed(Runnable r) {
            this.setCallStack(r);
        }

        void setCallStack(Runnable r) {
            if (r == null) {
                RequestCorrelator.this.call_stack = null;
                return;
            }
            Message req = ((Request)r).req;
            if (req == null) {
                return;
            }
            org.javagroups.Header obj = req.peekHeader();
            if (obj == null || !(obj instanceof Header)) {
                return;
            }
            Header hdr = (Header)obj;
            if (!hdr.rsp_expected) {
                return;
            }
            Stack new_stack = hdr.call_stack;
            if (new_stack != null) {
                RequestCorrelator.this.call_stack = (Stack)new_stack.clone();
            }
        }
    }

    public static class Header
    extends org.javagroups.Header {
        public static final int REQ = 0;
        public static final int RSP = 1;
        public int type = 0;
        public long id = 0L;
        public boolean rsp_expected = true;
        public String name = null;
        public Stack call_stack = null;

        public Header() {
        }

        public Header(int type, long id, boolean rsp_expected, String name) {
            this.type = type;
            this.id = id;
            this.rsp_expected = rsp_expected;
            this.name = name;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("[Header: name=" + this.name + ", type=");
            ret.append(this.type == 0 ? "REQ" : (this.type == 1 ? "RSP" : "<unknown>"));
            ret.append(", id=" + this.id);
            ret.append(", rsp_expected=" + this.rsp_expected + "]");
            return ret.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.id);
            out.writeBoolean(this.rsp_expected);
            out.writeObject(this.name);
            out.writeObject(this.call_stack);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.id = in.readLong();
            this.rsp_expected = in.readBoolean();
            this.name = (String)in.readObject();
            this.call_stack = (Stack)in.readObject();
        }
    }

    private static class RequestEntry {
        public RspCollector coll = null;

        public RequestEntry(RspCollector coll) {
            this.coll = coll;
        }
    }
}

