/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.debug;

import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.javagroups.JChannel;
import org.javagroups.debug.ProtocolView;
import org.javagroups.stack.Protocol;
import org.javagroups.stack.ProtocolStack;

public class Debugger
extends JFrame {
    JChannel channel = null;
    Vector prots = new Vector();
    JButton b1;
    JButton b2;
    JPanel button_panel;
    JTable table;
    DefaultTableModel table_model;
    JScrollPane scroll_pane;
    public static Font helvetica_12 = null;
    public boolean cummulative = false;

    public Debugger() {
        super("Debugger Window");
    }

    public Debugger(JChannel channel) {
        super("Debugger Window");
        this.channel = channel;
    }

    public Debugger(JChannel channel, boolean cummulative) {
        super("Debugger Window");
        this.channel = channel;
        this.cummulative = cummulative;
    }

    public void setChannel(JChannel channel) {
        this.channel = channel;
    }

    public void start() {
        ProtocolView view = null;
        if (this.channel == null) {
            return;
        }
        ProtocolStack stack = this.channel.getProtocolStack();
        this.prots = stack.getProtocols();
        ((Component)this).setBounds(new Rectangle(30, 30, 300, 300));
        this.table_model = new DefaultTableModel();
        this.table = new JTable(this.table_model);
        this.table.setFont(helvetica_12);
        this.scroll_pane = new JScrollPane(this.table);
        this.table_model.setColumnIdentifiers(new String[]{"Index", "Name", "up", "down"});
        this.getContentPane().add(this.scroll_pane);
        this.show();
        int i = 0;
        while (i < this.prots.size()) {
            Protocol prot = (Protocol)this.prots.elementAt(i);
            view = new ProtocolView(prot, this.table_model, i, this.cummulative);
            prot.setObserver(view);
            this.table_model.insertRow(i, new Object[]{"" + (i + 1), prot.getName(), prot.getUpQueue().size() + "", prot.getDownQueue().size() + "", "0", "0"});
            ++i;
        }
    }

    JComponent createProtocolView(String protname) {
        String classname = "org.javagroups.debug." + protname + "View";
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return (JComponent)loader.loadClass(classname).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        Debugger d = new Debugger();
        d.start();
    }

    static {
        helvetica_12 = new Font("Helvetica", 0, 12);
    }
}

