/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.TransportedVectorTime;
import org.javagroups.protocols.VectorTime;
import org.javagroups.stack.Protocol;

public class CAUSAL
extends Protocol {
    private VectorTime localVector;
    private LinkedList delayQueue;
    private Address localAddress;

    private void addToDelayQueue(TransportedVectorTime tvt) {
        ListIterator i = this.delayQueue.listIterator(0);
        TransportedVectorTime current = null;
        while (i.hasNext()) {
            current = (TransportedVectorTime)i.next();
            if (!tvt.lessThanOrEqual(current)) continue;
            this.delayQueue.add(i.previousIndex(), tvt);
            return;
        }
        this.delayQueue.add(tvt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 3: {
                this.passDown(evt);
                break;
            }
            case 5: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                Message causalMsg = new Message(msg.getDest(), msg.getSrc(), msg);
                CAUSAL cAUSAL = this;
                synchronized (cAUSAL) {
                    this.localVector.increment();
                    causalMsg.addHeader(new CausalHeader(this.localVector.getTransportedVectorTime()));
                }
                this.passDown(new Event(5, causalMsg));
                return;
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 12: {
                this.localAddress = (Address)evt.getArg();
                this.localVector = new VectorTime(this.localAddress);
                this.delayQueue = new LinkedList();
                break;
            }
            case 10: {
                Vector newViewMembers = ((View)evt.getArg()).getMembers();
                this.localVector.merge((Vector)newViewMembers.clone());
                this.localVector.reset();
                break;
            }
            case 5: {
                Header obj = null;
                Message msg = (Message)evt.getArg();
                obj = msg.peekHeader();
                if (!(obj instanceof CausalHeader)) {
                    Trace.error("CAUSAL", "NO CAUSAL.Header found");
                }
                CausalHeader header = (CausalHeader)obj;
                TransportedVectorTime messageVector = header.getVectorTime();
                CAUSAL cAUSAL = this;
                synchronized (cAUSAL) {
                    if (this.localVector.isCausallyNext(messageVector)) {
                        this.passUp(new Event(5, msg.getObject()));
                        this.localVector.max(messageVector);
                    } else {
                        messageVector.setAssociatedMessage(msg);
                        this.addToDelayQueue(messageVector);
                    }
                    TransportedVectorTime queuedVector = null;
                    while (this.delayQueue.size() > 0 && this.localVector.isCausallyNext(queuedVector = (TransportedVectorTime)this.delayQueue.getFirst())) {
                        this.delayQueue.remove(queuedVector);
                        this.passUp(new Event(5, queuedVector.getAssociatedMessage().getObject()));
                        this.localVector.max(queuedVector);
                    }
                    return;
                }
            }
        }
        this.passUp(evt);
    }

    public String getName() {
        return "CAUSAL";
    }

    private static class CausalHeader
    extends Header {
        private TransportedVectorTime t;

        public CausalHeader() {
        }

        public CausalHeader(TransportedVectorTime timeVector) {
            this.t = timeVector;
        }

        public TransportedVectorTime getVectorTime() {
            return this.t;
        }

        public long size() {
            return 231 + this.t.size() * 4;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.t);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.t = (TransportedVectorTime)in.readObject();
        }

        public String toString() {
            return "[CAUSALHEADER:" + this.t + "]";
        }
    }
}

