/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.GMS;
import org.javagroups.protocols.GmsImpl;
import org.javagroups.protocols.PingRsp;
import org.javagroups.util.Util;

public class ClientGmsImpl
extends GmsImpl {
    Vector initial_mbrs = new Vector();
    Object view_installation_mutex = new Object();
    boolean joined = false;

    public ClientGmsImpl(GMS g) {
        this.gms = g;
    }

    public void init() {
        this.initial_mbrs.removeAllElements();
        this.joined = false;
    }

    public void join(Address mbr) {
        Address coord = null;
        while (true) {
            if (this.joined) {
                if (Trace.trace) {
                    Trace.info("ClientGmsImpl.join()", "joined successfully");
                }
                return;
            }
            this.findInitialMembers();
            if (this.initial_mbrs.size() < 1) {
                this.gms.view_id = new ViewId(mbr);
                this.gms.members.add(mbr);
                Event view_evt = new Event(10, this.gms.makeView(this.gms.members.getMembers(), this.gms.view_id));
                this.gms.passDown(view_evt);
                this.gms.passUp(view_evt);
                this.gms.becomeCoordinator();
                this.gms.passUp(new Event(22));
                this.gms.passDown(new Event(22));
                if (!Trace.trace) break;
                Trace.info("ClientGmsImpl.join()", "created group (first member)");
                break;
            }
            coord = this.determineCoord(this.initial_mbrs);
            if (coord == null) {
                Trace.warn("ClientGmsImpl.join()", "could not determine coordinator from responses " + this.initial_mbrs);
                continue;
            }
            Object object = this.view_installation_mutex;
            synchronized (object) {
                try {
                    if (Trace.trace) {
                        Trace.info("ClientGmsImpl.join()", "sending handleJoin() to " + coord);
                    }
                    this.gms.callRemoteMethod(coord, "handleJoin", mbr, 6, 0L);
                    this.view_installation_mutex.wait(this.gms.join_timeout);
                }
                catch (Exception e) {
                    Trace.error("ClientGmsImpl.join()", "exception is " + e);
                    continue;
                }
            }
            if (this.joined) {
                if (Trace.trace) {
                    Trace.info("ClientGmsImpl.join()", "joined successfully");
                }
                return;
            }
            if (Trace.trace) {
                Trace.info("ClientGmsImpl.join()", "failed, retrying");
            }
            Util.sleep(this.gms.join_retry_timeout);
        }
    }

    public void leave(Address mbr) {
        this.wrongMethod("leave");
    }

    public void suspect(Address mbr) {
    }

    public void merge(Vector other_coords) {
        this.wrongMethod("merge");
    }

    public boolean handleJoin(Address mbr) {
        this.wrongMethod("handleJoin");
        return false;
    }

    public void handleLeave(Address mbr, boolean suspected) {
        this.wrongMethod("handleLeave");
    }

    public void handleViewChange(ViewId new_view, Vector mems) {
        if (this.gms.local_addr != null && mems != null && mems.contains(this.gms.local_addr)) {
            Object object = this.view_installation_mutex;
            synchronized (object) {
                this.joined = true;
                this.view_installation_mutex.notify();
                this.gms.installView(new_view, mems);
                this.gms.becomeParticipant();
                this.gms.passUp(new Event(22));
                this.gms.passDown(new Event(22));
            }
        } else if (Trace.trace) {
            Trace.warn("ClientGmsImpl.handleViewChange()", "am not member of " + mems + ", will not install view");
        }
    }

    public View handleMerge(ViewId other_view, Vector other_members) {
        this.wrongMethod("handleMerge");
        return null;
    }

    public void handleSuspect(Address mbr) {
        this.wrongMethod("handleSuspect");
    }

    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 19: {
                Vector tmp = (Vector)evt.getArg();
                Vector vector = this.initial_mbrs;
                synchronized (vector) {
                    if (tmp != null && tmp.size() > 0) {
                        int i = 0;
                        while (i < tmp.size()) {
                            this.initial_mbrs.addElement(tmp.elementAt(i));
                            ++i;
                        }
                    }
                    this.initial_mbrs.notify();
                }
                return false;
            }
        }
        return true;
    }

    void findInitialMembers() {
        Vector vector = this.initial_mbrs;
        synchronized (vector) {
            this.initial_mbrs.removeAllElements();
            this.gms.passDown(new Event(18));
            try {
                this.initial_mbrs.wait();
            }
            catch (Exception e) {
                // empty catch block
            }
            int i = 0;
            while (i < this.initial_mbrs.size()) {
                PingRsp ping_rsp = (PingRsp)this.initial_mbrs.elementAt(i);
                if (ping_rsp.own_addr != null && this.gms.local_addr != null && ping_rsp.own_addr.equals(this.gms.local_addr)) {
                    this.initial_mbrs.removeElementAt(i);
                    break;
                }
                ++i;
            }
        }
    }

    Address determineCoord(Vector mbrs) {
        int count;
        Address winner = null;
        if (mbrs == null || mbrs.size() < 1) {
            return null;
        }
        Hashtable<Address, Integer> votes = new Hashtable<Address, Integer>();
        int i = 0;
        while (i < mbrs.size()) {
            PingRsp mbr = (PingRsp)mbrs.elementAt(i);
            if (mbr.coord_addr != null) {
                if (!votes.containsKey(mbr.coord_addr)) {
                    votes.put(mbr.coord_addr, new Integer(1));
                } else {
                    count = (Integer)votes.get(mbr.coord_addr);
                    votes.put(mbr.coord_addr, new Integer(count + 1));
                }
            }
            ++i;
        }
        if (Trace.trace) {
            if (votes.size() > 1) {
                Trace.warn("ClientGmsImpl.determineCoord()", "there was more than 1 candidate for coordinator: " + votes);
            } else {
                Trace.info("ClientGmsImpl.determineCoord()", "election results: " + votes);
            }
        }
        int most_votes = 0;
        Enumeration e = votes.keys();
        while (e.hasMoreElements()) {
            Address tmp = (Address)e.nextElement();
            count = (Integer)votes.get(tmp);
            if (count <= most_votes) continue;
            winner = tmp;
            ++most_votes;
        }
        votes.clear();
        return winner;
    }
}

