/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.AbstractList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.GMS;
import org.javagroups.protocols.GmsImpl;

public class CoordGmsImpl
extends GmsImpl {
    boolean leaving = false;
    boolean received_last_view = false;
    Object leave_mutex = new Object();

    public CoordGmsImpl(GMS g) {
        this.gms = g;
    }

    public void init() {
        this.leaving = false;
        this.received_last_view = false;
    }

    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    public void leave(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        this.handleLeave(mbr, false);
        Object object = this.leave_mutex;
        synchronized (object) {
            if (this.leaving && this.received_last_view) {
                return;
            }
            try {
                this.leave_mutex.wait(this.gms.leave_timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void suspect(Address mbr) {
        this.handleSuspect(mbr);
    }

    public void merge(Vector other_coords) {
        Address other_coord;
        View new_view = null;
        Address address = other_coord = other_coords != null ? (Address)other_coords.elementAt(0) : null;
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.merge()", "other_coord = " + other_coord);
        }
        try {
            new_view = (View)this.gms.callRemoteMethod(other_coord, "handleMerge", this.gms.view_id, this.gms.members.getMembers(), 2, 0L);
        }
        catch (Exception ex) {
            if (Trace.trace) {
                Trace.error("CoordGmsImpl.merge()", "timed out or was suspected");
            }
            return;
        }
        if (new_view == null) {
            if (Trace.trace) {
                Trace.warn("CoordGmsImpl.merge()", "received a Merge Denied");
            }
            this.gms.passDown(new Event(51));
            return;
        }
        this.gms.flush(this.gms.members.getMembers(), null);
        this.gms.callRemoteMethods(this.gms.members.getMembers(), "handleViewChange", new_view.getVid(), new_view.getMembers(), 2, 0L);
        this.gms.becomeParticipant();
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.merge()", "merge done");
        }
    }

    public synchronized boolean handleJoin(Address mbr) {
        Vector<Address> new_mbrs = new Vector<Address>();
        if (this.gms.local_addr.equals(mbr)) {
            Trace.error("CoordGmsImpl.handleJoin()", "cannot join myself !");
            return false;
        }
        if (this.gms.members.contains(mbr)) {
            if (Trace.trace) {
                Trace.warn("CoordGmsImpl.handleJoin()", "member " + mbr + " already present !");
            }
            return true;
        }
        new_mbrs.addElement(mbr);
        this.gms.castViewChange(new_mbrs, null, null);
        return true;
    }

    public synchronized void handleLeave(Address mbr, boolean suspected) {
        Vector<Address> v = new Vector<Address>();
        if (!this.gms.members.contains(mbr)) {
            if (Trace.trace) {
                Trace.error("CoordGmsImpl.handleLeave()", "mbr " + mbr + " is not a member !");
            }
            return;
        }
        v.addElement(mbr);
        if (suspected) {
            this.gms.castViewChange(null, null, v);
        } else {
            this.gms.castViewChange(null, v, null);
        }
    }

    public void handleViewChange(ViewId new_view, Vector mbrs) {
        if (this.leaving) {
            if (mbrs.contains(this.gms.local_addr)) {
                Trace.warn("CoordGmsImpl.handleViewChange()", "received view in which I'm still a member, cannot quit yet");
                this.gms.installView(new_view, mbrs);
            } else {
                Object object = this.leave_mutex;
                synchronized (object) {
                    this.received_last_view = true;
                    this.leave_mutex.notify();
                }
            }
            return;
        }
        this.gms.installView(new_view, mbrs);
    }

    public synchronized View handleMerge(ViewId other_vid, Vector other_mbrs) {
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.handleMerge()", "other_vid=" + other_vid + " , other_mbrs=" + other_mbrs);
        }
        Iterator i = ((AbstractList)other_mbrs).iterator();
        while (i.hasNext()) {
            if (!this.gms.members.contains((Address)i.next())) continue;
            this.gms.passDown(new Event(51));
            return null;
        }
        ViewId vid = new ViewId(this.gms.local_addr, Math.max(other_vid.getId() + 1L, this.gms.ltime + 1L));
        HashSet members = new HashSet(this.gms.members.getMembers());
        members.addAll(other_mbrs);
        Vector new_mbrs = new Vector(members);
        Collections.sort(new_mbrs);
        View new_view = new View(vid, new_mbrs);
        this.gms.flush(this.gms.members.getMembers(), null);
        this.gms.callRemoteMethods(this.gms.members.getMembers(), "handleViewChange", vid, new_mbrs, 2, 0L);
        return new_view;
    }

    public void handleSuspect(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            Trace.error("CoordGmsImpl.handleSuspect()", "I am the coord and am suspected: am not quitting !");
            return;
        }
        this.handleLeave(mbr, true);
    }
}

