/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Hashtable;
import java.util.Properties;
import org.javagroups.Event;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

public class DELAY
extends Protocol {
    int in_delay = 0;
    int out_delay = 0;

    public String getName() {
        return "DELAY";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("in_delay");
        if (str != null) {
            this.in_delay = new Integer(str);
            ((Hashtable)props).remove("in_delay");
        }
        if ((str = props.getProperty("out_delay")) != null) {
            this.out_delay = new Integer(str);
            ((Hashtable)props).remove("out_delay");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("DELAY.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        int delay = this.in_delay > 0 ? this.computeDelay(this.in_delay) : 0;
        switch (evt.getType()) {
            case 5: {
                if (Trace.trace) {
                    Trace.info("DELAY.up()", "delaying incoming message for " + delay + " milliseconds");
                }
                Util.sleep(delay);
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        int delay = this.out_delay > 0 ? this.computeDelay(this.out_delay) : 0;
        switch (evt.getType()) {
            case 5: {
                if (Trace.trace) {
                    Trace.info("DELAY.down()", "delaying outgoing message for " + delay + " milliseconds");
                }
                Util.sleep(delay);
            }
        }
        this.passDown(evt);
    }

    int computeDelay(int n) {
        return (int)(Math.random() * 1000000.0 % (double)n);
    }
}

