/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.TimeScheduler;

public class FD
extends Protocol {
    Address ping_dest = null;
    Address local_addr = null;
    Thread pinger = null;
    long timeout = 3000L;
    long last_ack = System.currentTimeMillis();
    int num_tries = 0;
    int max_tries = 2;
    Vector members = new Vector();
    Hashtable invalid_pingers = new Hashtable();
    boolean shun = true;
    TimeScheduler timer = null;
    Monitor monitor = null;

    public String getName() {
        return "FD";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            ((Hashtable)props).remove("timeout");
        }
        if ((str = props.getProperty("max_tries")) != null) {
            this.max_tries = new Integer(str);
            ((Hashtable)props).remove("max_tries");
        }
        if ((str = props.getProperty("shun")) != null) {
            this.shun = new Boolean(str);
            ((Hashtable)props).remove("shun");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("FD.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    Object getPingDest(Vector members) {
        Object retval = null;
        if (members == null || members.size() < 2 || this.local_addr == null) {
            return null;
        }
        int i = 0;
        while (i < members.size()) {
            Object tmp = members.elementAt(i);
            if (this.local_addr.equals(tmp)) {
                if (i + 1 >= members.size()) {
                    retval = members.elementAt(0);
                    break;
                }
                retval = members.elementAt(i + 1);
                break;
            }
            ++i;
        }
        return retval;
    }

    public void up(Event evt) {
        FdHeader hdr = null;
        boolean num_pings = false;
        switch (evt.getType()) {
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                if (this.stack != null && this.stack.timer != null) {
                    this.timer = this.stack.timer;
                    break;
                }
                Trace.error("FD.up()", "[START]: timer cannot be retrieved from protocol stack");
                break;
            }
            case 5: {
                Message msg = (Message)evt.getArg();
                Header tmphdr = msg.peekHeader();
                if (tmphdr == null || !(tmphdr instanceof FdHeader)) {
                    Address sender;
                    if (this.ping_dest == null || (sender = msg.getSrc()) == null || !this.ping_dest.equals(sender)) break;
                    this.last_ack = System.currentTimeMillis();
                    if (Trace.trace) {
                        Trace.info("FD.up()", "received msg from " + sender + " (counts as ack)");
                    }
                    this.num_tries = 0;
                    break;
                }
                hdr = (FdHeader)msg.removeHeader();
                switch (hdr.type) {
                    case 0: {
                        Address hb_sender = msg.getSrc();
                        Message hb_ack = new Message(msg.getSrc(), null, null);
                        FdHeader tmp_hdr = new FdHeader(1);
                        tmp_hdr.from = this.local_addr;
                        hb_ack.addHeader(tmp_hdr);
                        this.passDown(new Event(5, hb_ack));
                        if (!this.shun) break;
                        this.shunInvalidHeartbeatSender(hb_sender);
                        break;
                    }
                    case 1: {
                        if (this.ping_dest != null && this.ping_dest.equals(hdr.from)) {
                            this.last_ack = System.currentTimeMillis();
                            this.num_tries = 0;
                            if (!Trace.trace) break;
                            Trace.info("FD.up()", "received ack from " + hdr.from);
                            break;
                        }
                        this.stop();
                        this.ping_dest = (Address)this.getPingDest(this.members);
                        if (this.ping_dest == null) break;
                        this.start();
                        break;
                    }
                    case 2: {
                        if (hdr.suspected_mbr == null) break;
                        if (Trace.trace) {
                            Trace.info("FD.up()", "[SUSPECT] suspect hdr is " + hdr);
                        }
                        this.members.remove(hdr.suspected_mbr);
                        this.ping_dest = (Address)this.getPingDest(this.members);
                        this.passUp(new Event(15, hdr.suspected_mbr));
                        this.passDown(new Event(15, hdr.suspected_mbr));
                        break;
                    }
                    case 3: {
                        if (!this.shun) break;
                        if (Trace.trace) {
                            Trace.info("FD.up()", "[NOT_MEMBER] I'm being shunned; exiting");
                        }
                        this.passUp(new Event(52));
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 3: {
                this.stop();
                this.passDown(evt);
                break;
            }
            case 10: {
                FD fD = this;
                synchronized (fD) {
                    this.stop();
                    View v = (View)evt.getArg();
                    this.members.removeAllElements();
                    this.members.addAll(v.getMembers());
                    this.passDown(evt);
                    this.ping_dest = (Address)this.getPingDest(this.members);
                    if (this.ping_dest != null) {
                        this.start();
                    }
                    break;
                }
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    void start() {
        if (this.monitor != null && !this.monitor.started) {
            this.monitor = null;
        }
        if (this.monitor == null) {
            this.monitor = new Monitor();
            this.timer.add(this.monitor, true);
            this.last_ack = System.currentTimeMillis();
            this.num_tries = 0;
        }
    }

    void stop() {
        if (this.monitor != null) {
            this.monitor.stop();
            this.monitor = null;
        }
    }

    void shunInvalidHeartbeatSender(Address hb_sender) {
        int num_pings = 0;
        if (hb_sender != null && this.members != null && !this.members.contains(hb_sender)) {
            if (this.invalid_pingers.containsKey(hb_sender)) {
                num_pings = (Integer)this.invalid_pingers.get(hb_sender);
                if (num_pings >= this.max_tries) {
                    Trace.info("FD.shunInvalidHeartbeatSender()", "sender " + hb_sender + " is not member in " + this.members + " ! Telling it to leave group");
                    Message shun_msg = new Message(hb_sender, null, null);
                    shun_msg.addHeader(new FdHeader(3));
                    this.passDown(new Event(5, shun_msg));
                    this.invalid_pingers.remove(hb_sender);
                } else {
                    this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
                }
            } else {
                this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
            }
        }
    }

    private class Monitor
    implements TimeScheduler.Task {
        boolean started = true;

        private Monitor() {
        }

        public void stop() {
            this.started = false;
        }

        public boolean cancelled() {
            return !this.started;
        }

        public long nextInterval() {
            return FD.this.timeout;
        }

        public void run() {
            long not_heard_from = 0L;
            if (FD.this.ping_dest == null) {
                Trace.error("FD.Monitor.run()", "ping_dest is null");
                return;
            }
            Message hb_req = new Message(FD.this.ping_dest, null, null);
            hb_req.addHeader(new FdHeader(0));
            if (Trace.trace) {
                Trace.debug("FD.Monitor.run()", "sending are-you-alive msg to " + FD.this.ping_dest);
            }
            FD.this.passDown(new Event(5, hb_req));
            not_heard_from = System.currentTimeMillis() - FD.this.last_ack;
            Trace.debug("FD.Monitor.run()", "not heard from " + FD.this.ping_dest + " for " + not_heard_from + " ms");
            if (not_heard_from >= FD.this.timeout) {
                if (FD.this.num_tries >= FD.this.max_tries) {
                    if (Trace.trace) {
                        Trace.info("FD.Monitor.run()", "[" + FD.this.local_addr + "]: received no heartbeat ack from " + FD.this.ping_dest + ", suspecting it");
                    }
                    FdHeader hdr = new FdHeader(2);
                    hdr.suspected_mbr = FD.this.ping_dest;
                    hdr.from = FD.this.local_addr;
                    Message suspect_msg = new Message();
                    suspect_msg.addHeader(hdr);
                    FD.this.passDown(new Event(5, suspect_msg));
                } else {
                    if (Trace.trace) {
                        Trace.debug("FD.Monitor.run()", "received heartbeat ack from " + FD.this.ping_dest);
                    }
                    ++FD.this.num_tries;
                }
            }
        }
    }

    private static class FdHeader
    extends Header {
        static final int HEARTBEAT = 0;
        static final int HEARTBEAT_ACK = 1;
        static final int SUSPECT = 2;
        static final int NOT_MEMBER = 3;
        int type = 0;
        Address suspected_mbr = null;
        Address from = null;

        public FdHeader() {
        }

        FdHeader(int type) {
            this.type = type;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "[FD: heartbeat]";
                }
                case 1: {
                    return "[FD: heartbeat ack]";
                }
                case 2: {
                    return "[FD: SUSPECT (suspected_mbr=" + this.suspected_mbr + ", from=" + this.from + ")]";
                }
                case 3: {
                    return "[FD: NOT_MEMBER]";
                }
            }
            return "[FD: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeObject(this.suspected_mbr);
            out.writeObject(this.from);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.suspected_mbr = (Address)in.readObject();
            this.from = (Address)in.readObject();
        }
    }
}

