/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Promise;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

public class FD_SOCK
extends Protocol
implements Runnable {
    long get_cache_timeout = 3000L;
    long get_cache_retry_timeout = 500L;
    long suspect_msg_interval = 5000L;
    int num_tries = 3;
    Vector members = new Vector();
    boolean srv_sock_sent = false;
    Vector pingable_mbrs = new Vector();
    Promise get_cache_promise = new Promise();
    boolean got_cache_from_coord = false;
    Address local_addr = null;
    ServerSocket srv_sock = null;
    ServerSocketHandler srv_sock_handler = null;
    IpAddress srv_sock_addr = null;
    Address ping_dest = null;
    Socket ping_sock = null;
    InputStream ping_input = null;
    Thread pinger_thread = null;
    Hashtable cache = new Hashtable();
    int start_port = 10000;
    Promise ping_addr_promise = new Promise();
    Object sock_mutex = new Object();
    TimeScheduler timer = null;
    BroadcastTask bcast_task = new BroadcastTask();
    boolean regular_sock_close = false;

    public String getName() {
        return "FD_SOCK";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("get_cache_timeout");
        if (str != null) {
            this.get_cache_timeout = new Long(str);
            ((Hashtable)props).remove("get_cache_timeout");
        }
        if ((str = props.getProperty("suspect_msg_interval")) != null) {
            this.suspect_msg_interval = new Long(str);
            ((Hashtable)props).remove("suspect_msg_interval");
        }
        if ((str = props.getProperty("num_tries")) != null) {
            this.num_tries = new Integer(str);
            ((Hashtable)props).remove("num_tries");
        }
        if ((str = props.getProperty("start_port")) != null) {
            this.start_port = new Integer(str);
            ((Hashtable)props).remove("start_port");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("FD_SOCK.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        this.srv_sock = Util.createServerSocket(this.start_port);
        this.srv_sock_addr = new IpAddress(this.srv_sock.getLocalPort());
        this.srv_sock_handler = new ServerSocketHandler();
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("FD_SOCK.init(): timer == null");
        }
    }

    public void up(Event evt) {
        FdHeader hdr = null;
        boolean num_pings = false;
        switch (evt.getType()) {
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 5: {
                Message msg = (Message)evt.getArg();
                Header tmphdr = msg.peekHeader();
                if (tmphdr == null || !(tmphdr instanceof FdHeader)) break;
                hdr = (FdHeader)msg.removeHeader();
                switch (hdr.type) {
                    case 10: {
                        if (hdr.mbrs != null) {
                            if (Trace.trace) {
                                Trace.info("FD_SOCK.up()", "[SUSPECT] hdr=" + hdr);
                            }
                            int i = 0;
                            while (i < hdr.mbrs.size()) {
                                this.passUp(new Event(15, hdr.mbrs.elementAt(i)));
                                this.passDown(new Event(15, hdr.mbrs.elementAt(i)));
                                ++i;
                            }
                            break;
                        }
                        Trace.warn("FD_SOCK.up()", "[SUSPECT]: hdr.mbrs == null");
                        break;
                    }
                    case 11: {
                        if (this.local_addr != null && this.local_addr.equals(msg.getSrc())) {
                            return;
                        }
                        if (hdr.mbr == null) {
                            Trace.error("FD_SOCK.up(WHO_HAS_SOCK)", "hdr.mbr is null");
                            return;
                        }
                        if (Trace.trace) {
                            Trace.info("FD_SOCK.up()", "who-has-sock " + hdr.mbr);
                        }
                        if (this.local_addr != null && this.local_addr.equals(hdr.mbr) && this.srv_sock_addr != null) {
                            this.sendIHaveSockMessage(msg.getSrc(), this.local_addr, this.srv_sock_addr);
                            return;
                        }
                        if (!this.cache.containsKey(hdr.mbr)) break;
                        this.sendIHaveSockMessage(msg.getSrc(), hdr.mbr, (IpAddress)this.cache.get(hdr.mbr));
                        break;
                    }
                    case 12: {
                        if (hdr.mbr == null || hdr.sock_addr == null) {
                            Trace.error("FD_SOCK.up()", "[I_HAVE_SOCK]: hdr.mbr is null or hdr.sock_addr == null");
                            return;
                        }
                        this.cache.put(hdr.mbr, hdr.sock_addr);
                        if (Trace.trace) {
                            Trace.info("FD_SOCK.up()", "i-have-sock: " + hdr.mbr + " --> " + hdr.sock_addr + " (cache is " + this.cache + ")");
                        }
                        if (this.ping_dest == null || !hdr.mbr.equals(this.ping_dest)) break;
                        this.ping_addr_promise.setResult(hdr.sock_addr);
                        break;
                    }
                    case 13: {
                        if (hdr.mbr == null) {
                            if (Trace.trace) {
                                Trace.error("FD_SOCK.up()", "(GET_CACHE): hdr.mbr == null");
                            }
                            return;
                        }
                        hdr = new FdHeader(14);
                        hdr.cache = (Hashtable)this.cache.clone();
                        msg = new Message(hdr.mbr, null, null);
                        msg.addHeader(hdr);
                        this.passDown(new Event(5, msg));
                        break;
                    }
                    case 14: {
                        if (hdr.cache == null) {
                            if (Trace.trace) {
                                Trace.error("FD_SOCK.up()", "(GET_CACHE_RSP): cache is null");
                            }
                            return;
                        }
                        this.get_cache_promise.setResult(hdr.cache);
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        Vector old_mbrs = this.members;
        switch (evt.getType()) {
            case 3: {
                this.bcast_task.removeAll();
                this.stopPingerThread();
                this.stopServerSocket();
                this.passDown(evt);
                break;
            }
            case 57: {
                this.bcast_task.removeSuspectedMember((Address)evt.getArg());
                break;
            }
            case 10: {
                FD_SOCK fD_SOCK = this;
                synchronized (fD_SOCK) {
                    View v = (View)evt.getArg();
                    this.members.removeAllElements();
                    this.members.addAll(v.getMembers());
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    this.pingable_mbrs.removeAllElements();
                    this.pingable_mbrs.addAll(this.members);
                    this.passDown(evt);
                    if (Trace.trace) {
                        Trace.info("FD_SOCK.down()", "VIEW_CHANGE received: " + this.members);
                    }
                    if (!this.got_cache_from_coord) {
                        this.getCacheFromCoordinator();
                        this.got_cache_from_coord = true;
                    }
                    if (!this.srv_sock_sent) {
                        if (this.srv_sock_addr != null) {
                            this.sendIHaveSockMessage(null, this.local_addr, this.srv_sock_addr);
                            this.srv_sock_sent = true;
                        } else {
                            Trace.warn("FD_SOCK.down()", "(VIEW_CHANGE): srv_sock_addr == null");
                        }
                    }
                    if (this.members != null) {
                        Enumeration e = this.cache.keys();
                        while (e.hasMoreElements()) {
                            Address mbr = (Address)e.nextElement();
                            if (this.members.contains(mbr)) continue;
                            this.cache.remove(mbr);
                        }
                    }
                    if (this.members.size() > 1) {
                        if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
                            Address tmp_ping_dest = this.determinePingDest();
                            if (this.ping_dest != null && tmp_ping_dest != null && !this.ping_dest.equals(tmp_ping_dest)) {
                                this.interruptPingerThread();
                            }
                        } else {
                            this.startPingerThread();
                        }
                    } else {
                        this.ping_dest = null;
                        this.stopPingerThread();
                    }
                    break;
                }
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    public void run() {
        int max_fetch_tries = 10;
        Trace.info("FD_SOCK.run()", "pinger_thread started");
        while (this.pinger_thread != null) {
            Address tmp_ping_dest = this.determinePingDest();
            if (Trace.trace) {
                Trace.info("FD_SOCK.run()", "determinePingDest()=" + tmp_ping_dest + ", pingable_mbrs=" + this.pingable_mbrs);
            }
            if (tmp_ping_dest == null) {
                this.ping_dest = null;
                this.pinger_thread = null;
                break;
            }
            this.ping_dest = tmp_ping_dest;
            IpAddress ping_addr = this.fetchPingAddress(this.ping_dest);
            if (ping_addr == null) {
                Trace.error("FD_SOCK.run()", "socket address for " + this.ping_dest + " could not be fetched, retrying");
                if (--max_fetch_tries <= 0) break;
                Util.sleep(2000L);
                continue;
            }
            if (!this.setupPingSocket(ping_addr)) {
                Trace.info("FD_SOCK.run()", "could not create socket to " + this.ping_dest + "; suspecting " + this.ping_dest);
                this.broadcastSuspectMessage(this.ping_dest);
                this.pingable_mbrs.removeElement(this.ping_dest);
                continue;
            }
            if (Trace.trace) {
                Trace.info("FD_SOCK.run()", "ping_dest=" + this.ping_dest + ", ping_sock=" + this.ping_sock + ", cache=" + this.cache);
            }
            try {
                if (this.ping_input.read() != -1) continue;
                this.HandleSocketClose(null);
            }
            catch (IOException ex) {
                this.HandleSocketClose(ex);
            }
            catch (Throwable catch_all_the_rest) {
                if (!Trace.trace) continue;
                Trace.info("FD_SOCK.run()", "exception=" + catch_all_the_rest);
            }
        }
        if (Trace.trace) {
            Trace.info("FD_SOCK.run()", "pinger thread terminated");
        }
        this.pinger_thread = null;
    }

    void HandleSocketClose(Exception ex) {
        this.teardownPingSocket();
        if (!this.regular_sock_close) {
            if (Trace.trace) {
                Trace.info("FD_SOCK.run()", "peer " + this.ping_dest + " closed socket (" + (ex != null ? ex.getClass().getName() : "eof") + ")");
            }
            this.broadcastSuspectMessage(this.ping_dest);
            this.pingable_mbrs.removeElement(this.ping_dest);
        } else {
            if (Trace.trace) {
                Trace.info("FD_SOCK.run()", "socket to " + this.ping_dest + " was reset");
            }
            this.regular_sock_close = false;
        }
    }

    void startPingerThread() {
        if (this.pinger_thread == null) {
            this.pinger_thread = new Thread((Runnable)this, "FD_SOCK Ping thread");
            this.pinger_thread.setDaemon(true);
            this.pinger_thread.start();
        }
    }

    void stopPingerThread() {
        if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
            this.regular_sock_close = true;
            this.teardownPingSocket();
        }
        this.pinger_thread = null;
    }

    void interruptPingerThread() {
        if (this.pinger_thread != null && this.pinger_thread.isAlive()) {
            this.regular_sock_close = true;
            this.teardownPingSocket();
        }
    }

    void stopServerSocket() {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.stop();
        }
    }

    boolean setupPingSocket(IpAddress dest) {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (dest == null) {
                Trace.error("FD_SOCK.setupPingSocket()", "destination address is null");
                boolean bl = false;
                return bl;
            }
            try {
                this.ping_sock = new Socket(dest.getIpAddress(), dest.getPort());
                this.ping_sock.setSoLinger(true, 1);
                this.ping_input = this.ping_sock.getInputStream();
                boolean bl = true;
                return bl;
            }
            catch (Throwable ex) {
                boolean bl = false;
                return bl;
            }
        }
    }

    void teardownPingSocket() {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (this.ping_sock != null) {
                try {
                    this.ping_sock.shutdownInput();
                    this.ping_sock.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.ping_sock = null;
            }
            if (this.ping_input != null) {
                try {
                    this.ping_input.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ping_input = null;
            }
        }
    }

    void getCacheFromCoordinator() {
        int attempts = this.num_tries;
        this.get_cache_promise.reset();
        while (attempts > 0) {
            Address coord = this.determineCoordinator();
            if (coord != null) {
                if (coord.equals(this.local_addr)) {
                    if (Trace.trace) {
                        Trace.info("FD_SOCK.getCacheFromCoordinator()", "first member; cache is empty");
                    }
                    return;
                }
                FdHeader hdr = new FdHeader(13);
                hdr.mbr = this.local_addr;
                Message msg = new Message(coord, null, null);
                msg.addHeader(hdr);
                this.passDown(new Event(5, msg));
                Hashtable result = (Hashtable)this.get_cache_promise.getResult(this.get_cache_timeout);
                if (result != null) {
                    this.cache.putAll(result);
                    if (Trace.trace) {
                        Trace.info("FD_SOCK.getCacheFromCoordinator()", "got cache from " + coord + ": cache is " + this.cache);
                    }
                    return;
                }
                if (Trace.trace) {
                    Trace.error("FD_SOCK.getCacheFromCoordinator()", "received null cache; retrying");
                }
            }
            Util.sleep(this.get_cache_retry_timeout);
            --attempts;
        }
    }

    void broadcastSuspectMessage(Address suspected_mbr) {
        if (suspected_mbr == null) {
            return;
        }
        if (Trace.trace) {
            Trace.info("FD_SOCK.broadcastSuspectMessage()", "suspecting " + suspected_mbr + " (own address is " + this.local_addr + ")");
        }
        FdHeader hdr = new FdHeader(10);
        hdr.mbrs = new Vector();
        hdr.mbrs.addElement(suspected_mbr);
        Message suspect_msg = new Message();
        suspect_msg.addHeader(hdr);
        this.passDown(new Event(5, suspect_msg));
        this.bcast_task.addSuspectedMember(suspected_mbr);
    }

    void broadcastWhoHasSockMessage(Address mbr) {
        if (Trace.trace && this.local_addr != null && mbr != null) {
            Trace.info("FD_SOCK.broadcastWhoHasSockMessage()", "[" + this.local_addr + "]: who-has " + mbr);
        }
        Message msg = new Message();
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        msg.addHeader(hdr);
        this.passDown(new Event(5, msg));
    }

    void sendIHaveSockMessage(Address dst, Address mbr, IpAddress addr) {
        Message msg = new Message(dst, null, null);
        FdHeader hdr = new FdHeader(12);
        hdr.mbr = mbr;
        hdr.sock_addr = addr;
        msg.addHeader(hdr);
        Trace.info("FD_SOCK.sendIHaveSockMessage()", "hdr=" + hdr);
        this.passDown(new Event(5, msg));
    }

    IpAddress fetchPingAddress(Address mbr) {
        IpAddress ret = null;
        if (mbr == null) {
            Trace.error("FD_SOCK.fetchPingAddress()", "mbr == null");
            return null;
        }
        ret = (IpAddress)this.cache.get(mbr);
        if (ret != null) {
            return ret;
        }
        Util.sleep(300L);
        ret = (IpAddress)this.cache.get(mbr);
        if (ret != null) {
            return ret;
        }
        this.ping_addr_promise.reset();
        Message ping_addr_req = new Message(mbr, null, null);
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.addHeader(hdr);
        this.passDown(new Event(5, ping_addr_req));
        ret = (IpAddress)this.ping_addr_promise.getResult(3000L);
        if (ret != null) {
            return ret;
        }
        ping_addr_req = new Message(null, null, null);
        hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.addHeader(hdr);
        this.passDown(new Event(5, ping_addr_req));
        ret = (IpAddress)this.ping_addr_promise.getResult(3000L);
        return ret;
    }

    Address determinePingDest() {
        if (this.pingable_mbrs == null || this.pingable_mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        int i = 0;
        while (i < this.pingable_mbrs.size()) {
            Address tmp = (Address)this.pingable_mbrs.elementAt(i);
            if (this.local_addr.equals(tmp)) {
                if (i + 1 >= this.pingable_mbrs.size()) {
                    return (Address)this.pingable_mbrs.elementAt(0);
                }
                return (Address)this.pingable_mbrs.elementAt(i + 1);
            }
            ++i;
        }
        return null;
    }

    Address determineCoordinator() {
        return this.members.size() > 0 ? (Address)this.members.elementAt(0) : null;
    }

    private class BroadcastTask
    implements TimeScheduler.Task {
        Vector suspected_mbrs = new Vector();
        boolean stopped = false;

        private BroadcastTask() {
        }

        public void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD_SOCK.this.members.contains(mbr)) {
                return;
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (!this.suspected_mbrs.contains(mbr)) {
                    this.suspected_mbrs.addElement(mbr);
                    if (Trace.trace) {
                        Trace.info("FD_SOCK.BroadcastTask.addSuspectedMember()", "mbr=" + mbr + " (size=" + this.suspected_mbrs.size() + ")");
                    }
                }
                if (this.stopped && this.suspected_mbrs.size() > 0) {
                    this.stopped = false;
                    FD_SOCK.this.timer.add(this, true);
                }
            }
        }

        public void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (Trace.trace) {
                Trace.info("FD_SOCK.BroadcastTask.removeSuspectedMember()", "member is " + suspected_mbr);
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeElement(suspected_mbr);
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                }
            }
        }

        public void removeAll() {
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeAllElements();
                this.stopped = true;
            }
        }

        public void adjustSuspectedMembers(Vector new_mbrship) {
            if (new_mbrship == null || new_mbrship.size() == 0) {
                return;
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                Iterator it = ((AbstractList)this.suspected_mbrs).iterator();
                while (it.hasNext()) {
                    Address suspected_mbr = (Address)it.next();
                    if (new_mbrship.contains(suspected_mbr)) continue;
                    it.remove();
                    if (!Trace.trace) continue;
                    Trace.info("FD_SOCK.BroadcastTask.adjustSuspectedMembers()", "removed " + suspected_mbr + " (size=" + this.suspected_mbrs.size() + ")");
                }
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                }
            }
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            return FD_SOCK.this.suspect_msg_interval;
        }

        public void run() {
            FdHeader hdr;
            if (Trace.trace) {
                Trace.info("FD_SOCK.BroadcastTask.run()", "broadcasting SUSPECT message [suspected_mbrs=" + this.suspected_mbrs + "] to group");
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                    if (Trace.trace) {
                        Trace.info("FD_SOCK.BroadcastTask.run()", "task done (no suspected members)");
                    }
                    return;
                }
                hdr = new FdHeader(10);
                hdr.mbrs = (Vector)this.suspected_mbrs.clone();
            }
            Message suspect_msg = new Message();
            suspect_msg.addHeader(hdr);
            FD_SOCK.this.passDown(new Event(5, suspect_msg));
            if (Trace.trace) {
                Trace.info("FD_SOCK.BroadcastTask.run()", "task done");
            }
        }
    }

    private class ServerSocketHandler
    implements Runnable {
        Thread handler = null;
        Socket client_sock = null;
        InputStream in = null;

        ServerSocketHandler() {
            this.start();
        }

        void start() {
            if (this.handler == null) {
                this.handler = new Thread((Runnable)this, "ServerSocketHandler thread");
                this.handler.setDaemon(true);
                this.handler.start();
            }
        }

        void stop() {
            if (this.handler != null && this.handler.isAlive()) {
                try {
                    FD_SOCK.this.srv_sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.handler = null;
        }

        /*
         * Loose catch block
         */
        public void run() {
            while (this.handler != null && FD_SOCK.this.srv_sock != null) {
                try {
                    int c;
                    Trace.info("FD_SOCK.ServerSocketHandler.run()", "waiting for client connections on port " + FD_SOCK.this.srv_sock.getLocalPort());
                    this.client_sock = FD_SOCK.this.srv_sock.accept();
                    Trace.info("FD_SOCK.ServerSocketHandler.run()", "accepted connection from " + this.client_sock.getInetAddress() + ":" + this.client_sock.getPort());
                    this.in = this.client_sock.getInputStream();
                    while ((c = this.in.read()) != -1) {
                    }
                    Object var4_4 = null;
                    if (this.client_sock == null) continue;
                    try {
                        this.client_sock.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.client_sock = null;
                    {
                        continue;
                        catch (IOException io_ex1) {
                            var4_4 = null;
                            if (this.client_sock == null) continue;
                            try {
                                this.client_sock.close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            this.client_sock = null;
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var4_4 = null;
                        if (this.client_sock != null) {
                            try {
                                this.client_sock.close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            this.client_sock = null;
                        }
                        throw throwable;
                    }
                }
                catch (IOException io_ex2) {
                    break;
                }
            }
            this.handler = null;
        }
    }

    private static class FdHeader
    extends Header {
        static final int SUSPECT = 10;
        static final int WHO_HAS_SOCK = 11;
        static final int I_HAVE_SOCK = 12;
        static final int GET_CACHE = 13;
        static final int GET_CACHE_RSP = 14;
        int type = 10;
        Address mbr = null;
        IpAddress sock_addr;
        Hashtable cache = null;
        Vector mbrs = null;

        public FdHeader() {
        }

        public FdHeader(int type) {
            this.type = type;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(FdHeader.type2String(this.type));
            if (this.mbr != null) {
                sb.append(", mbr=" + this.mbr);
            }
            if (this.sock_addr != null) {
                sb.append(", sock_addr=" + this.sock_addr);
            }
            if (this.cache != null) {
                sb.append(", cache=" + this.cache);
            }
            if (this.mbrs != null) {
                sb.append(", mbrs=" + this.mbrs);
            }
            return sb.toString();
        }

        public static String type2String(int type) {
            switch (type) {
                case 10: {
                    return "SUSPECT";
                }
                case 11: {
                    return "WHO_HAS_SOCK";
                }
                case 12: {
                    return "I_HAVE_SOCK";
                }
                case 13: {
                    return "GET_CACHE";
                }
                case 14: {
                    return "GET_CACHE_RSP";
                }
            }
            return "unknown type (" + type + ")";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeObject(this.mbr);
            out.writeObject(this.sock_addr);
            out.writeObject(this.cache);
            out.writeObject(this.mbrs);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.mbr = (Address)in.readObject();
            this.sock_addr = (IpAddress)in.readObject();
            this.cache = (Hashtable)in.readObject();
            this.mbrs = (Vector)in.readObject();
        }
    }
}

