/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.Digest;
import org.javagroups.protocols.FlushRsp;
import org.javagroups.stack.RpcProtocol;
import org.javagroups.util.List;
import org.javagroups.util.Queue;
import org.javagroups.util.Rsp;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;

public class FLUSH
extends RpcProtocol {
    Vector mbrs = new Vector();
    boolean is_server = false;
    Object block_mutex = new Object();
    long block_timeout = 5000L;
    Address local_addr = null;
    boolean blocked = false;
    Object digest_mutex = new Object();
    long digest_timeout = 2000L;
    Object highest_delivered_mutex = new Object();
    long[] highest_delivered_msgs;
    Digest digest = null;
    Object get_msgs_mutex = new Object();
    long get_msgs_timeout = 4000L;
    List get_msgs = null;

    public String getName() {
        return "FLUSH";
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(33));
        return retval;
    }

    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(37));
        retval.addElement(new Integer(43));
        return retval;
    }

    private FlushRsp flush(Vector dests) {
        Enumeration e;
        FlushRsp retval = new FlushRsp();
        List unstable_msgs = new List();
        boolean get_lower_msgs = false;
        this.highest_delivered_msgs = new long[this.members.size()];
        long[] min = new long[this.members.size()];
        long[] max = new long[this.members.size()];
        this.getHighestDeliveredSeqnos();
        int i = 0;
        while (i < this.highest_delivered_msgs.length) {
            min[i] = max[i] = this.highest_delivered_msgs[i];
            ++i;
        }
        if (Trace.trace) {
            Trace.info("FLUSH.flush()", "calling HandleFlush(" + dests + ")");
        }
        this.passDown(new Event(32));
        RspList rsp_list = this.callRemoteMethods(dests, "handleFlush", dests, this.highest_delivered_msgs.clone(), 2, 0L);
        if (Trace.trace) {
            Trace.info("FLUSH.flush()", "flush done");
        }
        int i2 = 0;
        while (i2 < rsp_list.size()) {
            Digest digest;
            Rsp rsp = (Rsp)rsp_list.elementAt(i2);
            if (rsp.wasReceived() && (digest = (Digest)rsp.getValue()) != null) {
                int j = 0;
                while (j < digest.highest_seqnos.length && j < min.length) {
                    min[j] = Math.min(min[j], digest.highest_seqnos[j]);
                    max[j] = Math.max(max[j], digest.highest_seqnos[j]);
                    ++j;
                }
                if (digest.msgs.size() > 0) {
                    e = digest.msgs.elements();
                    while (e.hasMoreElements()) {
                        unstable_msgs.add(e.nextElement());
                    }
                }
            }
            ++i2;
        }
        long[][] lower = new long[min.length][];
        int i3 = 0;
        while (i3 < min.length) {
            if (min[i3] < this.highest_delivered_msgs[i3]) {
                lower[i3] = new long[2];
                lower[i3][0] = min[i3];
                lower[i3][1] = this.highest_delivered_msgs[i3];
                get_lower_msgs = true;
            }
            ++i3;
        }
        if (get_lower_msgs) {
            this.get_msgs = null;
            Object object = this.get_msgs_mutex;
            synchronized (object) {
                this.passDown(new Event(43, lower));
                try {
                    this.get_msgs_mutex.wait(this.get_msgs_timeout);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (this.get_msgs != null) {
                e = this.get_msgs.elements();
                while (e.hasMoreElements()) {
                    unstable_msgs.add(e.nextElement());
                }
            }
        }
        retval.unstable_msgs = unstable_msgs.getContents();
        if (rsp_list.numSuspectedMembers() > 0) {
            retval.result = false;
            retval.failed_mbrs = rsp_list.getSuspectedMembers();
        }
        return retval;
    }

    public synchronized Digest handleFlush(Vector flush_dests, long[] highest_seqnos) {
        this.digest = null;
        if (Trace.trace) {
            Trace.info("FLUSH.handleFlush()", "flush_dests=" + flush_dests + " , highest_seqnos=" + Util.array2String(highest_seqnos));
        }
        if (!this.is_server) {
            return this.digest;
        }
        if (flush_dests == null) {
            if (Trace.trace) {
                Trace.warn("FLUSH.handleFlush()", "flush dest is null, ignoring flush !");
            }
            return this.digest;
        }
        if (flush_dests.size() == 0) {
            if (Trace.trace) {
                Trace.warn("FLUSH.handleFlush()", "flush dest is empty, ignoring flush !");
            }
            return this.digest;
        }
        if (!flush_dests.contains(this.local_addr)) {
            if (Trace.trace) {
                Trace.warn("FLUSH.handleFlush()", "am not in the flush dests, ignoring flush");
            }
            return this.digest;
        }
        if (!this.blocked) {
            this.blocked = true;
            Object object = this.block_mutex;
            synchronized (object) {
                this.passUp(new Event(16));
                try {
                    this.block_mutex.wait(this.block_timeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.getMessageDigest(highest_seqnos);
        if (Trace.trace) {
            Trace.info("FLUSH.handleFlush()", "returning digest : " + this.digest);
        }
        return this.digest;
    }

    void getHighestDeliveredSeqnos() {
        Object object = this.highest_delivered_mutex;
        synchronized (object) {
            this.passDown(new Event(41));
            try {
                this.highest_delivered_mutex.wait(4000L);
            }
            catch (Exception e) {
                Trace.debug("FLUSH.getHighestDeliveredSeqnos()", "exception is " + e);
            }
        }
    }

    void getMessageDigest(long[] highest_seqnos) {
        Object object = this.digest_mutex;
        synchronized (object) {
            this.passDown(new Event(37, highest_seqnos));
            try {
                this.digest_mutex.wait(this.digest_timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 1: {
                if (this._corr != null) {
                    this._corr.setDeadlockDetection(true);
                    break;
                }
                Trace.warn("FLUSH.handleUpEvent()", "[START]: cannot set deadlock detection in corr, as it is null !");
                break;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 38: {
                Object object = this.digest_mutex;
                synchronized (object) {
                    this.digest = (Digest)evt.getArg();
                    this.digest_mutex.notify();
                }
                return false;
            }
            case 42: {
                long[] tmp = (long[])evt.getArg();
                if (tmp != null) {
                    int i = 0;
                    while (i < tmp.length) {
                        this.highest_delivered_msgs[i] = tmp[i];
                        ++i;
                    }
                }
                Object object = this.highest_delivered_mutex;
                synchronized (object) {
                    this.highest_delivered_mutex.notify();
                }
                return false;
            }
            case 44: {
                Object object = this.get_msgs_mutex;
                synchronized (object) {
                    this.get_msgs = (List)evt.getArg();
                    this.get_msgs_mutex.notify();
                    break;
                }
            }
        }
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 33: {
                Vector dests = (Vector)evt.getArg();
                if (dests == null) {
                    dests = new Vector();
                }
                FlushRsp rsp = this.flush(dests);
                this.passUp(new Event(34, rsp));
                return false;
            }
            case 22: {
                this.is_server = true;
                break;
            }
            case 10: {
                this.blocked = false;
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp == null) break;
                this.mbrs.removeAllElements();
                int i = 0;
                while (i < tmp.size()) {
                    this.mbrs.addElement(tmp.elementAt(i));
                    ++i;
                }
                break;
            }
        }
        return true;
    }

    public void receiveDownEvent(Event evt) {
        if (evt.getType() == 17) {
            Queue queue = this.down_queue;
            synchronized (queue) {
                try {
                    while (this.down_queue.size() > 0) {
                        Event event = (Event)this.down_queue.remove(10L);
                        this.down(event);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Object object = this.block_mutex;
            synchronized (object) {
                this.block_mutex.notify();
            }
            return;
        }
        super.receiveDownEvent(evt);
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("block_timeout");
        if (str != null) {
            this.block_timeout = new Long(str);
            ((Hashtable)props).remove("block_timeout");
        }
        if ((str = props.getProperty("digest_timeout")) != null) {
            this.digest_timeout = new Long(str);
            ((Hashtable)props).remove("digest_timeout");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("EXAMPLE.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }
}

