/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

public class FRAG
extends Protocol {
    private int frag_size = 8192;
    private FragmentationList fragment_list = new FragmentationList();
    private int curr_id = 1;
    private Address local_addr = null;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream(this.frag_size);

    public String getName() {
        return "FRAG";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("frag_size");
        if (str != null) {
            this.frag_size = new Integer(str);
            ((Hashtable)props).remove("frag_size");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("FRAG.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void reset() {
    }

    public void down(Event evt) {
        if (evt.getType() == 5) {
            Message msg = (Message)evt.getArg();
            long size = msg.size();
            Address dst = msg.getDest();
            if (size > (long)this.frag_size) {
                if (Trace.trace) {
                    Trace.info("FRAG.down()", "message size is " + size + ", will fragment " + "(frag_size == " + this.frag_size + ")");
                }
                this.fragment(msg);
                return;
            }
        } else if (evt.getType() == 10) {
            View view = (View)evt.getArg();
            Address[] senders = this.fragment_list.getSenders();
            int i = 0;
            while (i < senders.length) {
                if (!view.containsMember(senders[i])) {
                    this.fragment_list.remove(senders[i]);
                    if (Trace.trace) {
                        Trace.info("FRAG.down()", "Frag fixed memory leak, just cleaned up:" + senders[i]);
                    }
                }
                ++i;
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.peekHeader();
                if (obj == null || !(obj instanceof FragHeader)) break;
                this.unfragment(msg);
                return;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        this.passUp(evt);
    }

    private void fragment(Message msg) {
        Message frag_msg = null;
        Address dest = msg.getDest();
        Address src = msg.getSrc();
        long id = this.curr_id++;
        int num_frags = 0;
        try {
            this.bos.reset();
            ObjectOutputStream oos = new ObjectOutputStream(this.bos);
            msg.writeExternal(oos);
            oos.flush();
            byte[] buffer = this.bos.toByteArray();
            byte[][] fragments = Util.fragmentBuffer(buffer, this.frag_size);
            num_frags = fragments.length;
            if (Trace.trace) {
                Trace.info("FRAG.fragment()", "fragmenting packet to " + (dest != null ? dest.toString() : "<all members>") + " (size=" + buffer.length + ") into " + num_frags + " fragment(s) [frag_size=" + this.frag_size + "]");
            }
            int i = 0;
            while (i < num_frags) {
                frag_msg = new Message(dest, src, fragments[i]);
                FragHeader hdr = new FragHeader(id, i, num_frags);
                if (Trace.trace) {
                    Trace.debug("FRAG.fragment()", "fragment's header is " + hdr);
                }
                frag_msg.addHeader(hdr);
                Event evt = new Event(5, frag_msg);
                this.passDown(evt);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.error("FRAG.fragment()", "exception is " + e);
        }
    }

    private void unfragment(Message msg) {
        byte[] m;
        FragmentationTable frag_table = null;
        Address sender = msg.getSrc();
        FragHeader hdr = (FragHeader)msg.removeHeader();
        if (Trace.trace) {
            Trace.debug("FRAG.unfragment()", "[" + this.local_addr + "] received msg, hdr is " + hdr);
        }
        if ((frag_table = this.fragment_list.get(sender)) == null) {
            frag_table = new FragmentationTable(sender);
            try {
                this.fragment_list.add(sender, frag_table);
            }
            catch (IllegalArgumentException x) {
                frag_table = this.fragment_list.get(sender);
            }
        }
        if ((m = frag_table.add(hdr.id, hdr.frag_id, hdr.num_frags, msg.getBuffer())) != null) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(m);
                ObjectInputStream ois = new ObjectInputStream(bis);
                Message assembled_msg = new Message();
                assembled_msg.readExternal(ois);
                if (Trace.trace) {
                    Trace.info("FRAG.unfragment()", "assembled_msg is " + assembled_msg);
                }
                assembled_msg.setSrc(sender);
                this.passUp(new Event(5, assembled_msg));
            }
            catch (Exception e) {
                Trace.error("FRAG.unfragment()", "exception is " + e);
            }
        }
    }

    class FragmentationTable {
        private Address sender;
        private Hashtable h = new Hashtable(11);

        public FragmentationTable(Address sender) {
            this.sender = sender;
        }

        public synchronized byte[] add(long id, int frag_id, int tot_frags, byte[] fragment) {
            byte[] retval = null;
            Entry e = (Entry)this.h.get(new Long(id));
            if (e == null) {
                e = new Entry(id, tot_frags);
                this.h.put(new Long(id), e);
            }
            e.set(frag_id, fragment);
            if (e.isComplete()) {
                retval = e.assembleBuffer();
                this.h.remove(new Long(id));
            }
            return retval;
        }

        public void reset() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("Fragmentation Table Sender:").append(this.sender).append("\n\t");
            Enumeration e = this.h.elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                int count = 0;
                int i = 0;
                while (i < entry.fragments.length) {
                    if (entry.fragments[i] != null) {
                        ++count;
                    }
                    ++i;
                }
                buf.append("Message ID:").append(entry.msg_id).append("\n\t");
                buf.append("Total Frags:").append(entry.tot_frags).append("\n\t");
                buf.append("Frags Received:").append(count).append("\n\n");
            }
            return buf.toString();
        }

        class Entry {
            int tot_frags = 0;
            byte[][] fragments = null;
            int number_of_frags_recvd = 0;
            long msg_id = -1L;

            Entry(long msg_id, int tot_frags) {
                this.msg_id = msg_id;
                this.tot_frags = tot_frags;
                this.fragments = new byte[tot_frags][];
                int i = 0;
                while (i < tot_frags) {
                    this.fragments[i] = null;
                    ++i;
                }
            }

            public void set(int frag_id, byte[] frag) {
                this.fragments[frag_id] = frag;
                ++this.number_of_frags_recvd;
            }

            public boolean isComplete() {
                if (this.number_of_frags_recvd < this.tot_frags) {
                    return false;
                }
                int i = 0;
                while (i < this.fragments.length) {
                    if (this.fragments[i] == null) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            public byte[] assembleBuffer() {
                return Util.defragmentBuffer(this.fragments);
            }

            public String toString() {
                StringBuffer ret = new StringBuffer();
                ret.append("[tot_frags=" + this.tot_frags + ", number_of_frags_recvd=" + this.number_of_frags_recvd + "]");
                return ret.toString();
            }

            public int hashCode() {
                return super.hashCode();
            }
        }
    }

    class FragmentationList {
        private Hashtable frag_tables = new Hashtable(11);

        FragmentationList() {
        }

        public synchronized void add(Address sender, FragmentationTable table) throws IllegalArgumentException {
            FragmentationTable healthCheck = (FragmentationTable)this.frag_tables.get(sender);
            if (healthCheck != null) {
                throw new IllegalArgumentException("Sender <" + sender + "> already exists in the fragementation list.");
            }
            this.frag_tables.put(sender, table);
        }

        public FragmentationTable get(Address sender) {
            return (FragmentationTable)this.frag_tables.get(sender);
        }

        public boolean containsSender(Address sender) {
            return this.frag_tables.containsKey(sender);
        }

        public synchronized boolean remove(Address sender) {
            boolean result = this.containsSender(sender);
            this.frag_tables.remove(sender);
            return result;
        }

        public synchronized Address[] getSenders() {
            Address[] result = new Address[this.frag_tables.size()];
            Enumeration enumeration = this.frag_tables.keys();
            int index = 0;
            while (enumeration.hasMoreElements()) {
                result[index++] = (Address)enumeration.nextElement();
            }
            return result;
        }

        public String toString() {
            Enumeration e = this.frag_tables.elements();
            StringBuffer buf = new StringBuffer("Fragmentation list contains ").append(this.frag_tables.size()).append(" tables\n");
            while (e.hasMoreElements()) {
                buf.append(e.nextElement());
            }
            return buf.toString();
        }
    }

    private static class FragHeader
    extends Header {
        public long id = 0L;
        public int frag_id = 0;
        public int num_frags = 0;

        public FragHeader() {
        }

        public FragHeader(long id, int frag_id, int num_frags) {
            this.id = id;
            this.frag_id = frag_id;
            this.num_frags = num_frags;
        }

        public String toString() {
            return "[FRAG: id=" + this.id + ", frag_id=" + this.frag_id + ", num_frags=" + this.num_frags + "]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.id);
            out.writeInt(this.frag_id);
            out.writeInt(this.num_frags);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = in.readLong();
            this.frag_id = in.readInt();
            this.num_frags = in.readInt();
        }
    }
}

