/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Membership;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.ClientGmsImpl;
import org.javagroups.protocols.CoordGmsImpl;
import org.javagroups.protocols.FlushRsp;
import org.javagroups.protocols.GmsImpl;
import org.javagroups.protocols.ParticipantGmsImpl;
import org.javagroups.stack.Protocol;
import org.javagroups.stack.RpcProtocol;
import org.javagroups.util.Queue;
import org.javagroups.util.QueueClosedException;
import org.javagroups.util.RspList;

public class GMS
extends RpcProtocol
implements Runnable {
    private GmsImpl impl = null;
    public Properties props = null;
    public Address local_addr = null;
    public String group_addr = null;
    public Membership members = new Membership();
    public ViewId view_id = null;
    public long ltime = 0L;
    public long join_timeout = 5000L;
    public long join_retry_timeout = 2000L;
    private long flush_timeout = 0L;
    private long rebroadcast_timeout = 0L;
    private long view_change_timeout = 10000L;
    public long leave_timeout = 5000L;
    public Object impl_mutex = new Object();
    public Object view_mutex = new Object();
    private Queue event_queue = new Queue();
    private Thread evt_thread = null;
    private Object flush_mutex = new Object();
    private FlushRsp flush_rsp = null;
    private Object rebroadcast_mutex = new Object();
    private boolean rebroadcast_unstable_msgs = true;
    private Hashtable impls = new Hashtable();
    final String CLIENT = "Client";
    final String COORD = "Coordinator";
    final String PART = "Participant";

    public GMS() {
        this.initState();
    }

    public String getName() {
        return "GMS";
    }

    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(33));
        retval.addElement(new Integer(18));
        return retval;
    }

    public void setImpl(GmsImpl new_impl) {
        Object object = this.impl_mutex;
        synchronized (object) {
            this.impl = new_impl;
            if (Trace.trace) {
                Trace.info("GMS.setImpl()", "changed role to " + new_impl.getClass().getName());
            }
        }
    }

    public void becomeCoordinator() {
        CoordGmsImpl tmp = (CoordGmsImpl)this.impls.get("Coordinator");
        if (tmp == null) {
            tmp = new CoordGmsImpl(this);
            tmp.leaving = false;
            tmp.received_last_view = false;
            this.impls.put("Coordinator", tmp);
        }
        this.setImpl(tmp);
    }

    public void becomeParticipant() {
        ParticipantGmsImpl tmp = (ParticipantGmsImpl)this.impls.get("Participant");
        if (tmp == null) {
            tmp = new ParticipantGmsImpl(this);
            tmp.leaving = false;
            tmp.received_final_view = false;
            this.impls.put("Participant", tmp);
        }
        this.setImpl(tmp);
    }

    public void becomeClient() {
        ClientGmsImpl tmp = (ClientGmsImpl)this.impls.get("Client");
        if (tmp == null) {
            tmp = new ClientGmsImpl(this);
            this.impls.put("Client", tmp);
        } else {
            tmp.init();
        }
        this.setImpl(tmp);
    }

    public View getNextView(Vector new_mbrs, Vector old_mbrs, Vector suspected_mbrs) {
        long vid = 0L;
        Vector mbrs_to_remove = new Vector();
        if (old_mbrs != null && old_mbrs.size() > 0) {
            int i = 0;
            while (i < old_mbrs.size()) {
                mbrs_to_remove.addElement(old_mbrs.elementAt(i));
                ++i;
            }
        }
        if (suspected_mbrs != null && suspected_mbrs.size() > 0) {
            int i = 0;
            while (i < suspected_mbrs.size()) {
                if (!mbrs_to_remove.contains(suspected_mbrs.elementAt(i))) {
                    mbrs_to_remove.addElement(suspected_mbrs.elementAt(i));
                }
                ++i;
            }
        }
        Object object = this.view_mutex;
        synchronized (object) {
            View v;
            this.ltime = vid = Math.max(this.view_id.getId(), this.ltime) + 1L;
            Membership tmp_mbrs = this.members.copy();
            tmp_mbrs.merge(new_mbrs, mbrs_to_remove);
            Vector mbrs = (Vector)tmp_mbrs.getMembers().clone();
            View view = v = new View(this.local_addr, vid, mbrs);
            return view;
        }
    }

    Vector computeFlushDestination(Vector suspected_mbrs) {
        Vector ret = this.members.getMembers();
        if (suspected_mbrs != null && suspected_mbrs.size() > 0) {
            int i = 0;
            while (i < suspected_mbrs.size()) {
                ret.removeElement(suspected_mbrs.elementAt(i));
                ++i;
            }
        }
        return ret;
    }

    Vector computeViewDestination(Vector new_mbrs, Vector old_mbrs, Vector suspected_mbrs) {
        Address mbr;
        int i;
        Vector ret = this.members.getMembers();
        if (new_mbrs != null) {
            i = 0;
            while (i < new_mbrs.size()) {
                mbr = (Address)new_mbrs.elementAt(i);
                if (!ret.contains(mbr)) {
                    ret.addElement(new_mbrs.elementAt(i));
                }
                ++i;
            }
        }
        if (suspected_mbrs != null) {
            i = 0;
            while (i < suspected_mbrs.size()) {
                mbr = (Address)suspected_mbrs.elementAt(i);
                ret.removeElement(suspected_mbrs.elementAt(i));
                ++i;
            }
        }
        return ret;
    }

    public void flush(Vector flush_dest, Vector suspected_mbrs) {
        Object object;
        Vector<Message> rebroadcast_msgs = new Vector<Message>();
        if (suspected_mbrs == null) {
            suspected_mbrs = new Vector();
        }
        while (flush_dest.size() > 0) {
            this.flush_rsp = null;
            object = this.flush_mutex;
            synchronized (object) {
                this.passDown(new Event(33, flush_dest));
                try {
                    this.flush_mutex.wait(this.flush_timeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.flush_rsp == null) break;
            if (this.rebroadcast_unstable_msgs && this.flush_rsp.unstable_msgs != null && this.flush_rsp.unstable_msgs.size() > 0) {
                int i = 0;
                while (i < this.flush_rsp.unstable_msgs.size()) {
                    Message m = (Message)this.flush_rsp.unstable_msgs.elementAt(i);
                    rebroadcast_msgs.addElement(m);
                    ++i;
                }
            }
            if (this.flush_rsp.result) break;
            if (this.flush_rsp.failed_mbrs == null) continue;
            int i = 0;
            while (i < this.flush_rsp.failed_mbrs.size()) {
                flush_dest.removeElement(this.flush_rsp.failed_mbrs.elementAt(i));
                suspected_mbrs.addElement(this.flush_rsp.failed_mbrs.elementAt(i));
                ++i;
            }
        }
        if (Trace.trace) {
            Trace.info("GMS.flush()", "flushing completed.");
        }
        if (this.rebroadcast_unstable_msgs && rebroadcast_msgs.size() > 0) {
            if (Trace.trace) {
                Trace.info("GMS.flush()", "re-broadcasting unstable messages (" + rebroadcast_msgs.size() + ")");
            }
            object = this.rebroadcast_mutex;
            synchronized (object) {
                this.passDown(new Event(39, rebroadcast_msgs));
                try {
                    this.rebroadcast_mutex.wait(this.rebroadcast_timeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (Trace.trace) {
                Trace.info("GMS.flush()", "re-broadcasting messages completed");
            }
        }
    }

    public void castViewChange(Vector new_mbrs, Vector old_mbrs, Vector suspected_mbrs) {
        Vector flush_dest = this.computeFlushDestination(suspected_mbrs);
        Vector view_dest = this.computeViewDestination(new_mbrs, old_mbrs, suspected_mbrs);
        View new_view = this.getNextView(new_mbrs, old_mbrs, suspected_mbrs);
        ViewId new_vid = new_view.getVid();
        if (Trace.trace) {
            Trace.info("GMS.castViewChange()", "flush_dest: " + flush_dest + "\n\tview_dest: " + view_dest + "\n\tnew_view: " + new_view + "\n");
        }
        this.flush(flush_dest, suspected_mbrs);
        view_dest = this.computeViewDestination(new_mbrs, old_mbrs, suspected_mbrs);
        View tmp_view = new View(null, view_dest);
        Event view_event = new Event(21, tmp_view);
        this.passDown(view_event);
        if (Trace.trace) {
            Trace.info("GMS.castViewChange()", "mcasting view {" + new_vid + ", " + view_dest + "}");
        }
        this.passDown(new Event(31));
        RspList rsp_list = this.callRemoteMethods(view_dest, "handleViewChange", new_vid, new_view.getMembers(), 2, this.view_change_timeout);
        if (Trace.trace) {
            Trace.info("GMS.castViewChange()", "mcasting view completed");
        }
        this.passDown(new Event(30));
    }

    public void installView(ViewId new_view, Vector mbrs) {
        Object object = this.view_mutex;
        synchronized (object) {
            this.ltime = Math.max(new_view.getId(), this.ltime);
            if (Trace.trace) {
                Trace.info("GMS.installView()", "received view change, vid=" + new_view);
            }
            if (!this.checkSelfInclusion(mbrs)) {
                if (Trace.trace) {
                    Trace.warn("GMS.installView()", "I'm not member of " + mbrs + ", discarding");
                }
                return;
            }
            if (this.view_id == null) {
                if (new_view == null) {
                    Trace.error("GMS.installView()", "view_id and new_view are null !");
                    return;
                }
                this.view_id = (ViewId)new_view.clone();
            } else {
                if (new_view == null) {
                    Trace.error("GMS.installView()", "new_view is null !");
                    return;
                }
                int rc = new_view.compareTo(this.view_id);
                if (rc <= 0) {
                    if (Trace.trace) {
                        Trace.warn("GMS.installView()", "received view <= current view; discarding it ! (view_id: " + this.view_id + ", new_view: " + new_view + ")");
                    }
                    return;
                }
                this.view_id = new_view.getCoordAddress() != null ? new ViewId(new_view.getCoordAddress(), new_view.getId()) : new ViewId(this.view_id.getCoordAddress(), new_view.getId());
            }
            if (mbrs != null && mbrs.size() > 0) {
                this.members.set(mbrs);
            }
            Event view_event = new Event(10, this.makeView(this.members.getMembers()));
            this.passDown(view_event);
            this.passUp(view_event);
            Address coord = this.determineCoordinator();
            if (coord != null && coord.equals(this.local_addr) && !coord.equals(new_view.getCoordAddress())) {
                this.becomeCoordinator();
            }
        }
    }

    protected Address determineCoordinator() {
        Membership membership = this.members;
        synchronized (membership) {
            Address address = this.members != null && this.members.size() > 0 ? (Address)this.members.elementAt(0) : null;
            return address;
        }
    }

    protected boolean checkSelfInclusion(Vector mbrs) {
        if (mbrs == null) {
            return false;
        }
        int i = 0;
        while (i < mbrs.size()) {
            Object mbr = mbrs.elementAt(i);
            if (mbr != null && this.local_addr.equals(mbr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public View makeView(Vector mbrs) {
        Address coord = null;
        long id = 0L;
        if (this.view_id != null) {
            coord = this.view_id.getCoordAddress();
            id = this.view_id.getId();
        }
        return new View(coord, id, mbrs);
    }

    public View makeView(Vector mbrs, ViewId vid) {
        Address coord = null;
        long id = 0L;
        if (vid != null) {
            coord = vid.getCoordAddress();
            id = vid.getId();
        }
        return new View(coord, id, mbrs);
    }

    public void join(Address mbr) {
        Object object = this.impl_mutex;
        synchronized (object) {
            this.impl.join(mbr);
        }
    }

    public void leave(Address mbr) {
        Object object = this.impl_mutex;
        synchronized (object) {
            this.impl.leave(mbr);
        }
    }

    public void suspect(Address mbr) {
        Object object = this.impl_mutex;
        synchronized (object) {
            this.impl.suspect(mbr);
        }
    }

    public void merge(Vector other_coords) {
        Object object = this.impl_mutex;
        synchronized (object) {
            this.impl.merge(other_coords);
        }
    }

    public boolean handleJoin(Address mbr) {
        Object object = this.impl_mutex;
        synchronized (object) {
            boolean bl = this.impl.handleJoin(mbr);
            return bl;
        }
    }

    public void handleLeave(Address mbr, boolean suspected) {
        Object object = this.impl_mutex;
        synchronized (object) {
            this.impl.handleLeave(mbr, suspected);
        }
    }

    public void handleViewChange(ViewId new_view, Vector mbrs) {
        this.impl.handleViewChange(new_view, mbrs);
    }

    public View handleMerge(ViewId other_vid, Vector other_members) {
        Object object = this.impl_mutex;
        synchronized (object) {
            if (Trace.trace) {
                View v = this.impl.handleMerge(other_vid, other_members);
                Trace.info("GMS.handleMerge()", "returning view: " + v);
                View view = v;
                return view;
            }
            View view = this.impl.handleMerge(other_vid, other_members);
            return view;
        }
    }

    public void handleSuspect(Address mbr) {
        Object object = this.impl_mutex;
        synchronized (object) {
            this.impl.handleSuspect(mbr);
        }
    }

    boolean checkForViewEnforcer(Protocol up_protocol) {
        if (up_protocol == null) {
            return false;
        }
        String prot_name = up_protocol.getName();
        if (prot_name != null && prot_name.equals("VIEW_ENFORCER")) {
            return true;
        }
        return this.checkForViewEnforcer(up_protocol.getUpProtocol());
    }

    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 1: {
                if (!this.checkForViewEnforcer(this.up_prot)) {
                    Trace.warn("GMS.handleUpEvent()", "[START]: I need protocol layer VIEW_ENFORCER above me to discard messages sent to me while I'm not yet a group member ! Otherwise, these messages will be delivered to the application without checking...\n");
                }
                if (this._corr != null) {
                    this._corr.setDeadlockDetection(true);
                    break;
                }
                Trace.error("GMS.handleUpEvent()", "cannot set deadlock detection in corr, as it is null !");
                break;
            }
            case 7: 
            case 9: {
                return false;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                System.out.println("\n-------------------------------------------------------\nGMS: address is " + this.local_addr + "\n-------------------------------------------------------");
                return true;
            }
            case 15: {
                try {
                    this.event_queue.add(evt);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return true;
            }
            case 20: {
                try {
                    this.event_queue.add(evt);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return false;
            }
            case 34: {
                Object object = this.flush_mutex;
                synchronized (object) {
                    this.flush_rsp = (FlushRsp)evt.getArg();
                    this.flush_mutex.notify();
                }
                return false;
            }
            case 40: {
                Object object = this.rebroadcast_mutex;
                synchronized (object) {
                    this.rebroadcast_mutex.notify();
                }
                return false;
            }
        }
        return this.impl.handleUpEvent(evt);
    }

    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.passDown(evt);
                try {
                    this.group_addr = (String)evt.getArg();
                }
                catch (ClassCastException cce) {
                    Trace.error("GMS.handleDownEvent(CONNECT)", "group address must be a string (group name) to make sense");
                }
                this.impl.join(this.local_addr);
                this.passUp(new Event(7));
                this.startEventHandlerThread();
                return false;
            }
            case 8: {
                this.impl.leave((Address)evt.getArg());
                this.passUp(new Event(9));
                this.stopEventHandlerThread();
                this.initState();
                return true;
            }
        }
        return this.impl.handleDownEvent(evt);
    }

    public void receiveDownEvent(Event evt) {
        if (evt.getType() == 17) {
            this.passDown(evt);
            return;
        }
        super.receiveDownEvent(evt);
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("join_timeout");
        if (str != null) {
            this.join_timeout = new Long(str);
            ((Hashtable)props).remove("join_timeout");
        }
        if ((str = props.getProperty("view_change_timeout")) != null) {
            this.view_change_timeout = new Long(str);
            ((Hashtable)props).remove("view_change_timeout");
        }
        if ((str = props.getProperty("join_retry_timeout")) != null) {
            this.join_retry_timeout = new Long(str);
            ((Hashtable)props).remove("join_retry_timeout");
        }
        if ((str = props.getProperty("leave_timeout")) != null) {
            this.leave_timeout = new Long(str);
            ((Hashtable)props).remove("leave_timeout");
        }
        if ((str = props.getProperty("flush_timeout")) != null) {
            this.flush_timeout = new Long(str);
            ((Hashtable)props).remove("flush_timeout");
        }
        if ((str = props.getProperty("rebroadcast_unstable_msgs")) != null) {
            this.rebroadcast_unstable_msgs = new Boolean(str);
            ((Hashtable)props).remove("rebroadcast_unstable_msgs");
        }
        if ((str = props.getProperty("rebroadcast_timeout")) != null) {
            this.rebroadcast_timeout = new Long(str);
            ((Hashtable)props).remove("rebroadcast_timeout");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("GMS.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void run() {
        while (this.evt_thread != null && this.event_queue != null) {
            try {
                Event evt = (Event)this.event_queue.remove();
                switch (evt.getType()) {
                    case 15: {
                        this.impl.suspect((Address)evt.getArg());
                        break;
                    }
                    case 20: {
                        this.impl.merge((Vector)evt.getArg());
                        break;
                    }
                    default: {
                        Trace.error("GMS.run()", "event handler thread encountered event of type " + Event.type2String(evt.getType()) + ": not handled by me !");
                        break;
                    }
                }
            }
            catch (QueueClosedException closed) {
                break;
            }
            catch (Exception ex) {
                Trace.warn("GMS.run()", "exception=" + ex);
            }
        }
    }

    void initState() {
        this.becomeClient();
        this.impl.init();
        this.view_id = null;
        if (this.members != null) {
            this.members.clear();
        }
    }

    private void startEventHandlerThread() {
        if (this.event_queue == null) {
            this.event_queue = new Queue();
        }
        if (this.evt_thread == null) {
            this.evt_thread = new Thread((Runnable)this, "GMS.EventHandlerThread");
            this.evt_thread.start();
        }
    }

    private void stopEventHandlerThread() {
        if (this.evt_thread != null) {
            this.event_queue.close(false);
            this.event_queue = null;
            this.evt_thread = null;
            return;
        }
        if (this.event_queue != null) {
            this.event_queue.close(false);
            this.event_queue = null;
        }
    }
}

