/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

public class LOOPBACK
extends Protocol {
    private Address local_addr = null;
    private String group_addr = null;
    private Properties properties = null;
    private Vector members = new Vector();

    public LOOPBACK() {
        this.local_addr = new IpAddress("localhost", 10000);
    }

    public String toString() {
        return "Protocol LOOPBACK(local address: " + this.local_addr + ")";
    }

    private void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    public String getName() {
        return "LOOPBACK";
    }

    public boolean setProperties(Properties props) {
        if (((Hashtable)props).size() > 0) {
            System.err.println("LOOPBACK.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        if (evt.getType() == 1) {
            this.passUp(evt);
            this.passUp(new Event(12, this.local_addr));
            this.passUp(new Event(2));
            return;
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        if (Trace.trace) {
            Trace.info("LOOPBACK.down()", "event is " + evt + ", group_addr=" + this.group_addr + ", time is " + System.currentTimeMillis() + ", hdrs: " + Util.printEvent(evt));
        }
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                Message rsp = msg.copy();
                Address dest_addr = msg.getDest();
                rsp.setDest(this.local_addr);
                rsp.setSrc(dest_addr != null ? dest_addr : this.local_addr);
                this.passUp(new Event(5, rsp));
                break;
            }
            case 10: 
            case 21: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    int i = 0;
                    while (i < tmpvec.size()) {
                        this.members.addElement(tmpvec.elementAt(i));
                        ++i;
                    }
                    break;
                }
            }
            case 11: {
                this.passUp(new Event(12, this.local_addr));
                break;
            }
            case 13: {
                this.passUp(new Event(14));
                break;
            }
            case 3: {
                this.passUp(new Event(4));
                break;
            }
            case 6: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(7));
                break;
            }
            case 8: {
                this.passUp(new Event(9));
                break;
            }
            case 53: {
                this.passUp(evt);
            }
        }
    }
}

