/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Membership;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.stack.RouterStub;
import org.javagroups.util.List;
import org.javagroups.util.Util;

public class MERGE
extends Protocol
implements Runnable {
    Vector members = new Vector();
    Address local_addr = null;
    String group_addr = null;
    String groupname = null;
    Thread hello_thread = null;
    long timeout = 5000L;
    String router_host = null;
    int router_port = 0;
    RouterStub client = null;
    boolean is_server = false;
    boolean is_coord = false;
    boolean merging = false;

    public String getName() {
        return "MERGE";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            ((Hashtable)props).remove("timeout");
        }
        if ((str = props.getProperty("router_host")) != null) {
            this.router_host = new String(str);
            ((Hashtable)props).remove("router_host");
        }
        if ((str = props.getProperty("router_port")) != null) {
            this.router_port = new Integer(str);
            ((Hashtable)props).remove("router_port");
        }
        if (this.router_host != null && this.router_port != 0) {
            this.client = new RouterStub(this.router_host, this.router_port);
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("MERGE.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.peekHeader();
                if (obj == null || !(obj instanceof MergeHeader)) {
                    this.passUp(evt);
                    return;
                }
                MergeHeader hdr = (MergeHeader)msg.removeHeader();
                switch (hdr.type) {
                    case 1: {
                        if (!this.is_server || !this.is_coord) {
                            return;
                        }
                        if (this.merging) {
                            return;
                        }
                        Address sender = msg.getSrc();
                        if (sender != null && this.members.size() >= 0) {
                            boolean contains;
                            Vector vector = this.members;
                            synchronized (vector) {
                                contains = this.members.contains(sender);
                            }
                            if (!contains && sender.compareTo(this.local_addr) < 0) {
                                if (Trace.trace) {
                                    Trace.info("MERGE.up()", "membership " + this.members + " does not contain " + sender + "; merging it");
                                }
                                Vector<Address> tmp = new Vector<Address>();
                                tmp.addElement(sender);
                                this.merging = true;
                                this.passUp(new Event(20, tmp));
                            }
                        }
                        return;
                    }
                }
                Trace.error("MERGE.up()", "got MERGE hdr with unknown type (" + hdr.type + ")");
                return;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                this.passUp(evt);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    public void down(Event evt) {
        Vector gossip_rsps = new Vector();
        switch (evt.getType()) {
            case 21: {
                this.passDown(evt);
                break;
            }
            case 51: {
                this.merging = false;
                this.passDown(evt);
                break;
            }
            case 10: {
                this.merging = false;
                this.members = ((View)evt.getArg()).getMembers();
                if (this.members == null || this.members.size() == 0) {
                    Trace.fatal("MERGE.down()", "received VIEW_CHANGE with null or empty vector");
                    System.exit(6);
                }
                this.is_coord = this.members.elementAt(0).equals(this.local_addr);
                this.passDown(evt);
                if (this.is_coord) {
                    if (Trace.trace) {
                        Trace.info("MERGE.down()", "start sending Hellos");
                    }
                    this.start();
                    break;
                }
                if (Trace.trace) {
                    Trace.info("MERGE.down()", "stop sending Hellos");
                }
                this.stop();
                break;
            }
            case 22: {
                this.passDown(evt);
                this.start();
                this.is_server = true;
                break;
            }
            case 6: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                break;
            }
            case 8: {
                if (this.local_addr != null && evt.getArg() != null && this.local_addr.equals(evt.getArg())) {
                    this.stop();
                }
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    public void run() {
        Vector members_to_merge = new Vector();
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (Exception e) {}
        while (this.hello_thread != null) {
            Util.sleep(this.timeout);
            if (this.hello_thread == null) break;
            if (this.client == null) {
                Message hello_msg = new Message(null, null, null);
                MergeHeader hdr = new MergeHeader(1);
                hello_msg.addHeader(hdr);
                this.passDown(new Event(5, hello_msg));
                continue;
            }
            List rsps = this.client.get(this.group_addr);
            Vector vector = this.members;
            synchronized (vector) {
                members_to_merge.removeAllElements();
                Enumeration e = rsps.elements();
                while (e.hasMoreElements()) {
                    Object mbr = e.nextElement();
                    if (this.members.contains(mbr)) continue;
                    Trace.info("MERGE.run()", "membership " + this.members + " does not contain " + mbr + "; merging it");
                    members_to_merge.addElement(mbr);
                }
                if (members_to_merge.size() > 0) {
                    Membership new_membership = new Membership(members_to_merge);
                    new_membership.sort();
                    Address coord = (Address)new_membership.elementAt(0);
                    Vector<Address> tmp = new Vector<Address>();
                    tmp.addElement(coord);
                    if (coord.compareTo(this.local_addr) < 0) {
                        this.passUp(new Event(20, tmp));
                    }
                }
            }
        }
    }

    void start() {
        if (this.hello_thread == null) {
            this.hello_thread = new Thread((Runnable)this, "MERGE Thread");
            this.hello_thread.start();
        }
    }

    void stop() {
        Thread tmp = null;
        if (this.hello_thread != null && this.hello_thread.isAlive()) {
            tmp = this.hello_thread;
            this.hello_thread = null;
            tmp.interrupt();
            try {
                tmp.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.hello_thread = null;
    }

    static class MergeHeader
    extends Header {
        public static final int HELLO = 1;
        public int type = 0;

        public MergeHeader() {
        }

        public MergeHeader(int type) {
            this.type = type;
        }

        public String toString() {
            return "[MERGE: type=" + this.type2Str(this.type) + "]";
        }

        String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "HELLO";
                }
            }
            return "<unkown type (" + t + ")>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }
    }
}

