/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.protocols.SavedMessages;

class MessageAcks {
    private Vector acks = new Vector();
    private SavedMessages message_history = new SavedMessages();

    public MessageAcks(Vector members) {
        this.reset(members);
    }

    public synchronized void reset(Vector members) {
        this.clear();
        int num_members = members.size();
        int i = 0;
        while (i < num_members) {
            Object temp_obj = members.elementAt(i);
            if (!(temp_obj instanceof Address)) {
                System.err.println("Error: (TOTAL_OLD) MessageAcks.reset() - could not cast element of \"members\" to an Address object");
                return;
            }
            this.acks.addElement(new Entry((Address)temp_obj));
            ++i;
        }
    }

    private void clear() {
        this.acks.removeAllElements();
        this.message_history.clearMessages();
    }

    private Entry getEntry(Address addr) {
        Vector vector = this.acks;
        synchronized (vector) {
            int size = this.acks.size();
            int i = 0;
            while (i < size) {
                Object temp_obj = this.acks.elementAt(i);
                if (temp_obj instanceof Entry) {
                    Entry this_entry = (Entry)temp_obj;
                    if (this_entry.addr.equals(addr)) {
                        Entry entry = this_entry;
                        return entry;
                    }
                } else {
                    System.err.println("Error: (TOTAL_OLD) MessageAcks.getEntry() - could not cast element of \"acks\" to an Entry");
                }
                ++i;
            }
            Entry entry = null;
            return entry;
        }
    }

    public void setSeq(Address addr, long seq) {
        Entry this_entry = this.getEntry(addr);
        if (this_entry != null && this_entry.seq < seq) {
            this_entry.seq = seq;
            this.truncateHistory();
        }
    }

    public long getSeq(Address addr) {
        Entry this_entry = this.getEntry(addr);
        if (this_entry == null) {
            return -2L;
        }
        return this_entry.seq;
    }

    public Message getMessage(long seq) {
        return this.message_history.peekMessage(seq);
    }

    public void addMessage(Message msg, long seq) {
        this.message_history.insertMessage(msg, seq);
    }

    private long getLowestSeqAck() {
        Vector vector = this.acks;
        synchronized (vector) {
            long ret_val = -10L;
            int size = this.acks.size();
            int i = 0;
            while (i < size) {
                Object temp_obj = this.acks.elementAt(i);
                if (temp_obj instanceof Entry) {
                    long this_seq = ((Entry)temp_obj).seq;
                    if (this_seq < ret_val) {
                        ret_val = this_seq;
                    }
                } else {
                    System.err.println("Error: (TOTAL_OLD) MessageAcks.getLowestSeqAck() - could not cast element of \"acks\" to an Entry (index=" + i + ")");
                    long l = -1L;
                    return l;
                }
                ++i;
            }
            long l = ret_val;
            return l;
        }
    }

    private synchronized void truncateHistory() {
        long lowest_ack_seq = this.getLowestSeqAck();
        if (lowest_ack_seq < 0L) {
            return;
        }
        SavedMessages savedMessages = this.message_history;
        synchronized (savedMessages) {
            long lowest_stored_seq;
            while ((lowest_stored_seq = this.message_history.getFirstSeq()) >= 0L && lowest_stored_seq > lowest_ack_seq) {
                this.message_history.getFirstMessage();
            }
        }
    }

    class Entry {
        public Address addr;
        public long seq;

        public Entry(Address addr, long seq) {
            this.addr = addr;
            this.seq = seq;
        }

        public Entry(Address addr) {
            this.addr = addr;
            this.seq = -1L;
        }
    }
}

