/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.Digest;
import org.javagroups.protocols.NakAckHeader;
import org.javagroups.stack.AckMcastReceiverWindow;
import org.javagroups.stack.AckMcastSenderWindow;
import org.javagroups.stack.NakReceiverWindow;
import org.javagroups.stack.Protocol;
import org.javagroups.util.List;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

public class NAKACK
extends Protocol {
    long[] retransmit_timeout = new long[]{2000L, 3000L, 5000L, 8000L};
    NAKer naker = null;
    OutOfBander out_of_bander = null;
    NAKer transmitter = null;
    ViewId vid = null;
    View view = null;
    boolean is_server = false;
    Address local_addr = null;
    List queued_msgs = new List();
    Vector members = null;
    boolean send_next_msg_out_of_band = false;
    boolean send_next_msg_acking = false;
    long rebroadcast_timeout = 0L;
    TimeScheduler timer = null;

    public void init() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            Trace.error("NAKACK.init()", "timer is null");
        }
        this.naker = new NAKer();
        this.out_of_bander = new OutOfBander();
        this.transmitter = this.naker;
    }

    public String getName() {
        return "NAKACK";
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(37));
        retval.addElement(new Integer(43));
        return retval;
    }

    public Vector providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(41));
        return retval;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 15: {
                this.transmitter.suspect((Address)evt.getArg());
                this.out_of_bander.suspect((Address)evt.getArg());
                break;
            }
            case 36: {
                this.naker.stable((long[])evt.getArg());
                return;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 41: {
                long[] highest = this.naker.getHighestSeqnosDelivered();
                this.passDown(new Event(42, highest));
                return;
            }
            case 5: {
                NAKACK nAKACK = this;
                synchronized (nAKACK) {
                    Message msg = (Message)evt.getArg();
                    Header obj = msg.peekHeader();
                    if (obj == null || !(obj instanceof NakAckHeader)) {
                        break;
                    }
                    NakAckHeader hdr = (NakAckHeader)msg.removeHeader();
                    switch (hdr.type) {
                        case 1: 
                        case 2: 
                        case 3: {
                            NakAckHeader h;
                            Message ack_msg;
                            if (hdr.type == 3) {
                                ack_msg = new Message(hdr.sender, null, null);
                                h = new NakAckHeader(5, hdr.seqno, null);
                                if (hdr.sender == null) {
                                    Trace.warn("NAKACK.up()", "WRAPPED: header's 'sender' field is null; cannot send ACK !");
                                }
                                ack_msg.addHeader(h);
                                this.passDown(new Event(5, ack_msg));
                                hdr = (NakAckHeader)msg.removeHeader();
                            }
                            if (hdr.type == 2) {
                                ack_msg = new Message(msg.getSrc(), null, null);
                                h = new NakAckHeader(5, hdr.seqno, null);
                                ack_msg.addHeader(h);
                                this.passDown(new Event(5, ack_msg));
                            }
                            if (!this.is_server) {
                                Message msg_copy = msg.copy();
                                msg_copy.addHeader(hdr);
                                this.queued_msgs.add(msg_copy);
                                this.passUp(new Event(5, msg));
                                return;
                            }
                            if (this.vid != null && hdr.vid != null) {
                                Address my_addr = this.vid.getCoordAddress();
                                Address other_addr = hdr.vid.getCoordAddress();
                                if (my_addr == null || other_addr == null) {
                                    Trace.warn("NAKACK.up()", "my vid or message's vid does not contain a coordinator; discarding message !");
                                    return;
                                }
                                if (!my_addr.equals(other_addr)) {
                                    Trace.warn("NAKACK.up()", "creator of own vid (" + my_addr + ")is different from creator of message's vid (" + other_addr + "); discarding message !");
                                    return;
                                }
                                int rc = hdr.vid.compareTo(this.vid);
                                if (rc > 0) {
                                    if (Trace.trace) {
                                        Trace.info("NAKACK.up()", "message's vid (" + hdr.vid + "#" + hdr.seqno + ") is bigger than current vid: (" + this.vid + ") message is queued !");
                                    }
                                    msg.addHeader(hdr);
                                    this.queued_msgs.add(msg);
                                    return;
                                }
                                if (rc < 0) {
                                    if (Trace.trace) {
                                        Trace.warn("NAKACK.up()", "message's vid (" + hdr.vid + ") is smaller than " + "current vid (" + this.vid + "): message <" + msg.getSrc() + ":#" + hdr.seqno + "> is discarded ! Hdr is " + hdr);
                                    }
                                    return;
                                }
                            }
                            msg.addHeader(hdr);
                            this.naker.receive(hdr.seqno, msg, null);
                            return;
                        }
                        case 4: {
                            this.naker.retransmit(msg.getSrc(), hdr.seqno, hdr.last_seqno);
                            return;
                        }
                        case 5: {
                            this.naker.receiveAck(hdr.seqno, msg.getSrc());
                            return;
                        }
                        case 6: {
                            this.out_of_bander.receive(hdr.seqno, msg, hdr.stable_msgs);
                            return;
                        }
                        case 7: {
                            this.out_of_bander.receiveAck(hdr.seqno, msg.getSrc());
                            return;
                        }
                    }
                    Trace.error("NAKACK.up()", "NakAck header type " + hdr.type + " not known !");
                    break;
                }
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        if (Trace.trace) {
            Trace.debug("NAKACK.down()", "queued_msgs has " + this.queued_msgs.size() + " messages " + "\n\nnaker:\n" + this.naker.dumpContents() + "\n\nout_of_bander: " + this.out_of_bander.dumpContents() + "\n-----------------------------\n");
        }
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                if (this.send_next_msg_out_of_band) {
                    this.out_of_bander.send(msg);
                    this.send_next_msg_out_of_band = false;
                } else if (this.send_next_msg_acking) {
                    this.transmitter.setAcks(true);
                    this.transmitter.send(msg);
                    this.transmitter.setAcks(false);
                    this.send_next_msg_acking = false;
                } else {
                    this.transmitter.send(msg);
                }
                return;
            }
            case 37: {
                long[] highest_seqnos = (long[])evt.getArg();
                Digest digest = this.naker.computeMessageDigest(highest_seqnos);
                this.passUp(new Event(38, digest));
                return;
            }
            case 43: {
                List lower_seqnos = this.naker.getMessagesInRange((long[][])evt.getArg());
                this.passUp(new Event(44, lower_seqnos));
                return;
            }
            case 39: {
                this.rebroadcastMsgs((Vector)evt.getArg());
                break;
            }
            case 21: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members = mbrs != null ? (Vector)mbrs.clone() : new Vector();
                break;
            }
            case 10: {
                NAKACK nAKACK = this;
                synchronized (nAKACK) {
                    this.view = (View)((View)evt.getArg()).clone();
                    this.vid = this.view.getVid();
                    this.members = (Vector)this.view.getMembers().clone();
                    this.naker.reset();
                    this.out_of_bander.reset();
                    this.is_server = true;
                    if (this.queued_msgs.size() > 0) {
                        this.deliverQueuedMessages();
                    }
                    break;
                }
            }
            case 22: {
                this.is_server = true;
                break;
            }
            case 30: {
                this.transmitter.setAcks(false);
                return;
            }
            case 31: {
                this.send_next_msg_acking = true;
                return;
            }
            case 32: {
                this.send_next_msg_out_of_band = true;
                return;
            }
            case 3: {
                this.out_of_bander.stop();
                this.naker.stop();
                break;
            }
            case 41: {
                long[] h = this.naker.getHighestSeqnosDelivered();
                this.passUp(new Event(42, h));
            }
        }
        this.passDown(evt);
    }

    boolean coordinator() {
        if (this.members == null || this.members.size() < 1 || this.local_addr == null) {
            return false;
        }
        return this.local_addr.equals(this.members.elementAt(0));
    }

    void rebroadcastMsgs(Vector v) {
        Message m1;
        Vector<Message> final_v = new Vector<Message>();
        if (v == null) {
            return;
        }
        int i = 0;
        while (i < v.size()) {
            boolean present = false;
            m1 = (Message)v.elementAt(i);
            NakAckHeader h1 = (NakAckHeader)m1.peekHeader();
            int j = 0;
            while (j < final_v.size()) {
                Message m2 = (Message)final_v.elementAt(j);
                NakAckHeader h2 = (NakAckHeader)m2.peekHeader();
                if (h1.seqno == h2.seqno && m1.getSrc().equals(m2.getSrc())) {
                    present = true;
                }
                ++j;
            }
            if (!present) {
                final_v.addElement(m1);
            }
            ++i;
        }
        if (Trace.trace) {
            Trace.warn("NAKACK.rebroadcastMsgs()", "rebroadcasting " + final_v.size() + " messages");
        }
        int i2 = 0;
        while (i2 < final_v.size()) {
            m1 = (Message)final_v.elementAt(i2);
            this.naker.resend(m1);
            ++i2;
        }
        this.naker.waitUntilAllAcksReceived(this.rebroadcast_timeout);
        this.passUp(new Event(40));
    }

    void deliverQueuedMessages() {
        while (this.queued_msgs.size() > 0) {
            Message tmpmsg = (Message)this.queued_msgs.removeFromHead();
            NakAckHeader hdr = (NakAckHeader)tmpmsg.peekHeader();
            int rc = hdr.vid.compareTo(this.vid);
            if (rc == 0) {
                this.up(new Event(5, tmpmsg));
                continue;
            }
            if (rc <= 0) continue;
        }
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("retransmit_timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            ((Hashtable)props).remove("retransmit_timeout");
            if (tmp != null && tmp.length > 0) {
                this.retransmit_timeout = tmp;
            }
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("NAKACK.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    class OutOfBander
    implements AckMcastSenderWindow.RetransmitCommand {
        AckMcastSenderWindow sender_win;
        AckMcastReceiverWindow receiver_win;
        long seqno;

        OutOfBander() {
            this.sender_win = new AckMcastSenderWindow((AckMcastSenderWindow.RetransmitCommand)this, NAKACK.this.timer);
            this.receiver_win = new AckMcastReceiverWindow();
            this.seqno = 0L;
        }

        void send(Message msg) {
            long id = this.seqno++;
            Vector stable_msgs = this.sender_win.getStableMessages();
            if (Trace.trace) {
                Trace.info("NAKACK.OutOfBander.send()", "sending msg #=" + id);
            }
            NakAckHeader hdr = new NakAckHeader(6, id, null);
            hdr.stable_msgs = stable_msgs;
            msg.addHeader(hdr);
            this.sender_win.add(id, msg.copy(), (Vector)NAKACK.this.members.clone());
            NAKACK.this.passDown(new Event(5, msg));
        }

        void receive(long id, Message msg, Vector stable_msgs) {
            Address sender = msg.getSrc();
            Message ack_msg = new Message(msg.getSrc(), null, null);
            NakAckHeader hdr = new NakAckHeader(7, id, null);
            ack_msg.addHeader(hdr);
            if (Trace.trace) {
                Trace.info("NAKACK.OutOfBander.receive()", "received <" + sender + "#" + id + ">\n");
            }
            if (this.receiver_win.add(sender, id)) {
                NAKACK.this.passUp(new Event(5, msg));
            }
            NAKACK.this.passDown(new Event(5, ack_msg));
            if (Trace.trace) {
                Trace.info("NAKACKER.OutOfBander.receive()", "sending ack <" + sender + "#" + id + ">\n");
            }
            if (stable_msgs != null) {
                this.receiver_win.remove(sender, stable_msgs);
            }
        }

        void receiveAck(long id, Address sender) {
            if (Trace.trace) {
                Trace.info("NAKACK.OutOfBander.receiveAck()", "received ack <" + sender + "#" + id + ">");
            }
            this.sender_win.ack(id, sender);
        }

        public void retransmit(long seqno, Message msg, Address dest) {
            if (Trace.trace) {
                Trace.info("NAKACK.OutOfBander.retransmit()", "dest=" + dest + ", msg #" + seqno);
            }
            msg.setDest(dest);
            NAKACK.this.passDown(new Event(5, msg));
        }

        void reset() {
            this.sender_win.reset();
            this.receiver_win.reset();
        }

        void suspect(Address mbr) {
            this.sender_win.suspect(mbr);
            this.receiver_win.suspect(mbr);
        }

        void start() {
            this.sender_win.start();
        }

        void stop() {
            if (this.sender_win != null) {
                this.sender_win.stop();
            }
        }

        String dumpContents() {
            StringBuffer ret = new StringBuffer();
            ret.append("\nsender_win:\n" + this.sender_win.toString() + "\nreceiver_win:\n" + this.receiver_win.toString());
            return ret.toString();
        }
    }

    class NAKer
    implements NakReceiverWindow.RetransmitCommand,
    AckMcastSenderWindow.RetransmitCommand {
        long seqno = 0L;
        Hashtable received_msgs = new Hashtable();
        Hashtable sent_msgs = new Hashtable();
        AckMcastSenderWindow sender_win;
        boolean acking;
        long deleted_up_to;
        LastMessageRetransmitter last_msg_xmitter;

        NAKer() {
            this.sender_win = new AckMcastSenderWindow((AckMcastSenderWindow.RetransmitCommand)this, NAKACK.this.timer);
            this.acking = false;
            this.deleted_up_to = 0L;
            this.last_msg_xmitter = new LastMessageRetransmitter();
            if (NAKACK.this.timer != null) {
                NAKACK.this.timer.add(this.last_msg_xmitter, true);
            } else {
                Trace.error("NAKACK.NAKer.NAKer()", "timer is null");
            }
        }

        long getNextSeqno() {
            return this.seqno++;
        }

        long getHighestSeqnoSent() {
            long highest_sent = -1L;
            Enumeration e = this.sent_msgs.keys();
            while (e.hasMoreElements()) {
                highest_sent = Math.max(highest_sent, (Long)e.nextElement());
            }
            return highest_sent;
        }

        long[] getHighestSeqnosDelivered() {
            long[] highest_deliv;
            long[] lArray = highest_deliv = NAKACK.this.members != null ? new long[NAKACK.this.members.size()] : null;
            if (highest_deliv == null) {
                return null;
            }
            int i = 0;
            while (i < highest_deliv.length) {
                highest_deliv[i] = -1L;
                ++i;
            }
            Vector vector = NAKACK.this.members;
            synchronized (vector) {
                int i2 = 0;
                while (i2 < NAKACK.this.members.size()) {
                    Address mbr = (Address)NAKACK.this.members.elementAt(i2);
                    NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(mbr);
                    if (win != null) {
                        highest_deliv[i2] = win.getHighestDelivered();
                    }
                    ++i2;
                }
            }
            return highest_deliv;
        }

        List getSentMessagesHigherThan(long seqno) {
            List retval = new List();
            Enumeration e = this.sent_msgs.keys();
            while (e.hasMoreElements()) {
                Long key = (Long)e.nextElement();
                if (key <= seqno) continue;
                retval.add(this.sent_msgs.get(key));
            }
            return retval;
        }

        Digest computeMessageDigest(long[] highest_seqnos) {
            Enumeration e;
            List unstable_msgs;
            Digest digest = highest_seqnos != null ? new Digest(highest_seqnos.length) : null;
            long highest_seqno_sent = -1L;
            long highest_seqno_received = -1L;
            if (digest == null) {
                if (Trace.trace) {
                    Trace.warn("NAKACK.NAKer.computeMessageDigest()", "highest_seqnos is null, cannot compute digest !");
                }
                return null;
            }
            if (highest_seqnos.length != NAKACK.this.members.size()) {
                if (Trace.trace) {
                    Trace.warn("NAKACK.NAKer.computeMessageDigest()", "the mbrship size and the size of the highest_seqnos array are not equal, cannot compute digest !");
                }
                return null;
            }
            int i = 0;
            while (i < digest.highest_seqnos.length) {
                digest.highest_seqnos[i] = highest_seqnos[i];
                ++i;
            }
            int i2 = 0;
            while (i2 < highest_seqnos.length) {
                NakReceiverWindow win;
                Address sender = (Address)NAKACK.this.members.elementAt(i2);
                if (sender != null && (win = (NakReceiverWindow)this.received_msgs.get(sender)) != null) {
                    digest.highest_seqnos[i2] = win.getHighestReceived();
                    unstable_msgs = win.getMessagesHigherThan(highest_seqnos[i2]);
                    e = unstable_msgs.elements();
                    while (e.hasMoreElements()) {
                        digest.msgs.add(e.nextElement());
                    }
                }
                ++i2;
            }
            int own_index = NAKACK.this.members.indexOf(NAKACK.this.local_addr);
            if (own_index == -1) {
                if (Trace.trace) {
                    Trace.warn("NAKACK.computeMessageDigest()", "no own address in highest_seqnos");
                }
                return digest;
            }
            highest_seqno_received = digest.highest_seqnos[own_index];
            highest_seqno_sent = this.getHighestSeqnoSent();
            if (highest_seqno_sent > highest_seqno_received) {
                digest.highest_seqnos[own_index] = highest_seqno_sent;
                unstable_msgs = this.getSentMessagesHigherThan(highest_seqno_received);
                e = unstable_msgs.elements();
                while (e.hasMoreElements()) {
                    digest.msgs.add(e.nextElement());
                }
            }
            return digest;
        }

        List getMessagesInRange(long[][] range) {
            List retval = new List();
            int i = 0;
            while (i < range.length) {
                List tmp;
                NakReceiverWindow win;
                Address sender;
                if (range[i] != null && (sender = (Address)NAKACK.this.members.elementAt(i)) != null && (win = (NakReceiverWindow)this.received_msgs.get(sender)) != null && (tmp = win.getMessagesInRange(range[i][0], range[i][1])) != null && tmp.size() >= 1) {
                    Enumeration e = tmp.elements();
                    while (e.hasMoreElements()) {
                        retval.add(e.nextElement());
                    }
                }
                ++i;
            }
            return retval;
        }

        void setAcks(boolean f) {
            this.acking = f;
        }

        void stable(long[] seqnos) {
            if (NAKACK.this.members == null || NAKACK.this.local_addr == null) {
                if (Trace.trace) {
                    Trace.warn("NAKACK.NAKer.stable()", "members or local_addr are null !");
                }
                return;
            }
            int index = NAKACK.this.members.indexOf(NAKACK.this.local_addr);
            if (index < 0) {
                if (Trace.trace) {
                    Trace.warn("NAKACK.NAKer.stable()", "member " + NAKACK.this.local_addr + " not found in " + NAKACK.this.members);
                }
                return;
            }
            long seqno = seqnos[index];
            if (Trace.trace) {
                Trace.info("NAKACK.stable()", "deleting stable messages [" + this.deleted_up_to + " - " + seqno + "]");
            }
            Hashtable hashtable = this.sent_msgs;
            synchronized (hashtable) {
                long i = this.deleted_up_to;
                while (i <= seqno) {
                    this.sent_msgs.remove(new Long(i));
                    ++i;
                }
                this.deleted_up_to = seqno;
            }
            int i = 0;
            while (i < NAKACK.this.members.size()) {
                Address sender = (Address)NAKACK.this.members.elementAt(i);
                NakReceiverWindow recv_win = (NakReceiverWindow)this.received_msgs.get(sender);
                if (recv_win != null) {
                    recv_win.stable(seqnos[i]);
                }
                ++i;
            }
        }

        void send(Message msg) {
            long id = this.getNextSeqno();
            if (NAKACK.this.vid == null) {
                return;
            }
            ViewId vid_copy = (ViewId)NAKACK.this.vid.clone();
            if (this.acking) {
                msg.addHeader(new NakAckHeader(2, id, vid_copy));
                this.sender_win.add(id, msg.copy(), (Vector)NAKACK.this.members.clone());
            } else {
                msg.addHeader(new NakAckHeader(1, id, vid_copy));
            }
            if (Trace.trace) {
                Trace.info("NAKACK.NAKer.send()", "sending msg #" + id);
            }
            this.sent_msgs.put(new Long(id), msg.copy());
            NAKACK.this.passDown(new Event(5, msg));
        }

        void resend(Message msg) {
            Message copy = msg.copy();
            NakAckHeader hdr = (NakAckHeader)copy.peekHeader();
            long id = hdr.seqno;
            if (NAKACK.this.vid == null) {
                return;
            }
            copy.setDest(null);
            NakAckHeader wrapped_hdr = new NakAckHeader(3, hdr.seqno, hdr.vid);
            wrapped_hdr.sender = NAKACK.this.local_addr;
            copy.addHeader(wrapped_hdr);
            this.sender_win.add(id, copy.copy(), (Vector)NAKACK.this.members.clone());
            if (Trace.trace) {
                Trace.info("NAKACK.NAKer.resend()", "resending " + copy.peekHeader());
            }
            NAKACK.this.passDown(new Event(5, copy));
        }

        void waitUntilAllAcksReceived(long timeout) {
            this.sender_win.waitUntilAllAcksReceived(timeout);
        }

        void receive(long id, Message msg, Vector stable_msgs) {
            Message msg_to_deliver;
            Address sender = msg.getSrc();
            NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
            if (win == null) {
                win = new NakReceiverWindow(sender, this, 0L);
                win.setRetransmitTimeouts(NAKACK.this.retransmit_timeout);
                this.received_msgs.put(sender, win);
            }
            if (Trace.trace) {
                Trace.info("NAKACK.NAKer.receive()", "received <" + sender + "#" + id + ">");
            }
            win.add(id, msg);
            while ((msg_to_deliver = win.remove()) != null) {
                if (msg_to_deliver.peekHeader() instanceof NakAckHeader) {
                    msg_to_deliver.removeHeader();
                }
                NAKACK.this.passUp(new Event(5, msg_to_deliver));
            }
        }

        void receiveAck(long id, Address sender) {
            if (Trace.trace) {
                Trace.info("NAKACK.NAKer.receiveAck()", "received ack <-- ACK <" + sender + "#" + id + ">");
            }
            this.sender_win.ack(id, sender);
        }

        public void retransmit(long seqno, Message msg, Address dest) {
            if (Trace.trace) {
                Trace.info("NAKACK.NAKer.retransmit()", "retransmitting message " + seqno + " to " + dest + ", header is " + msg.peekHeader());
            }
            if (NAKACK.this.members != null && !NAKACK.this.members.contains(dest)) {
                if (Trace.trace) {
                    Trace.info("NAKACK.NAKer.retransmit()", "retransmitting " + seqno + ") to " + dest + ": " + dest + " is not a member; discarding retransmission and removing " + dest + " from sender_win");
                }
                this.sender_win.remove(dest);
                return;
            }
            msg.setDest(dest);
            NAKACK.this.passDown(new Event(5, msg));
        }

        public void retransmit(long first_seqno, long last_seqno, Address sender) {
            if (Trace.trace) {
                Trace.info("NAKACK.NAKer.retransmit()", "retransmit([" + first_seqno + ", " + last_seqno + "]) to " + sender + ", vid=" + NAKACK.this.vid);
            }
            NakAckHeader hdr = new NakAckHeader(4, first_seqno, (ViewId)NAKACK.this.vid.clone());
            Message retransmit_msg = new Message(sender, null, null);
            hdr.last_seqno = last_seqno;
            retransmit_msg.addHeader(hdr);
            NAKACK.this.passDown(new Event(5, retransmit_msg));
        }

        void retransmit(Address dest, long first_seqno, long last_seqno) {
            long i = first_seqno;
            while (i <= last_seqno) {
                Message m = (Message)this.sent_msgs.get(new Long(i));
                if (m == null) {
                    Trace.warn("NAKACK.NAKer.retransmit()", "message with seqno=" + i + " not found !");
                } else {
                    Message retr_msg = m.copy();
                    retr_msg.setDest(dest);
                    try {
                        NAKACK.this.passDown(new Event(5, retr_msg));
                    }
                    catch (Exception e) {
                        Trace.debug("NAKACK.NAKer.retransmit()", "exception is " + e);
                    }
                }
                ++i;
            }
        }

        void stop() {
            if (this.sender_win != null) {
                this.sender_win.stop();
            }
        }

        void reset() {
            if (!NAKACK.this.coordinator()) {
                this.sender_win.reset();
            }
            this.sent_msgs.clear();
            Enumeration e = this.received_msgs.elements();
            while (e.hasMoreElements()) {
                NakReceiverWindow win = (NakReceiverWindow)e.nextElement();
                win.reset();
            }
            this.received_msgs.clear();
            this.seqno = 0L;
            this.deleted_up_to = 0L;
        }

        public void suspect(Address mbr) {
            NakReceiverWindow w = (NakReceiverWindow)this.received_msgs.get(mbr);
            if (w != null) {
                w.reset();
                this.received_msgs.remove(mbr);
            }
            this.sender_win.suspect(mbr);
        }

        String dumpContents() {
            StringBuffer ret = new StringBuffer();
            ret.append("\nsent_msgs: " + this.sent_msgs.size());
            ret.append("\nreceived_msgs: ");
            Enumeration e = this.received_msgs.keys();
            while (e.hasMoreElements()) {
                Address key = (Address)e.nextElement();
                NakReceiverWindow w = (NakReceiverWindow)this.received_msgs.get(key);
                ret.append("\n" + w.toString());
            }
            ret.append("\nsender_win: " + this.sender_win.toString());
            return ret.toString();
        }

        private class LastMessageRetransmitter
        implements TimeScheduler.Task {
            boolean stopped = false;
            int num_times = 2;
            long last_xmitted_seqno = 0L;

            private LastMessageRetransmitter() {
            }

            public void stop() {
                this.stopped = true;
            }

            public boolean cancelled() {
                return this.stopped;
            }

            public long nextInterval() {
                return ((NAKer)NAKer.this).NAKACK.this.retransmit_timeout[0];
            }

            public void run() {
                Hashtable hashtable = NAKer.this.sent_msgs;
                synchronized (hashtable) {
                    long prevSeqno = NAKer.this.seqno - 1L;
                    if (prevSeqno == this.last_xmitted_seqno) {
                        if (Trace.trace) {
                            Trace.info("NAKACK.NAKer.run()", "prevSeqno=" + prevSeqno + ", last_xmitted_seqno=" + this.last_xmitted_seqno + ", num_times=" + this.num_times);
                        }
                        if (--this.num_times <= 0) {
                            return;
                        }
                    } else {
                        this.num_times = 3;
                        this.last_xmitted_seqno = prevSeqno;
                    }
                    if (prevSeqno >= 0L && prevSeqno > NAKer.this.deleted_up_to) {
                        if (Trace.trace) {
                            Trace.info("NAKACK.NAKer.run()", "retransmitting last message " + prevSeqno);
                        }
                        NAKer.this.retransmit(null, prevSeqno, prevSeqno);
                    }
                }
            }
        }
    }
}

