/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PartitionerHeader;
import org.javagroups.stack.Protocol;

public class PARTITIONER
extends Protocol {
    Vector members = new Vector();
    Address local_addr = null;
    int my_partition = 1;

    public String getName() {
        return "PARTITIONER";
    }

    public boolean setProperties(Properties props) {
        if (((Hashtable)props).size() > 0) {
            System.err.println("EXAMPLE.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void reset() {
    }

    public void up(Event evt) {
        PartitionerHeader partHead = null;
        switch (evt.getType()) {
            case 1: {
                break;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                if (!Trace.trace) break;
                Trace.info("PARTITIONER.up()", "local address is " + this.local_addr);
                break;
            }
            case 5: {
                Message msg = (Message)evt.getArg();
                partHead = (PartitionerHeader)msg.removeHeader();
                if (partHead.type == 1) {
                    Integer num = (Integer)partHead.Destinations.get(this.local_addr);
                    if (num == null) {
                        return;
                    }
                    if (Trace.trace) {
                        Trace.info("PARTITIONER.up()", "new partition = " + num);
                    }
                    this.my_partition = num;
                    return;
                }
                if (partHead.type != 0 || partHead.partition == this.my_partition) break;
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 3: {
                this.passDown(evt);
                break;
            }
            case 50: {
                if (Trace.trace) {
                    Trace.info("PARTITIONER.down()", "SET_PARTITIONS received, argument " + evt.getArg().toString());
                }
                Message msg = new Message(null, null, null);
                PartitionerHeader partHeader = new PartitionerHeader(1);
                partHeader.Destinations = (Hashtable)evt.getArg();
                msg.addHeader(partHeader);
                this.passDown(new Event(5, msg));
                break;
            }
            case 5: {
                Message msg = (Message)evt.getArg();
                msg.addHeader(new PartitionerHeader(0, this.my_partition));
            }
        }
        this.passDown(evt);
    }
}

