/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PerfHeader;
import org.javagroups.protocols.PerfObserver;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Stack;

public class PERF
extends Protocol {
    boolean details = false;
    Vector members = new Vector();
    Vector protocols = null;

    public String getName() {
        return "PERF";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("details");
        if (str != null) {
            this.details = new Boolean(str);
            ((Hashtable)props).remove("details");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("PERF.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                this.protocols = this.stack != null ? this.stack.getProtocols() : null;
                this.setupObservers();
                break;
            }
            case 5: {
                Message msg = (Message)evt.getArg();
                PerfHeader hdr = this.removePerfHeader(msg);
                if (hdr == null) break;
                hdr.setEndTime();
                hdr.setDone(this.getName(), 1);
                if (!Trace.trace) break;
                Trace.info("PERF.up()", hdr.printContents(this.details, this.protocols) + "\n---------------------------------\n");
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 3: {
                this.passDown(evt);
                break;
            }
            case 10: 
            case 21: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        int i = 0;
                        while (i < new_members.size()) {
                            this.members.addElement(new_members.elementAt(i));
                            ++i;
                        }
                    }
                }
                this.passDown(evt);
                break;
            }
            case 5: {
                Message msg = (Message)evt.getArg();
                this.initializeMessage(msg);
            }
        }
        this.passDown(evt);
    }

    void setupObservers() {
        Protocol p = null;
        Vector prots = this.protocols;
        PerfObserver po = null;
        if (prots == null) {
            System.err.println("PERF.setupObservers(): protocol stack is null");
            return;
        }
        int i = 0;
        while (i < prots.size()) {
            p = (Protocol)prots.elementAt(i);
            String pname = p.getName();
            if (pname != null) {
                po = new PerfObserver(pname);
                po.setProtocol(p);
                p.setObserver(po);
            }
            ++i;
        }
    }

    void initializeMessage(Message msg) {
        PerfHeader hdr = new PerfHeader(msg.getSrc(), msg.getDest());
        String pname = null;
        if (this.protocols == null) {
            System.err.println("PERF.initializeMessage(): 'protocols' variable is null");
            return;
        }
        int i = 0;
        while (i < this.protocols.size()) {
            Protocol p = (Protocol)this.protocols.elementAt(i);
            pname = p.getName();
            if (pname != null) {
                hdr.addEntry(pname);
            }
            ++i;
        }
        hdr.setReceived(this.getName(), 2);
        msg.getHeaders().add(hdr);
    }

    PerfHeader removePerfHeader(Message m) {
        Stack hdrs;
        if (m == null || (hdrs = m.getHeaders()) == null) {
            return null;
        }
        Object hdr = hdrs.bottom();
        if (hdr != null && hdr instanceof PerfHeader) {
            hdrs.remove();
            return (PerfHeader)hdr;
        }
        return null;
    }
}

