/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PingHeader;
import org.javagroups.protocols.PingRsp;
import org.javagroups.stack.GossipClient;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

public class PING
extends Protocol {
    Vector members = new Vector();
    Vector initial_members = new Vector();
    Address local_addr = null;
    String group_addr = null;
    long timeout = 3000L;
    long num_initial_members = 2L;
    String gossip_host = null;
    int gossip_port = 0;
    long gossip_refresh = 20000L;
    GossipClient client;
    boolean is_server = false;

    public String getName() {
        return "PING";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(18));
        return ret;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            if (this.timeout <= 0L) {
                Trace.error("PING.setProperties()", "timeout must be > 0");
            }
            ((Hashtable)props).remove("timeout");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = new Integer(str).intValue();
            ((Hashtable)props).remove("num_initial_members");
        }
        if ((str = props.getProperty("gossip_host")) != null) {
            this.gossip_host = str;
            ((Hashtable)props).remove("gossip_host");
        }
        if ((str = props.getProperty("gossip_port")) != null) {
            this.gossip_port = new Integer(str);
            ((Hashtable)props).remove("gossip_port");
        }
        if ((str = props.getProperty("gossip_refresh")) != null) {
            this.gossip_refresh = new Long(str);
            ((Hashtable)props).remove("gossip_refresh");
        }
        if (this.gossip_host != null && this.gossip_port != 0) {
            try {
                this.client = new GossipClient(new IpAddress(InetAddress.getByName(this.gossip_host), this.gossip_port), this.gossip_refresh);
            }
            catch (Exception e) {
                Trace.error("PING.setProperties()", "creation of GossipClient failed, exception=" + e);
                return false;
            }
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("PING.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.peekHeader();
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader();
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            coord = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord));
                        rsp_msg.addHeader(rsp_hdr);
                        if (Trace.trace) {
                            Trace.info("PING.up()", "received GET_MBRS_REQ, returning " + rsp_hdr);
                        }
                        this.passDown(new Event(5, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            if (Trace.trace) {
                                Trace.info("PING.up()", "received FIND_INITAL_MBRS_RSP, rsp=" + rsp);
                            }
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                        }
                        return;
                    }
                }
                Trace.warn("PING.up()", "got PING header with unknown type (" + hdr.type + ")");
                return;
            }
            case 12: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    public void down(Event evt) {
        Vector gossip_rsps = null;
        switch (evt.getType()) {
            case 18: {
                if (this.client != null) {
                    gossip_rsps = this.client.getMembers(this.group_addr);
                    if (gossip_rsps == null || gossip_rsps.size() <= 0) {
                        this.passUp(new Event(19, null));
                        return;
                    }
                    Event view_event = new Event(21, this.makeView(gossip_rsps));
                    this.passDown(view_event);
                    Util.sleep(500L);
                }
                this.initial_members.removeAllElements();
                if (Trace.trace) {
                    Trace.info("PING.down()", "FIND_INITIAL_MBRS");
                }
                PingHeader hdr = new PingHeader(1, null);
                Message msg = new Message(null, null, null);
                msg.addHeader(hdr);
                this.passDown(new Event(5, msg));
                Vector vector = this.initial_members;
                synchronized (vector) {
                    long start_time = System.currentTimeMillis();
                    long time_to_wait = this.timeout;
                    while ((long)this.initial_members.size() < this.num_initial_members && time_to_wait > 0L) {
                        Trace.info("PING.down()", "waiting for initial members: time_to_wait=" + time_to_wait + ", got " + this.initial_members.size() + " rsps");
                        try {
                            this.initial_members.wait(time_to_wait);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        time_to_wait -= System.currentTimeMillis() - start_time;
                    }
                }
                if (Trace.trace) {
                    Trace.info("PING.down()", "initial mbrs are " + this.initial_members);
                }
                this.passUp(new Event(19, this.initial_members));
                break;
            }
            case 3: {
                this.passDown(evt);
                this.is_server = false;
                break;
            }
            case 10: 
            case 21: {
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector vector = this.members;
                    synchronized (vector) {
                        this.members.removeAllElements();
                        int i = 0;
                        while (i < tmp.size()) {
                            this.members.addElement(tmp.elementAt(i));
                            ++i;
                        }
                    }
                }
                this.passDown(evt);
                break;
            }
            case 22: {
                this.passDown(evt);
                this.is_server = true;
                break;
            }
            case 6: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                if (this.client == null) break;
                this.client.register(this.group_addr, this.local_addr);
                break;
            }
            case 8: {
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    private View makeView(Vector mbrs) {
        Address coord = null;
        long id = 0L;
        ViewId view_id = new ViewId(this.local_addr);
        coord = view_id.getCoordAddress();
        id = view_id.getId();
        return new View(coord, id, mbrs);
    }
}

