/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.protocols.PerfEntry;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

public class PerfHeader
extends Header {
    Object sender = null;
    Object receiver = null;
    long start_time = 0L;
    long end_time = 0L;
    long network_send = 0L;
    long network_recv = 0L;
    long network_time = 0L;
    Hashtable down = new Hashtable();
    Hashtable up = new Hashtable();
    static final int UP = 1;
    static final int DOWN = 2;
    static final String classname = "org.javagroups.protocols.PerfHeader";
    static long size = 0L;

    public PerfHeader() {
    }

    public PerfHeader(Object sender, Object receiver) {
        this.sender = sender;
        this.receiver = receiver;
        this.start_time = System.currentTimeMillis();
    }

    public String toString() {
        return "[PerfHeader]";
    }

    public String printContents(boolean detailed) {
        return this.printContents(detailed, null);
    }

    public String printContents(boolean detailed, Vector prots) {
        PerfEntry val;
        String key;
        Protocol p;
        StringBuffer sb = new StringBuffer();
        if (this.sender != null) {
            sb.append("sender=" + this.sender + "\n");
        }
        if (this.receiver != null) {
            sb.append("receiver=" + this.receiver + "\n");
        }
        if (detailed) {
            sb.append("start_time=" + this.start_time + "\nend_time=" + this.end_time + "\n");
        }
        if (this.end_time >= this.start_time) {
            sb.append("total time=" + (this.end_time - this.start_time) + "\n");
        } else {
            sb.append("total time=n/a\n");
        }
        if (detailed) {
            if (this.network_send > 0L) {
                sb.append("network_send=" + this.network_send + "\n");
            }
            if (this.network_recv > 0L) {
                sb.append("network_recv=" + this.network_recv + "\n");
            }
        }
        if (this.network_time > 0L) {
            sb.append("network=" + this.network_time + "\n");
        }
        sb.append("\nDOWN\n-----\n");
        if (prots != null) {
            int i = 0;
            while (i < prots.size()) {
                p = (Protocol)prots.elementAt(i);
                key = p.getName();
                val = (PerfEntry)this.down.get(key);
                sb.append(key + ":" + "\t" + val.printContents(detailed) + "\n");
                ++i;
            }
        } else {
            Enumeration e = this.down.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                val = (PerfEntry)this.down.get(key);
                sb.append(key + ":" + "\t" + val.printContents(detailed) + "\n");
            }
        }
        sb.append("\nUP\n-----\n");
        if (prots != null) {
            int i = prots.size() - 1;
            while (i >= 0) {
                p = (Protocol)prots.elementAt(i);
                key = p.getName();
                val = (PerfEntry)this.up.get(key);
                sb.append(key + ":" + "\t" + val.printContents(detailed) + "\n");
                --i;
            }
        } else {
            Enumeration e = this.up.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                val = (PerfEntry)this.up.get(key);
                sb.append(key + ":" + "\t" + val.printContents(detailed) + "\n");
            }
        }
        return sb.toString();
    }

    public void setEndTime() {
        this.end_time = System.currentTimeMillis();
    }

    public void setReceived(String prot_name, int type) {
        PerfEntry entry = this.getEntry(prot_name, type);
        long t = System.currentTimeMillis();
        if (entry != null) {
            entry.setReceived(t);
        }
    }

    public void setDone(String prot_name, int type) {
        PerfEntry entry = this.getEntry(prot_name, type);
        long t = System.currentTimeMillis();
        if (entry != null) {
            entry.setDone(t);
        }
    }

    public void setNetworkSent() {
        this.network_send = System.currentTimeMillis();
    }

    public void setNetworkReceived() {
        this.network_recv = System.currentTimeMillis();
        if (this.network_send > 0L && this.network_recv > this.network_send) {
            this.network_time = this.network_recv - this.network_send;
        }
    }

    public void addEntry(String prot_name) {
        if (prot_name == null) {
            return;
        }
        this.up.put(prot_name, new PerfEntry());
        this.down.put(prot_name, new PerfEntry());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sender);
        out.writeObject(this.receiver);
        out.writeLong(this.start_time);
        out.writeLong(this.end_time);
        out.writeLong(this.network_send);
        out.writeLong(this.network_recv);
        out.writeLong(this.network_time);
        this.writeHashtable(this.down, out);
        this.writeHashtable(this.up, out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sender = in.readObject();
        this.receiver = in.readObject();
        this.start_time = in.readLong();
        this.end_time = in.readLong();
        this.network_send = in.readLong();
        this.network_recv = in.readLong();
        this.network_time = in.readLong();
        this.down = this.readHashtable(in);
        this.up = this.readHashtable(in);
    }

    public long size() {
        return size;
    }

    void writeHashtable(Hashtable h, ObjectOutput out) {
        try {
            if (h == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(h.size());
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                PerfEntry val = (PerfEntry)h.get(key);
                if (key == null || val == null) {
                    System.err.println("PerfHeader.writeHashtable(): key or val is null");
                    continue;
                }
                out.writeObject(key);
                out.writeObject(val);
            }
        }
        catch (Exception ex) {
            System.err.println("PerfHeader.writeHashtable(): " + ex);
        }
    }

    Hashtable readHashtable(ObjectInput in) {
        Hashtable<String, PerfEntry> h = new Hashtable<String, PerfEntry>();
        int num = 0;
        try {
            num = in.readInt();
            if (num == 0) {
                return h;
            }
            int i = 0;
            while (i < num) {
                String key = (String)in.readObject();
                PerfEntry val = (PerfEntry)in.readObject();
                h.put(key, val);
                ++i;
            }
        }
        catch (Exception ex) {
            System.err.println("PerfHeader.readHashtable(): " + ex);
        }
        return h;
    }

    PerfEntry getEntry(String prot_name, int type) {
        Hashtable tmp = null;
        PerfEntry entry = null;
        if (prot_name == null) {
            return null;
        }
        if (type == 1) {
            tmp = this.up;
        } else if (type == 2) {
            tmp = this.down;
        }
        if (tmp == null) {
            return null;
        }
        entry = (PerfEntry)tmp.get(prot_name);
        if (entry == null) {
            System.err.println("PerfHeader.getEntry(): protocol \"" + prot_name + "\" not found");
        }
        return entry;
    }

    public static void main(String[] args) {
        PerfHeader hdr = new PerfHeader();
        hdr.addEntry("GMS");
        hdr.addEntry("GMS");
        hdr.addEntry("FRAG");
        hdr.addEntry("FRAG");
        hdr.addEntry("UDP");
        hdr.addEntry("UDP");
        Message msg = new Message();
        msg.getHeaders().add(hdr);
        hdr.setReceived("GMS", 2);
        Util.sleep(2L);
        hdr.setDone("GMS", 2);
        hdr.setReceived("FRAG", 2);
        Util.sleep(20L);
        hdr.setDone("FRAG", 2);
        long len = msg.size();
        System.out.println("Size is " + len);
        hdr.setReceived("UDP", 2);
        Util.sleep(12L);
        hdr.setDone("UDP", 2);
        Util.sleep(30L);
        hdr.setReceived("UDP", 1);
        hdr.setDone("UDP", 1);
        hdr.setReceived("FRAG", 1);
        Util.sleep(23L);
        hdr.setDone("FRAG", 1);
        hdr.setReceived("GMS", 1);
        Util.sleep(3L);
        hdr.setDone("GMS", 1);
        hdr.setEndTime();
        System.out.println(hdr.printContents(true));
        try {
            System.out.println("Saving hdr to byte buffer");
            ByteArrayOutputStream out_stream = new ByteArrayOutputStream(256);
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(msg);
            byte[] out_buf = out_stream.toByteArray();
            System.out.println("Constructing hdr2 from byte buffer");
            byte[] in_buf = out_buf;
            ByteArrayInputStream in_stream = new ByteArrayInputStream(in_buf);
            ObjectInputStream in = new ObjectInputStream(in_stream);
            Message msg2 = (Message)in.readObject();
            PerfHeader hdr2 = (PerfHeader)msg.getHeaders().remove();
            System.out.println(hdr2.printContents(true));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static {
        size = Util.sizeOf(classname);
        if (size <= 0L) {
            size = 400L;
        }
    }
}

