/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.protocols.PerfHeader;
import org.javagroups.stack.Protocol;
import org.javagroups.stack.ProtocolObserver;
import org.javagroups.util.Stack;

class PerfObserver
implements ProtocolObserver {
    String prot_name;
    boolean bottom = false;

    PerfObserver(String prot_name) {
        this.prot_name = prot_name;
    }

    public void setProtocol(Protocol prot) {
        if (prot != null && prot.getDownProtocol() == null) {
            this.bottom = true;
        }
    }

    public boolean up(Event evt, int num_evts) {
        PerfHeader hdr;
        if (evt.getType() == 5 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setReceived(this.prot_name, 1);
            if (this.bottom) {
                hdr.setNetworkReceived();
            }
        }
        return true;
    }

    public boolean passUp(Event evt) {
        PerfHeader hdr;
        if (evt.getType() == 5 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setDone(this.prot_name, 1);
        }
        return true;
    }

    public boolean down(Event evt, int num_evts) {
        PerfHeader hdr;
        if (evt.getType() == 5 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setReceived(this.prot_name, 2);
        }
        return true;
    }

    public boolean passDown(Event evt) {
        PerfHeader hdr;
        if (evt.getType() == 5 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setDone(this.prot_name, 2);
            if (this.bottom) {
                hdr.setNetworkSent();
            }
        }
        return true;
    }

    PerfHeader getPerfHeader(Message m) {
        Stack hdrs;
        if (m == null || (hdrs = m.getHeaders()) == null) {
            return null;
        }
        Object hdr = hdrs.bottom();
        if (hdr != null && hdr instanceof PerfHeader) {
            return (PerfHeader)hdr;
        }
        return null;
    }
}

