/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Event;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

public class QUEUE
extends Protocol {
    Vector up_vec = new Vector();
    Vector dn_vec = new Vector();
    boolean queueing_up = false;
    boolean queueing_dn = false;
    Observer observer = null;

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    public Vector getUpVector() {
        return this.up_vec;
    }

    public Vector getDownVector() {
        return this.dn_vec;
    }

    public boolean getQueueingUp() {
        return this.queueing_up;
    }

    public boolean getQueueingDown() {
        return this.queueing_dn;
    }

    public String getName() {
        return "QUEUE";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(28));
        ret.addElement(new Integer(29));
        return ret;
    }

    public Vector providedDownServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(28));
        ret.addElement(new Integer(29));
        return ret;
    }

    public boolean setProperties(Properties props) {
        if (((Hashtable)props).size() > 0) {
            System.err.println("QUEUE.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 28: {
                if (Trace.trace) {
                    Trace.info("QUEUE.up()", "received START_QUEUEING");
                }
                this.queueing_up = true;
                return;
            }
            case 29: {
                Vector event_list = (Vector)evt.getArg();
                if (event_list != null) {
                    int i = 0;
                    while (i < event_list.size()) {
                        this.passUp((Event)event_list.elementAt(i));
                        ++i;
                    }
                }
                if (Trace.trace) {
                    Trace.info("QUEUE.up()", "replaying up events");
                }
                int i = 0;
                while (i < this.up_vec.size()) {
                    Event e = (Event)this.up_vec.elementAt(i);
                    this.passUp(e);
                    ++i;
                }
                this.up_vec.removeAllElements();
                this.queueing_up = false;
                return;
            }
        }
        if (this.queueing_up) {
            if (Trace.trace) {
                Trace.info("QUEUE.up()", "queued up event " + evt);
            }
            if (this.observer != null && !this.observer.addingToUpVector(evt, this.up_vec.size())) {
                return;
            }
            this.up_vec.addElement(evt);
        } else {
            this.passUp(evt);
        }
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 28: {
                if (Trace.trace) {
                    Trace.info("QUEUE.down()", "received START_QUEUEING");
                }
                this.queueing_dn = true;
                return;
            }
            case 29: {
                Vector event_list;
                if (Trace.trace) {
                    Trace.info("QUEUE.down()", "received STOP_QUEUEING");
                }
                if ((event_list = (Vector)evt.getArg()) != null) {
                    int i = 0;
                    while (i < event_list.size()) {
                        this.passDown((Event)event_list.elementAt(i));
                        ++i;
                    }
                }
                if (Trace.trace) {
                    Trace.info("QUEUE.down()", "replaying down events (" + this.dn_vec.size() + ")");
                }
                int i = 0;
                while (i < this.dn_vec.size()) {
                    this.passDown((Event)this.dn_vec.elementAt(i));
                    ++i;
                }
                this.dn_vec.removeAllElements();
                this.queueing_dn = false;
                return;
            }
        }
        if (this.queueing_dn) {
            if (Trace.trace) {
                Trace.info("QUEUE.down()", "queued down event: " + Util.printEvent(evt));
            }
            if (this.observer != null && !this.observer.addingToDownVector(evt, this.dn_vec.size())) {
                return;
            }
            this.dn_vec.addElement(evt);
        } else {
            this.passDown(evt);
        }
    }

    public static interface Observer {
        public boolean addingToUpVector(Event var1, int var2);

        public boolean addingToDownVector(Event var1, int var2);
    }
}

