/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;

public class SIZE
extends Protocol {
    Vector members = new Vector();
    boolean print_msg = false;
    ByteArrayOutputStream out_stream = new ByteArrayOutputStream(65535);

    public String getName() {
        return "SIZE";
    }

    public void init() {
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("print_msg");
        if (str != null) {
            this.print_msg = new Boolean(str);
            ((Hashtable)props).remove("print_msg");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("SIZE.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        int payload_size = 0;
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                if (!Trace.trace) break;
                byte[] buf = msg.getBuffer();
                if (buf != null) {
                    payload_size = buf.length;
                }
                Trace.info("SIZE.up()", "size of message is " + this.sizeOf(msg) + ", " + msg.getHeaders().size() + " headers");
                if (!this.print_msg) break;
                Trace.info("SIZE.up()", "headers are " + msg.getHeaders() + ", payload size=" + payload_size);
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        int payload_size = 0;
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                if (!Trace.trace) break;
                byte[] buf = msg.getBuffer();
                if (buf != null) {
                    payload_size = buf.length;
                }
                Trace.info("SIZE.down()", "size of message is " + this.sizeOf(msg) + ", " + msg.getHeaders().size() + " headers");
                if (!this.print_msg) break;
                Trace.info("SIZE.up()", "headers are " + msg.getHeaders() + ", payload size=" + payload_size);
            }
        }
        this.passDown(evt);
    }

    int sizeOf(Message msg) {
        ByteArrayOutputStream byteArrayOutputStream = this.out_stream;
        synchronized (byteArrayOutputStream) {
            try {
                this.out_stream.reset();
                ObjectOutputStream out = new ObjectOutputStream(this.out_stream);
                msg.writeExternal(out);
                out.flush();
                int n = this.out_stream.size();
                return n;
            }
            catch (Exception e) {
                int n = 0;
                return n;
            }
        }
    }
}

