/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.blocks.MethodCall;
import org.javagroups.log.Trace;
import org.javagroups.stack.RpcProtocol;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

public class STABLE
extends RpcProtocol {
    private static final String PROT_NAME = "STABLE";
    private static final double SUBSET_SIZE = 0.1;
    private static final int GOSSIP_MSG_INTERVAL = 100;
    private static final int GOSSIP_INTERVAL = 10000;
    private Address local_addr = null;
    private ViewId vid = null;
    private Vector mbrs = new Vector();
    private long round = 1L;
    private long[] seqnos = new long[0];
    private boolean[] heard_from = new boolean[0];
    private double subset = 0.1;
    private TimeScheduler sched = null;
    private Task gossip_task;
    private int max_msgs = 100;
    private long max_wait_time = 10000L;
    private long num_msgs = this.max_msgs;
    private Object highest_seqnos_mutex = new Object();
    private long highest_seqnos_timeout = 4000L;

    public String getName() {
        return PROT_NAME;
    }

    public Vector requiredUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(41));
        return retval;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("subset");
        if (str != null) {
            this.subset = new Float(str).floatValue();
            ((Hashtable)props).remove("subset");
        }
        if ((str = props.getProperty("max_msgs")) != null) {
            this.max_msgs = new Integer(str);
            this.num_msgs = this.max_msgs;
            if (this.max_msgs <= 1) {
                Trace.fatal("STABLE.setProperties()", "value for 'max_msgs' must be greater than 1 !");
                return false;
            }
            ((Hashtable)props).remove("max_msgs");
        }
        if ((str = props.getProperty("max_wait_time")) != null) {
            this.max_wait_time = new Long(str);
            ((Hashtable)props).remove("max_wait_time");
        }
        if ((str = props.getProperty("highest_seqnos_timeout")) != null) {
            this.highest_seqnos_timeout = new Long(str);
            ((Hashtable)props).remove("highest_seqnos_timeout");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("STABLE.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void gossip(ViewId view_id, long gossip_round, long[] gossip_seqnos, boolean[] heard, Object sender) {
        Object[] params;
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (Trace.trace) {
                Trace.info("STABLE.gossip()", "sender=" + sender + ", round=" + gossip_round + ", seqnos=" + Util.array2String(gossip_seqnos) + ", heard=" + Util.array2String(heard));
            }
            if (this.vid == null || view_id == null || !this.vid.equals(view_id)) {
                if (Trace.trace) {
                    Trace.info("STABLE.gossip()", "view ID s are different (" + this.vid + " != " + view_id + "). Discarding gossip received");
                }
                return;
            }
            if (gossip_round < this.round) {
                if (Trace.trace) {
                    Trace.info("STABLE.gossip()", "received a gossip from a previous round (" + gossip_round + "); my round is " + this.round + ". Discarding gossip");
                }
                return;
            }
            if (gossip_seqnos == null || this.seqnos == null || this.seqnos.length != gossip_seqnos.length) {
                if (Trace.trace) {
                    Trace.warn("STABLE.gossip()", "size of seqnos and gossip_seqnos are not equal ! Discarding gossip");
                }
                return;
            }
            if (this.round == gossip_round) {
                this.update(sender, gossip_seqnos, heard);
            } else if (this.round < gossip_round) {
                if (Trace.trace) {
                    Trace.info("STABLE.gossip()", "received a gossip from a higher round (" + gossip_round + "); adopting my round (" + this.round + ") to " + gossip_round);
                }
                this.round = gossip_round;
                this.set(sender, gossip_seqnos, this.heard_from);
            }
            if (Trace.trace) {
                Trace.info("STABLE.gossip()", "heard_from=" + Util.array2String(this.heard_from));
            }
            if (!this.heardFromAll()) {
                return;
            }
            params = new Object[]{this.vid.clone(), new Long(gossip_round), this.seqnos.clone(), this.local_addr};
        }
        MethodCall call = new MethodCall("stability", params);
        this.callRemoteMethods(null, call, 6, 0L);
    }

    public void stability(ViewId view_id, long gossip_round, long[] stability_vector, Object sender) {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (Trace.trace) {
                Trace.info("STABLE.stability()", "sender=" + sender + ", round=" + gossip_round + ", vector=" + Util.array2String(stability_vector) + ")");
            }
            if (this.vid == null || view_id == null || !this.vid.equals(view_id)) {
                if (Trace.trace) {
                    Trace.info("STABLE.stability()", "view ID s are different (" + this.vid + " != " + view_id + "). Discarding gossip received");
                }
                return;
            }
            if (this.round > gossip_round) {
                return;
            }
            this.round = gossip_round + 1L;
            int i = 0;
            while (i < this.heard_from.length) {
                this.heard_from[i] = false;
                ++i;
            }
        }
        this.heard_from[this.mbrs.indexOf((Object)this.local_addr)] = true;
        this.passUp(new Event(36, stability_vector));
        this.getHighestSeqnos();
    }

    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 5: {
                if (this.upMsg(evt)) break;
                return false;
            }
            case 1: {
                if (this.upStart(evt)) break;
                return false;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 10: {
                if (this.downViewChange(evt)) break;
                return false;
            }
            case 3: {
                this.stopGossip();
                break;
            }
            case 42: {
                if (this.downGetMsgsReceived(evt)) break;
                return false;
            }
        }
        return true;
    }

    private void gossipRun() {
        this.num_msgs = this.max_msgs;
        this.sendGossip();
    }

    private void initialize() {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            this.seqnos = new long[this.mbrs.size()];
            int i = 0;
            while (i < this.seqnos.length) {
                this.seqnos[i] = -1L;
                ++i;
            }
            this.heard_from = new boolean[this.mbrs.size()];
            int i2 = 0;
            while (i2 < this.heard_from.length) {
                this.heard_from[i2] = false;
                ++i2;
            }
        }
    }

    private void update(Object sender, long[] gossip_seqnos, boolean[] gossip_heard_from) {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            int index = this.mbrs.indexOf(sender);
            if (index < 0) {
                if (Trace.trace) {
                    Trace.warn("STABLE.update()", "sender " + sender + " not found in mbrs !");
                }
                return;
            }
            int i = 0;
            while (i < gossip_seqnos.length) {
                this.seqnos[i] = Math.min(this.seqnos[i], gossip_seqnos[i]);
                ++i;
            }
            this.heard_from[index] = true;
            int i2 = 0;
            while (i2 < this.heard_from.length) {
                this.heard_from[i2] = this.heard_from[i2] | gossip_heard_from[i2];
                ++i2;
            }
        }
    }

    private void set(Object sender, long[] gossip_seqnos, boolean[] gossip_heard_from) {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            int index = this.mbrs.indexOf(sender);
            if (index < 0) {
                if (Trace.trace) {
                    Trace.warn("STABLE.set()", "sender " + sender + " not found in mbrs !");
                }
                return;
            }
            this.seqnos = gossip_seqnos;
            this.heard_from = gossip_heard_from;
        }
    }

    private boolean heardFromAll() {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (this.heard_from == null) {
                boolean bl = false;
                return bl;
            }
            int i = 0;
            while (i < this.heard_from.length) {
                if (!this.heard_from[i]) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
        }
        return true;
    }

    private void sendGossip() {
        Object[] params;
        Vector gossip_subset;
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            gossip_subset = Util.pickSubset(this.mbrs, this.subset);
            if (gossip_subset == null || gossip_subset.size() < 1) {
                if (Trace.trace) {
                    Trace.warn("STABLE.sendGossip()", "picked empty subset !");
                }
                return;
            }
            if (Trace.trace) {
                Trace.info("STABLE.sendGossip()", "subset=" + gossip_subset + ", round=" + this.round + ", seqnos=" + Util.array2String(this.seqnos));
            }
            params = new Object[]{this.vid.clone(), new Long(this.round), this.seqnos.clone(), this.heard_from.clone(), this.local_addr};
        }
        MethodCall call = new MethodCall("gossip", params);
        int i = 0;
        while (i < gossip_subset.size()) {
            block9: {
                try {
                    this.callRemoteMethod((Address)gossip_subset.get(i), call, 6, 0L);
                }
                catch (Exception e) {
                    if (!Trace.trace) break block9;
                    Trace.debug("STABLE.sendGossip()", "exception=" + e);
                }
            }
            ++i;
        }
    }

    private void getHighestSeqnos() {
        Object object = this.highest_seqnos_mutex;
        synchronized (object) {
            block5: {
                this.passUp(new Event(41));
                try {
                    this.highest_seqnos_mutex.wait(this.highest_seqnos_timeout);
                }
                catch (InterruptedException e) {
                    if (!Trace.trace) break block5;
                    Trace.error("STABLE.getHighestSeqnos()", "Interrupted while waiting for highest seqnos from NAKACK");
                }
            }
        }
    }

    private void startGossip() {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (this.gossip_task != null) {
                this.gossip_task.cancel();
            }
            this.gossip_task = new Task(new Times(new long[]{10000L}));
            this.sched.add(this.gossip_task);
        }
    }

    private void stopGossip() {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            this.gossip_task.cancel();
            this.gossip_task = null;
        }
    }

    private boolean upMsg(Event e) {
        Message msg = (Message)e.getArg();
        if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) {
            return true;
        }
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            --this.num_msgs;
            if (this.num_msgs > 0L) {
                boolean bl = true;
                return bl;
            }
            this.num_msgs = this.max_msgs;
            this.gossip_task.cancel();
            this.gossip_task = new Task(new Times(new long[]{0L, 10000L}));
            this.sched.add(this.gossip_task);
        }
        return true;
    }

    private boolean upStart(Event e) {
        TimeScheduler timer;
        TimeScheduler timeScheduler = timer = this.stack != null ? this.stack.timer : null;
        if (timer == null) {
            if (Trace.trace) {
                Trace.fatal("STABLE.handleUpEvent()", "[START] timer is null");
            }
            return true;
        }
        this.sched = timer;
        if (this._corr != null) {
            this._corr.setDeadlockDetection(false);
        }
        this.initialize();
        this.startGossip();
        return true;
    }

    private boolean downViewChange(Event e) {
        View v = (View)e.getArg();
        Vector new_mbrs = v.getMembers();
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            this.vid = v.getVid();
            this.mbrs.clear();
            this.mbrs.addAll(new_mbrs);
            this.initialize();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downGetMsgsReceived(Event e) {
        block16: {
            boolean bl;
            block15: {
                Object object;
                boolean bl2;
                block14: {
                    long[] new_seqnos = (long[])e.getArg();
                    boolean recv = true;
                    try {
                        STABLE sTABLE = this;
                        synchronized (sTABLE) {
                            if (new_seqnos == null) {
                                bl2 = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 13] lbl8 : MonitorExitStatement: MONITOREXIT : var4_4
                                Object var9_6 = null;
                                object = this.highest_seqnos_mutex;
                                break block14;
                            }
                            if (new_seqnos.length != this.seqnos.length) {
                                if (Trace.trace) {
                                    Trace.info("STABLE.handleDownEvent()", "GET_MSGS_RECEIVED: array of highest seqnos seen so far (received from NAKACK layer) has a different length (" + new_seqnos.length + ") from 'seqnos' array (" + this.seqnos.length + ")");
                                }
                                bl = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 12] lbl17 : MonitorExitStatement: MONITOREXIT : var4_4
                                break block15;
                            }
                            int i = 0;
                            while (true) {
                                if (i >= this.seqnos.length) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 3, 9, 11] lbl23 : MonitorExitStatement: MONITOREXIT : var4_4
                                    break block16;
                                }
                                this.seqnos[i] = new_seqnos[i];
                                ++i;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        Object object2 = this.highest_seqnos_mutex;
                        synchronized (object2) {
                            this.highest_seqnos_mutex.notify();
                            throw throwable;
                        }
                    }
                }
                synchronized (object) {
                    this.highest_seqnos_mutex.notify();
                    return bl2;
                }
            }
            Object var9_7 = null;
            Object object = this.highest_seqnos_mutex;
            synchronized (object) {
                this.highest_seqnos_mutex.notify();
                return bl;
            }
        }
        Object var9_8 = null;
        Object object = this.highest_seqnos_mutex;
        synchronized (object) {
            this.highest_seqnos_mutex.notify();
            return true;
        }
    }

    private class Task
    implements TimeScheduler.Task {
        private Times intervals;
        private boolean cancelled = false;

        public Task(Times intervals) {
            this.intervals = intervals;
        }

        public long nextInterval() {
            return this.intervals.next();
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run() {
            STABLE.this.gossipRun();
        }
    }

    private static class Times {
        private int next = 0;
        private long[] times;

        public Times(long[] times) {
            if (times.length == 0) {
                throw new IllegalArgumentException("times");
            }
            this.times = times;
        }

        public synchronized long next() {
            if (this.next >= this.times.length) {
                return this.times[this.times.length - 1];
            }
            return this.times[this.next++];
        }

        public long[] times() {
            return this.times;
        }

        public synchronized void reset() {
            this.next = 0;
        }
    }
}

