/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.blocks.GroupRequest;
import org.javagroups.blocks.RequestCorrelator;
import org.javagroups.blocks.RequestHandler;
import org.javagroups.log.Trace;
import org.javagroups.protocols.StateTransferRequest;
import org.javagroups.stack.Protocol;
import org.javagroups.stack.StateTransferInfo;
import org.javagroups.util.Rsp;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;

public class STATE_TRANSFER
extends Protocol
implements RequestHandler {
    Address local_addr = null;
    Vector members = new Vector();
    Message m = null;
    boolean is_server = false;
    Object cached_state = null;
    Object state_xfer_mutex = new Object();
    long timeout_get_appl_state = 5000L;
    long timeout_return_state = 5000L;
    RequestCorrelator corr = null;
    Vector observers = new Vector();

    public String getName() {
        return "STATE_TRANSFER";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout_get_appl_state");
        if (str != null) {
            this.timeout_get_appl_state = new Long(str);
            ((Hashtable)props).remove("timeout_get_appl_state");
        }
        if ((str = props.getProperty("timeout_return_state")) != null) {
            this.timeout_return_state = new Long(str);
            ((Hashtable)props).remove("timeout_return_state");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("STATE_TRANSFER.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public Vector requiredUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(28));
        ret.addElement(new Integer(29));
        return ret;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                this.corr = new RequestCorrelator(this.getName(), this, this);
                break;
            }
            case 22: {
                this.is_server = true;
                break;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 10: 
            case 21: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        int k = 0;
                        while (k < new_members.size()) {
                            this.members.addElement(new_members.elementAt(k));
                            ++k;
                        }
                    }
                    break;
                }
            }
        }
        if (this.corr != null) {
            this.corr.receive(evt);
        } else {
            this.passUp(evt);
        }
    }

    public void down(Event evt) {
        Vector<Event> event_list = null;
        switch (evt.getType()) {
            case 3: {
                if (this.corr == null) break;
                this.corr.stop();
                this.corr = null;
                break;
            }
            case 10: 
            case 21: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        int k = 0;
                        while (k < new_members.size()) {
                            this.members.addElement(new_members.elementAt(k));
                            ++k;
                        }
                    }
                    break;
                }
            }
            case 25: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                Address coord = this.determineCoordinator();
                if (coord == null || coord.equals(this.local_addr)) {
                    Trace.warn("STATE_TRANSFER.down()", "GET_STATE: coordinator is null");
                    event_list = new Vector<Event>();
                    event_list.addElement(new Event(26, null));
                    this.passUp(new Event(29, event_list));
                    return;
                }
                this.sendMakeCopyMessage();
                Object state = info.type == 2 ? this.getStateFromMany(info.targets) : this.getStateFromSingle(info.target);
                event_list = new Vector();
                event_list.addElement(new Event(26, state));
                this.passUp(new Event(29, event_list));
                return;
            }
            case 24: {
                Object object = this.state_xfer_mutex;
                synchronized (object) {
                    this.cached_state = evt.getArg();
                    this.state_xfer_mutex.notify();
                }
                return;
            }
        }
        this.passDown(evt);
    }

    public Object handle(Message msg) {
        try {
            StateTransferRequest req = (StateTransferRequest)Util.objectFromByteBuffer(msg.getBuffer());
            switch (req.getType()) {
                case 1: {
                    this.makeCopy(req.getArg());
                    return null;
                }
                case 2: {
                    if (this.is_server) {
                        return this.cached_state;
                    }
                    Trace.warn("STATE_TRANSFER.handle()", "RETURN_STATE: returning nullas I'm not yet an operational state server !");
                    return null;
                }
            }
            Trace.error("STATE_TRANSFER.handle()", "type " + req.getType() + "is unknown in StateTransferRequest !");
            return null;
        }
        catch (Exception e) {
            Trace.error("STATE_TRANSFER.handle()", "exception is " + e);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    Object getStateFromSingle(Address target) {
        dests = new Vector<Address>();
        r = new StateTransferRequest(2, this.local_addr);
        num_tries = 0;
        try {
            msg = new Message(null, null, Util.objectToByteBuffer(r));
            if (true) ** GOTO lbl29
        }
        catch (Exception e) {
            Trace.error("STATE_TRANSFER.getStateFromSingle()", "exception=" + e);
            return null;
        }
        do {
            v0 = dest = target != null ? target : this.determineCoordinator();
            if (dest == null) {
                return null;
            }
            msg.setDest(dest);
            dests.removeAllElements();
            dests.addElement(dest);
            req = new GroupRequest(msg, this.corr, dests, 1, this.timeout_return_state, 0);
            req.execute();
            rsp_list = req.getResults();
            i = 0;
            while (i < rsp_list.size()) {
                rsp = (Rsp)rsp_list.elementAt(i);
                if (rsp.wasReceived()) {
                    return rsp.getValue();
                }
                ++i;
            }
            Util.sleep(1000L);
lbl29:
            // 2 sources

        } while (this.members.size() > 1 && num_tries++ < 3);
        return null;
    }

    Vector getStateFromMany(Vector targets) {
        Vector dests = new Vector();
        StateTransferRequest r = new StateTransferRequest(2, this.local_addr);
        Vector retval = new Vector();
        if (targets != null) {
            int i = 0;
            while (i < targets.size()) {
                if (!this.local_addr.equals(targets.elementAt(i))) {
                    dests.addElement(targets.elementAt(i));
                } else {
                    i = 0;
                    while (i < this.members.size()) {
                        if (!this.local_addr.equals(this.members.elementAt(i))) {
                            dests.addElement(this.members.elementAt(i));
                        }
                        ++i;
                    }
                }
                ++i;
            }
        }
        if (dests.size() == 0) {
            return null;
        }
        Message msg = new Message();
        try {
            msg.setBuffer(Util.objectToByteBuffer(r));
        }
        catch (Exception e) {
            // empty catch block
        }
        GroupRequest req = new GroupRequest(msg, this.corr, dests, 2, this.timeout_return_state, 0);
        req.execute();
        RspList rsp_list = req.getResults();
        return rsp_list.getResults();
    }

    void sendMakeCopyMessage() {
        Message msg = new Message();
        StateTransferRequest r = new StateTransferRequest(1, this.local_addr);
        Vector dests = new Vector();
        int i = 0;
        while (i < this.members.size()) {
            if (!this.local_addr.equals(this.members.elementAt(i))) {
                dests.addElement(this.members.elementAt(i));
            }
            ++i;
        }
        if (dests.size() == 0) {
            return;
        }
        try {
            msg.setBuffer(Util.objectToByteBuffer(r));
        }
        catch (Exception e) {
            // empty catch block
        }
        GroupRequest req = new GroupRequest(msg, this.corr, dests, 2, this.timeout_return_state, 0);
        req.execute();
    }

    Address determineCoordinator() {
        Address ret = null;
        if (this.members != null && this.members.size() > 1) {
            int i = 0;
            while (i < this.members.size()) {
                if (!this.local_addr.equals(this.members.elementAt(i))) {
                    return (Address)this.members.elementAt(i);
                }
                ++i;
            }
        }
        return ret;
    }

    void makeCopy(Object sender) {
        if (sender.equals(this.local_addr)) {
            this.passUp(new Event(28));
        } else if (this.is_server) {
            Object object = this.state_xfer_mutex;
            synchronized (object) {
                this.cached_state = null;
                this.passUp(new Event(23, this.local_addr));
                try {
                    this.state_xfer_mutex.wait(this.timeout_get_appl_state);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

