/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Vector;
import org.javagroups.Message;

class SavedMessages {
    private Vector messages = new Vector();

    public void insertMessage(Message msg, long seq) {
        Vector vector = this.messages;
        synchronized (vector) {
            int size = this.messages.size();
            int index = 0;
            long this_seq = -1L;
            try {
                while (index < size && (this_seq = ((Entry)this.messages.elementAt(index)).getSeq()) < seq) {
                    ++index;
                }
            }
            catch (ClassCastException e) {
                System.err.println("Error: (TOTAL_OLD) SavedMessages.insertMessage() - ClassCastException: could not cast element of \"messages\" to an Entry (index " + index + ")");
                return;
            }
            if (this_seq == seq) {
                System.err.println("SavedMessages.insertMessage() - sequence " + seq + " already exists in saved messages. Message NOT saved.");
                return;
            }
            this.messages.insertElementAt(new Entry(msg, seq), index);
        }
    }

    private Message getMessage(long seq, boolean delete_msg) {
        Vector vector = this.messages;
        synchronized (vector) {
            int size = this.messages.size();
            int index = 0;
            long this_seq = -1L;
            try {
                while (index < size && (this_seq = ((Entry)this.messages.elementAt(index)).getSeq()) < seq) {
                    ++index;
                }
            }
            catch (ClassCastException e) {
                System.err.println("Error: (TOTAL_OLD) SavedMessages.getMessage() - ClassCastException: could not cast element of \"messages\" to an Entry (index " + index + ")");
                Message message = null;
                return message;
            }
            if (this_seq == seq) {
                Object temp_obj = this.messages.elementAt(index);
                if (temp_obj instanceof Entry) {
                    Message ret_val = ((Entry)temp_obj).getMsg().copy();
                    if (delete_msg) {
                        this.messages.removeElementAt(index);
                    }
                    Message message = ret_val;
                    return message;
                }
                System.err.println("Error: (TOTAL_OLD) SavedMessages.getMessage() - could not cast element of \"messages\" to an Entry (index " + index + ")");
                Message message = null;
                return message;
            }
            Message message = null;
            return message;
        }
    }

    public Message getMessage(long seq) {
        return this.getMessage(seq, true);
    }

    public Message peekMessage(long seq) {
        return this.getMessage(seq, false);
    }

    private Message getFirstMessage(boolean delete_msg) {
        Vector vector = this.messages;
        synchronized (vector) {
            if (this.isEmpty()) {
                Message message = null;
                return message;
            }
            Object temp_obj = this.messages.firstElement();
            if (temp_obj instanceof Entry) {
                Message ret_val = ((Entry)temp_obj).getMsg().copy();
                this.messages.removeElementAt(0);
                Message message = ret_val;
                return message;
            }
            System.err.println("Error: (TOTAL_OLD) SavedMessages.getFirstMessage() - could not cast element of \"messages\" to an Entry");
            Message message = null;
            return message;
        }
    }

    public synchronized Message getFirstMessage() {
        return this.getFirstMessage(true);
    }

    public Message peekFirstMessage() {
        return this.getFirstMessage(false);
    }

    public long getFirstSeq() {
        Vector vector = this.messages;
        synchronized (vector) {
            if (this.isEmpty()) {
                long l = -1L;
                return l;
            }
            Object temp_obj = this.messages.firstElement();
            if (temp_obj instanceof Entry) {
                long l = ((Entry)temp_obj).getSeq();
                return l;
            }
            System.err.println("Error: (TOTAL_OLD) SavedMessages.getFirstSeq() - could not cast element of \"messages\" to an Entry ");
            long l = -1L;
            return l;
        }
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public int getSize() {
        return this.messages.size();
    }

    public void clearMessages() {
        Vector vector = this.messages;
        synchronized (vector) {
            this.messages.removeAllElements();
        }
    }

    class Entry {
        private Message msg;
        private long seq;

        public Entry(Message msg, long seq) {
            this.msg = msg;
            this.seq = seq;
        }

        public Message getMsg() {
            return this.msg;
        }

        public long getSeq() {
            return this.seq;
        }
    }
}

