/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.blocks.ConnectionTable;
import org.javagroups.log.Trace;
import org.javagroups.protocols.TcpHeader;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;

public class TCP
extends Protocol
implements ConnectionTable.Receiver,
ConnectionTable.ConnectionListener {
    private ConnectionTable ct = null;
    private Address local_addr = null;
    private String group_addr = null;
    private InetAddress bind_addr = null;
    private int start_port = 7800;
    private Properties properties = null;
    private Vector members = new Vector();

    public String toString() {
        return "Protocol TCP(local address: " + this.local_addr + ")";
    }

    public String getName() {
        return "TCP";
    }

    public void startUpHandler() {
    }

    public void up(Event evt) {
        if (evt.getType() == 1) {
            this.passUp(evt);
            this.startWork();
            this.passUp(new Event(12, this.local_addr));
            this.passUp(new Event(2));
            return;
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        if (evt.getType() != 5) {
            this.handleDownEvent(evt);
            return;
        }
        Message msg = (Message)evt.getArg();
        msg.addHeader(new TcpHeader(this.group_addr));
        Address dest_addr = msg.getDest();
        if (this.observer != null) {
            this.observer.passDown(evt);
        }
        if (dest_addr == null) {
            if (this.group_addr == null) {
                Trace.warn("TCP.down()", "dest address of message is null, and sending to default address fails as group_addr is null, too ! Discarding message.");
                return;
            }
            this.sendMulticastMessage(msg);
        } else {
            this.sendUnicastMessage(msg);
        }
    }

    public void startWork() {
        try {
            this.ct = new ConnectionTable(this, this.bind_addr, this.start_port);
            this.ct.addConnectionListener(this);
            this.local_addr = this.ct.getLocalAddress();
        }
        catch (Exception e) {
            Trace.debug("TCP.startWork()", "exception is " + e);
            return;
        }
    }

    private synchronized void stopWork() {
        this.ct.stop();
    }

    public void receive(Message msg) {
        Object tmp_addr = null;
        TcpHeader hdr = null;
        Event evt = new Event(5, msg);
        if (this.observer != null) {
            this.observer.up(evt, this.up_queue.size());
        }
        if (Trace.trace) {
            Trace.info("TCP.receive()", "received msg " + msg);
        }
        hdr = (TcpHeader)msg.removeHeader();
        String ch_name = null;
        if (hdr.group_addr != null) {
            ch_name = hdr.group_addr;
        }
        if (this.group_addr == null) {
            if (Trace.trace) {
                Trace.warn("TCP.receive()", "group address in header was null, discarded");
            }
            return;
        }
        if (ch_name != null && !this.group_addr.equals(ch_name)) {
            if (Trace.trace) {
                Trace.warn("TCP.receive()", "discarded message from different group (" + ch_name + "). Sender was " + msg.getSrc());
            }
            return;
        }
        this.passUp(evt);
    }

    public void connectionOpened(Address peer_addr) {
        if (Trace.trace) {
            Trace.info("TCP.connectionOpened()", "opened connection to " + peer_addr);
        }
    }

    public void connectionClosed(Address peer_addr) {
        if (peer_addr != null) {
            if (Trace.trace) {
                Trace.info("TCP.connectionClosed()", "closed connection to " + peer_addr);
            }
            this.passUp(new Event(15, peer_addr));
        }
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("start_port");
        if (str != null) {
            this.start_port = new Integer(str);
            ((Hashtable)props).remove("start_port");
        }
        if ((str = props.getProperty("bind_addr")) != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                Trace.fatal("TCP.setProperties()", "(bind_addr): host " + str + " not known");
                return false;
            }
            ((Hashtable)props).remove("bind_addr");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("TCP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    private void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    private void sendUnicastMessage(Message msg) {
        IpAddress dest = (IpAddress)msg.getDest();
        if (!(dest instanceof IpAddress)) {
            Trace.error("TCP.sendUnicastMessage()", "destination address is not of type IpAddress !");
            return;
        }
        this.setSourceAddress(msg);
        if (this.local_addr != null && dest != null && dest.equals(this.local_addr)) {
            Message copy = msg.copy();
            Header hdr = copy.peekHeader();
            if (hdr != null && hdr instanceof TcpHeader) {
                copy.removeHeader();
            }
            copy.setSrc(this.local_addr);
            copy.setDest(this.local_addr);
            Event evt = new Event(5, copy);
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            this.passUp(evt);
            return;
        }
        this.ct.send(msg);
    }

    private void sendMulticastMessage(Message msg) {
        Vector mbrs = (Vector)this.members.clone();
        int i = 0;
        while (i < mbrs.size()) {
            Address dest = (Address)mbrs.elementAt(i);
            msg.setDest(dest);
            this.sendUnicastMessage(msg);
            ++i;
        }
    }

    private void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 10: 
            case 21: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    int i = 0;
                    while (i < tmpvec.size()) {
                        this.members.addElement(tmpvec.elementAt(i));
                        ++i;
                    }
                }
                if (this.ct == null) break;
                this.ct.setMembers(this.members);
                this.ct.adjustOutgoingConnections((Vector)this.members.clone());
                break;
            }
            case 11: {
                this.passUp(new Event(12, this.local_addr));
                break;
            }
            case 13: {
                this.passUp(new Event(14));
                break;
            }
            case 3: {
                this.stopWork();
                this.passUp(new Event(4));
                break;
            }
            case 6: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(7));
                break;
            }
            case 8: {
                this.passUp(new Event(9));
            }
        }
    }
}

