/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PingHeader;
import org.javagroups.protocols.PingRsp;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.List;

public class TCPPING
extends Protocol {
    Vector members = new Vector();
    Vector initial_members = new Vector();
    Address local_addr = null;
    String group_addr = null;
    String groupname = null;
    long timeout = 3000L;
    long num_initial_members = 2L;
    int port_range = 5;
    List initial_hosts = null;
    boolean is_server = false;

    public String getName() {
        return "TCPPING";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(18));
        return ret;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            ((Hashtable)props).remove("timeout");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = new Integer(str);
            ((Hashtable)props).remove("port_range");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = new Integer(str).intValue();
            ((Hashtable)props).remove("num_initial_members");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            ((Hashtable)props).remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("TCPPING.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.peekHeader();
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader();
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            coord = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord));
                        rsp_msg.addHeader(rsp_hdr);
                        this.passDown(new Event(5, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                        }
                        return;
                    }
                }
                Trace.warn("TCPPING.up()", "got TCPPING header with unknown type (" + hdr.type + ")");
                return;
            }
            case 12: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    public void down(Event evt) {
        Object gossip_rsps = null;
        switch (evt.getType()) {
            case 18: {
                this.initial_members.removeAllElements();
                PingHeader hdr = new PingHeader(1, null);
                Message msg = new Message(null, null, null);
                msg.addHeader(hdr);
                Enumeration en = this.initial_hosts.elements();
                while (en.hasMoreElements()) {
                    HostInfo h = (HostInfo)en.nextElement();
                    int i = h.port;
                    while (i < h.port + this.port_range) {
                        msg.setDest(new IpAddress(h.host, i));
                        if (Trace.trace) {
                            Trace.info("TCPPING.down()", "[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest());
                        }
                        this.passDown(new Event(5, msg.copy()));
                        ++i;
                    }
                }
                Vector vector = this.initial_members;
                synchronized (vector) {
                    long start_time = System.currentTimeMillis();
                    long time_to_wait = this.timeout;
                    while ((long)this.initial_members.size() < this.num_initial_members && time_to_wait > 0L) {
                        try {
                            this.initial_members.wait(time_to_wait);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        time_to_wait -= System.currentTimeMillis() - start_time;
                    }
                }
                if (Trace.trace) {
                    Trace.info("TCPPING.down()", "[FIND_INITIAL_MBRS] initial members are " + this.initial_members);
                }
                this.passUp(new Event(19, this.initial_members));
                break;
            }
            case 3: {
                this.passDown(evt);
                break;
            }
            case 10: 
            case 21: {
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector vector = this.members;
                    synchronized (vector) {
                        this.members.removeAllElements();
                        int i = 0;
                        while (i < tmp.size()) {
                            this.members.addElement(tmp.elementAt(i));
                            ++i;
                        }
                    }
                }
                this.passDown(evt);
                break;
            }
            case 22: {
                this.passDown(evt);
                this.is_server = true;
                break;
            }
            case 6: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                break;
            }
            case 8: {
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    private View makeView(Vector mbrs) {
        Address coord = null;
        long id = 0L;
        ViewId view_id = new ViewId(this.local_addr);
        coord = view_id.getCoordAddress();
        id = view_id.getId();
        return new View(coord, id, mbrs);
    }

    private List createInitialHosts(String l) {
        List tmp = new List();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                HostInfo h = new HostInfo();
                h.host = t.substring(0, t.indexOf(91));
                h.port = new Integer(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
                tmp.add(h);
            }
            catch (NumberFormatException e) {
                Trace.error("TCPPING.createInitialHosts()", "exeption is " + e);
            }
        }
        return tmp;
    }

    class HostInfo {
        public String host;
        public int port;

        HostInfo() {
        }

        HostInfo(String h, int p) {
            this.host = h;
            this.port = p;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }
    }
}

