/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.MessageAcks;
import org.javagroups.protocols.SavedMessages;
import org.javagroups.protocols.TotalHeader;
import org.javagroups.protocols.TotalRetransmissionThread;
import org.javagroups.stack.Protocol;

public class TOTAL_OLD
extends Protocol {
    private static final String PROTOCOL_NAME = "TOTAL_OLD";
    private Address local_addr = null;
    private Vector members = new Vector();
    private long next_seq_id = -1L;
    private long next_seq_id_to_assign = -1L;
    private static final long INIT_SEQ_ID = 10L;
    private SavedMessages queued_messages = new SavedMessages();
    private MessageAcks ack_history = null;
    private TotalRetransmissionThread retrans_thread = new TotalRetransmissionThread(this);
    private long last_request_time = -1L;

    public String getName() {
        return PROTOCOL_NAME;
    }

    public boolean setProperties(Properties props) {
        if (Trace.trace) {
            System.err.println("TOTAL_OLD layer - trace is on\n");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("TOTAL_OLD.setProperties(): the following properties are not recognized:");
            props.list(System.err);
            return false;
        }
        return true;
    }

    public void reset() {
        this.next_seq_id = -1L;
        this.queued_messages.clearMessages();
        this.retrans_thread.reset();
    }

    protected long getNextSeqID() {
        return this.next_seq_id;
    }

    protected long getFirstQueuedSeqID() {
        return this.queued_messages.getFirstSeq();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                this.retrans_thread.start();
                break;
            }
            case 3: {
                this.retrans_thread.stopResendRequests();
                break;
            }
            case 12: {
                Object temp_obj = evt.getArg();
                if (temp_obj instanceof Address) {
                    this.local_addr = (Address)temp_obj;
                    break;
                }
                System.err.println("Error: Total.up() - could not cast local address to an Address object");
                break;
            }
            case 5: {
                Object temp_obj = evt.getArg();
                if (temp_obj instanceof Message) {
                    Message msg = (Message)temp_obj;
                    if ((temp_obj = msg.removeHeader()) instanceof TotalHeader) {
                        TotalHeader hdr = (TotalHeader)temp_obj;
                        switch (hdr.total_header_type) {
                            case 0: {
                                this.passUp(evt);
                                return;
                            }
                            case 1: {
                                this.handleBCastMessage(msg, hdr.seq_id);
                                return;
                            }
                            case 2: {
                                if (!this.isSequencer()) return;
                                this.handleRequestMessage(msg);
                                return;
                            }
                            case 3: {
                                this.next_seq_id = hdr.seq_id;
                                return;
                            }
                            case 5: {
                                if (!this.isSequencer()) return;
                                temp_obj = msg.getSrc();
                                if (temp_obj instanceof Address) {
                                    this.ack_history.setSeq((Address)temp_obj, hdr.seq_id);
                                    return;
                                }
                                System.err.println("Error: TOTAL_OLD.Up() - could not cast source of message to an Address object (case TotalHeader.TOTAL_CUM_SEQ_ACK)");
                                return;
                            }
                            case 7: {
                                if (!this.isSequencer()) return;
                                this.handleResendRequest(msg, hdr.seq_id);
                                return;
                            }
                            default: {
                                System.err.println("Error: TOTAL_OLD.up() - unrecognized TotalHeader in message - " + hdr.toString());
                                return;
                            }
                        }
                    } else {
                        System.err.println("Error: TOTAL_OLD.up() - could not cast message header to TotalHeader (case Event.MSG)");
                    }
                    return;
                } else {
                    System.err.println("Error: TOTAL_OLD.up() - could not cast argument of Event to a Message (case Event.MSG)");
                }
                return;
            }
            case 10: 
            case 21: {
                System.out.println("View Change event passed up to TOTAL_OLD (debug - mms21)");
                View new_view = (View)evt.getArg();
                this.members = new_view.getMembers();
                if (Trace.trace) {
                    System.out.println("New view members (printed in TOTAL_OLD):");
                    int view_size = this.members.size();
                    int i = 0;
                    while (i < view_size) {
                        System.out.println("  " + this.members.elementAt(i).toString());
                        ++i;
                    }
                }
                this.reset();
                if (!this.isSequencer()) break;
                if (Trace.trace) {
                    System.err.println("TOTAL_OLD.up() - I am the sequencer of this new view");
                }
                this.ack_history = new MessageAcks(this.members);
                this.next_seq_id_to_assign = 10L;
                Message new_view_msg = new Message(null, this.local_addr, null);
                new_view_msg.addHeader(new TotalHeader(3, this.next_seq_id_to_assign));
                this.passDown(new Event(5, new_view_msg));
                break;
            }
        }
        this.passUp(evt);
    }

    private synchronized int passUpMessages() {
        if (this.next_seq_id < 0L) {
            return 0;
        }
        long lowest_seq_stored = this.queued_messages.getFirstSeq();
        if (lowest_seq_stored < 0L) {
            return 0;
        }
        if (lowest_seq_stored < this.next_seq_id) {
            System.err.println("Error: TOTAL_OLD.passUpMessages() - next expected sequence id (" + this.next_seq_id + ") is greater than the sequence id of a stored message (" + lowest_seq_stored + ")");
            return 0;
        }
        if (this.next_seq_id == lowest_seq_stored) {
            Message msg = this.queued_messages.getFirstMessage();
            if (msg == null) {
                System.err.println("Error: TOTAL_OLD.passUpMessages() - unexpected null Message retrieved from stored messages");
                return 0;
            }
            this.passUp(new Event(5, msg));
            ++this.next_seq_id;
            return 1 + this.passUpMessages();
        }
        return 0;
    }

    private synchronized void handleBCastMessage(Message msg, long seq) {
        if (seq < this.next_seq_id) {
            return;
        }
        this.queued_messages.insertMessage(msg, seq);
        int num_passed = this.passUpMessages();
        if (num_passed > 1 && Trace.trace) {
            System.err.println("TOTAL_OLD.handleBCastMessage() - " + num_passed + " message(s) passed up the Protocol Stack");
        }
    }

    private synchronized void handleRequestMessage(Message msg) {
        Header header;
        if (this.next_seq_id_to_assign < 0L) {
            System.err.println("Error: TOTAL_OLD.handleRequestMessage() - cannot handle request... do not know what sequence id to assign");
            return;
        }
        msg.setDest(null);
        msg.setSrc(this.local_addr);
        msg.addHeader(new TotalHeader(1, this.next_seq_id_to_assign));
        Message msg_copy = msg.copy();
        this.ack_history.addMessage(msg_copy, this.next_seq_id_to_assign);
        if (Trace.trace && !((header = msg_copy.peekHeader()) instanceof TotalHeader)) {
            System.err.println("Error: TOTAL_OLD.handleRequestMessage() - BAD: stored message that did not contain a TotalHeader - " + this.next_seq_id_to_assign);
        }
        ++this.next_seq_id_to_assign;
        this.passDown(new Event(5, msg));
    }

    private synchronized void handleResendRequest(Message msg, long seq) {
        Header header;
        if (Trace.trace) {
            System.err.println("TOTAL_OLD.handleRequestMessage() - received resend request for message " + seq);
        }
        Address requester = null;
        Message resend_msg = this.ack_history.getMessage(seq);
        if (resend_msg == null) {
            System.err.println("TOTAL_OLD.handleResendRequest() - could not find the message " + seq + " in the history to resend");
            return;
        }
        resend_msg.setDest(requester);
        if (Trace.trace && !((header = resend_msg.peekHeader()) instanceof TotalHeader)) {
            System.err.println("TOTAL_OLD: resend msg BAD (header is NOT a TotalHeader) - " + seq);
        }
        this.passDown(new Event(5, resend_msg));
        if (Trace.trace) {
            System.err.println("TOTAL_OLD.handleResendRequest() - responded to resend request for message " + seq);
        }
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 3: {
                break;
            }
            case 10: {
                System.err.println("NOTE: VIEW_CHANGE Event going down through TOTAL_OLD");
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        int i = 0;
                        while (i < new_members.size()) {
                            this.members.addElement(new_members.elementAt(i));
                            ++i;
                        }
                    }
                    break;
                }
            }
            case 5: {
                Object temp_obj = evt.getArg();
                if (temp_obj instanceof Message) {
                    Message msg = (Message)temp_obj;
                    if (msg.getDest() == null) {
                        Address sequencer = this.getSequencer();
                        if (sequencer != null) {
                            msg.setDest(sequencer);
                        }
                        msg.addHeader(TotalHeader.getRequestHeader());
                        break;
                    }
                    msg.addHeader(new TotalHeader(0, -1L));
                    break;
                }
                System.err.println("Error: TOTAL_OLD.down() - could not cast argument of Event to a Message (case Event.MSG)");
                break;
            }
        }
        this.passDown(evt);
    }

    private boolean isSequencer() {
        if (this.local_addr == null) {
            System.err.println("TOTAL_OLD.isSequencer() - local address unknown!");
            return false;
        }
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() == 0) {
                System.err.println("TOTAL_OLD.isSequencer() - no members!");
                boolean bl = false;
                return bl;
            }
            Object temp_obj = this.members.elementAt(0);
            if (temp_obj instanceof Address) {
                Address seq_addr = (Address)temp_obj;
                boolean bl = this.local_addr.equals(seq_addr);
                return bl;
            }
            System.err.println("Error: TOTAL_OLD.isSequencer() - could not cast element of \"members\" to an Address");
            boolean bl = false;
            return bl;
        }
    }

    protected Address getLocalAddr() {
        return this.local_addr;
    }

    protected Address getSequencer() {
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() == 0) {
                System.err.println("TOTAL_OLD.getSequencer() - no members");
                Address address = null;
                return address;
            }
            Object temp_obj = this.members.elementAt(0);
            if (temp_obj instanceof Address) {
                Address address = (Address)temp_obj;
                return address;
            }
            System.err.println("Error: TOTAL_OLD.getSequencer() - could not cast first element of \"members\" to an Address");
            Address address = null;
            return address;
        }
    }
}

