/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.pbcast.Digest;
import org.javagroups.protocols.ring.RingNode;
import org.javagroups.protocols.ring.RingNodeFlowControl;
import org.javagroups.protocols.ring.RingToken;
import org.javagroups.protocols.ring.TokenLostException;
import org.javagroups.protocols.ring.UdpRingNode;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.RpcProtocol;
import org.javagroups.util.Util;

public class TOTAL_TOKEN
extends RpcProtocol {
    RingNode node;
    RingNodeFlowControl flowControl;
    Address localAddress;
    TokenRetransmitter tokenRetransmitter;
    TreeMap receivedMessagesQueue;
    SortedMap rmqCopy;
    LinkedList newMessagesQueue;
    Object mutex = new Object();
    long highest = 0L;
    long myAru = 0L;
    long myAruCopy = 0L;
    long previousMyAru = 0L;
    long previousTokenAru = 0L;
    int lastRoundTransmitCount = 0;
    int blockSendingBacklogThreshold = Integer.MAX_VALUE;
    int unblockSendingBacklogThreshold = Integer.MIN_VALUE;
    boolean tokenCirculating = false;
    boolean isCoordinator = false;
    boolean senderBlocked = false;

    public String getName() {
        return "TOTAL_TOKEN";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("block_sending");
        if (str != null) {
            this.blockSendingBacklogThreshold = Integer.parseInt(str);
            ((Hashtable)props).remove("block_sending");
        }
        if ((str = props.getProperty("unblock_sending")) != null) {
            this.unblockSendingBacklogThreshold = Integer.parseInt(str);
            ((Hashtable)props).remove("unblock_sending");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("UDP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public synchronized void passTokenUdp(Object token) {
        this.node.tokenArrived(token);
        this.notify();
    }

    public IpAddress getTokenReceiverAddress() {
        return this.node.getTokenReceiverAddress();
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(45));
        retval.addElement(new Integer(47));
        return retval;
    }

    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 12: {
                this.localAddress = (Address)evt.getArg();
                this.node = new UdpRingNode(this, this.localAddress);
                this.flowControl = new RingNodeFlowControl();
                this.tokenRetransmitter = new TokenRetransmitter();
                new Thread((Runnable)this.tokenRetransmitter, "TokenRetransmitter").start();
                break;
            }
            case 1: {
                this.newMessagesQueue = new LinkedList();
                this.receivedMessagesQueue = new TreeMap();
                break;
            }
            case 5: {
                Header obj = null;
                Message msg = (Message)evt.getArg();
                obj = msg.peekHeader();
                if (!(obj instanceof TotalTokenHeader)) break;
                this.messageArrived(msg);
                return false;
            }
        }
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 45: {
                Digest d = new Digest(1);
                d.add(this.localAddress, this.highest, this.highest);
                this.passUp(new Event(46, d));
                return false;
            }
            case 47: {
                Digest receivedDigest = (Digest)evt.getArg();
                this.myAru = receivedDigest.highSeqnoAt(0);
                return false;
            }
            case 5: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                LinkedList linkedList = this.newMessagesQueue;
                synchronized (linkedList) {
                    this.newMessagesQueue.add(msg);
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    protected void updateView(View newMembers) {
        super.updateView(newMembers);
        Vector newViewMembers = newMembers.getMembers();
        this.flowControl.viewChanged(newViewMembers.size());
        this.node.reconfigure(newViewMembers);
        this.isCoordinator = this.localAddress.equals(newViewMembers.firstElement());
        if (newViewMembers.size() == 1 && this.isCoordinator && !this.tokenCirculating) {
            this.tokenCirculating = true;
            RingToken token = new RingToken();
            try {
                this.node.passToken(token);
                this.tokenRetransmitter.resetTimeout();
            }
            catch (TokenLostException tle) {
                Trace.error("TOTAL_TOKEN.updateView()", "Could start token circulation " + tle);
                tle.printStackTrace();
            }
        }
    }

    private void messageArrived(Message m) {
        TotalTokenHeader h = (TotalTokenHeader)m.peekHeader();
        Long seq = new Long(h.getSeq());
        long seqlong = seq;
        boolean singleDelivery = false;
        boolean holePlugged = false;
        Object object = this.mutex;
        synchronized (object) {
            if (this.myAru + 1L <= seqlong) {
                if (seqlong > this.highest) {
                    this.highest = seqlong;
                }
                this.receivedMessagesQueue.put(seq, m);
                if (this.myAru + 1L == seqlong) {
                    this.myAru = seqlong;
                    if (this.isReceiveMessagesQueueHolePlugged()) {
                        holePlugged = true;
                    } else {
                        singleDelivery = true;
                    }
                }
            }
        }
        if (singleDelivery) {
            Header header = m.removeHeader();
            this.passUp(new Event(5, m));
        }
        if (holePlugged) {
            long last = 0L;
            TreeMap plugAHoleSequence = null;
            Object object2 = this.mutex;
            synchronized (object2) {
                plugAHoleSequence = (TreeMap)this.receivedMessagesQueue.clone();
            }
            if (Trace.trace) {
                Trace.info("TOTAL_TOKEN.messageArrived()", "hole getting plugged, prior muAru " + this.myAru);
            }
            last = this.deliverReceivedMessages(plugAHoleSequence);
            plugAHoleSequence.clear();
            Object object3 = this.mutex;
            synchronized (object3) {
                this.myAru = last;
            }
            if (Trace.trace) {
                Trace.info("TOTAL_TOKEN.messageArrived()", "hole getting plugged, post muAru " + this.myAru);
            }
        }
    }

    private boolean isReceiveMessagesQueueHolePlugged() {
        return this.myAru < this.highest && this.receivedMessagesQueue.containsKey(new Long(this.myAru + 1L));
    }

    private long deliverReceivedMessages(TreeMap map) {
        long lastDelivered = this.myAru - 1L;
        Set deliverySet = map.tailMap(new Long(this.myAru)).keySet();
        Iterator iterator = deliverySet.iterator();
        while (iterator.hasNext()) {
            long nextInQueue = (Long)iterator.next();
            if (lastDelivered + 1L != nextInQueue) break;
            Message m = (Message)map.get(new Long(++lastDelivered));
            Header header = m.removeHeader();
            this.passUp(new Event(5, m));
        }
        return lastDelivered;
    }

    private void updateTokenRtR(RingToken token) {
        int i = 0;
        long seq1 = 0L;
        long seq2 = 0L;
        Long[] rcvd = this.rmqCopy.tailMap(new Long(this.myAruCopy)).keySet().toArray(new Long[0]);
        Collection rtr = token.getRetransmissionRequests();
        int size = rtr.size();
        while (i < rcvd.length - 1) {
            seq1 = rcvd[i++];
            seq2 = rcvd[i];
            while (++seq1 < seq2) {
                rtr.add(new Long(seq1));
            }
        }
        if (Trace.trace && rtr.size() - size > 0) {
            Trace.debug("TOTAL_TOKEN.updateTokenRtR()", "node added retransmission request " + rtr);
        }
    }

    private void rebroadcastMessages(Collection seqs) {
        Iterator iterator = seqs.iterator();
        while (iterator.hasNext()) {
            Long s = (Long)iterator.next();
            Message m = (Message)this.rmqCopy.get(s);
            Message copy = m.copy();
            Header h = copy.peekHeader();
            if (h == null || !(h instanceof TotalTokenHeader)) {
                copy.addHeader(new TotalTokenHeader(s));
            }
            this.passDown(new Event(5, copy));
        }
    }

    private void sendMessages(int count, RingToken token) {
        ArrayList sendList = null;
        LinkedList linkedList = this.newMessagesQueue;
        synchronized (linkedList) {
            int queueSize = this.newMessagesQueue.size();
            if (queueSize <= 0) {
                return;
            }
            if (queueSize > count) {
                sendList = new ArrayList(this.newMessagesQueue.subList(0, count));
                this.newMessagesQueue.removeAll(sendList);
            } else {
                sendList = new ArrayList();
                sendList.addAll(this.newMessagesQueue);
                this.newMessagesQueue.clear();
            }
        }
        long tokenSeq = token.getHighestSequence();
        Iterator iterator = sendList.iterator();
        while (iterator.hasNext()) {
            Message m = (Message)iterator.next();
            m.addHeader(new TotalTokenHeader(++tokenSeq));
            this.messageArrived(m.copy());
            this.passDown(new Event(5, m));
        }
        token.setHighestSequence(tokenSeq);
        Object object = this.mutex;
        synchronized (object) {
            this.myAruCopy = this.myAru;
        }
        if (this.myAruCopy == tokenSeq) {
            token.setAllReceivedUpto(tokenSeq);
        }
    }

    private void tokenReceived(RingToken token) {
        int broadcastCount;
        Collection rbl;
        if (Trace.trace) {
            Trace.info("TOTAL_TOKEN.tokenReceived()", token.toString());
        }
        Util.sleep(100L);
        this.flowControl.setBacklog(this.newMessagesQueue.size());
        this.flowControl.updateWindow(token);
        if (!this.senderBlocked && this.flowControl.getBacklog() > this.blockSendingBacklogThreshold) {
            this.passUp(new Event(60));
            this.senderBlocked = true;
        } else if (this.senderBlocked && this.flowControl.getBacklog() < this.unblockSendingBacklogThreshold) {
            this.passUp(new Event(61));
            this.senderBlocked = false;
        }
        int allowed = this.flowControl.getAllowedToBroadcast(token);
        long tokensAru = token.getAllReceivedUpto();
        Object object = this.mutex;
        synchronized (object) {
            this.rmqCopy = (TreeMap)this.receivedMessagesQueue.clone();
            this.myAruCopy = this.myAru;
        }
        Collection rexmitRequests = token.getRetransmissionRequests();
        int rebroadcastCount = 0;
        if (rexmitRequests.size() > 0 && (rebroadcastCount = (rbl = this.getRebroadcastList(rexmitRequests)).size()) > 0) {
            if (Trace.trace) {
                Trace.info("TOTAL_TOKEN.tokenReceived()", "rebroadcasting " + rbl);
            }
            this.rebroadcastMessages(rbl);
        }
        if ((broadcastCount = allowed - rebroadcastCount) > 0) {
            this.sendMessages(broadcastCount, token);
        }
        if (Trace.trace) {
            Trace.info("TOTAL_TOKEN.tokenReceived()", "myAllReceivedUpto" + this.myAruCopy);
        }
        if (this.myAruCopy < token.getAllReceivedUpto()) {
            token.setAllReceivedUpto(this.myAruCopy);
        }
        this.previousMyAru = this.myAruCopy;
        if (token.getAllReceivedUpto() > this.previousTokenAru) {
            this.removeStableMessages(this.previousTokenAru);
        }
        this.updateTokenRtR(token);
        token.incrementTokenSequence();
        token.addLastRoundBroadcastCount(broadcastCount - this.lastRoundTransmitCount);
        token.addBacklog(this.flowControl.getBacklogDifference());
        this.flowControl.setPreviousBacklog();
        this.lastRoundTransmitCount = broadcastCount;
        this.previousTokenAru = tokensAru;
    }

    private void removeStableMessages(long upToSeq) {
        if (this.rmqCopy.size() > 0) {
            long first = (Long)this.receivedMessagesQueue.firstKey();
            if (first > upToSeq) {
                upToSeq = first;
            }
            if (Trace.trace) {
                Trace.debug("TOTAL_TOKEN.tokenReceived()", "cutting ReceivedMessagesQueue first key " + this.rmqCopy.firstKey() + " cut at " + upToSeq + " last key " + this.rmqCopy.lastKey());
            }
            SortedMap garbage = this.rmqCopy.headMap(new Long(upToSeq));
            garbage.clear();
            SortedMap stable = this.receivedMessagesQueue.headMap(new Long(upToSeq));
            Object object = this.mutex;
            synchronized (object) {
                stable.clear();
            }
        }
    }

    private Collection getRebroadcastList(Collection rtr) {
        ArrayList rebroadcastList = new ArrayList(rtr);
        ((AbstractCollection)rebroadcastList).retainAll(this.rmqCopy.keySet());
        rtr.removeAll(rebroadcastList);
        Collections.sort(rebroadcastList);
        return rebroadcastList;
    }

    private boolean isMember(Address a) {
        Vector m = (Vector)this.members.clone();
        Iterator i = ((AbstractList)m).iterator();
        while (i.hasNext()) {
            Address member = (Address)i.next();
            if (!member.equals(a)) continue;
            return true;
        }
        return false;
    }

    private void tokenPassed(RingToken token) {
    }

    private class TokenRetransmitter
    implements Runnable {
        long rtt = 0L;
        long timer;
        double srtt = 1000.0;
        double a = 0.09;
        int timeoutFactor = 10;
        boolean tokenLost = false;
        Object cachedToken = null;

        public TokenRetransmitter() {
            this.resetTimeout();
        }

        public boolean isExpired() {
            long now = System.currentTimeMillis();
            return now - this.timer > (long)((double)this.timeoutFactor * this.srtt);
        }

        public void recalculateTimeout() {
            long now = System.currentTimeMillis();
            if (this.timer > 0L) {
                this.rtt = now - this.timer;
                this.srtt = (1.0 - this.a) * this.srtt + this.a * (double)this.rtt;
            }
        }

        public double getTimeout() {
            return this.srtt * (double)this.timeoutFactor;
        }

        public void resetTimeout() {
            this.timer = System.currentTimeMillis();
        }

        public void run() {
            while (true) {
                RingToken token = null;
                int timeout = 0;
                try {
                    timeout = (int)this.getTimeout();
                    if (Trace.trace) {
                        Trace.info("TokenRetransmitter.receiveToken()", "timeout=" + timeout);
                    }
                    token = (RingToken)TOTAL_TOKEN.this.node.receiveToken(timeout);
                    TOTAL_TOKEN.this.tokenReceived(token);
                    this.recalculateTimeout();
                    TOTAL_TOKEN.this.node.passToken(token);
                    this.resetTimeout();
                    this.cachedToken = token;
                    continue;
                }
                catch (TokenLostException tle) {
                    Address failed = tle.getFailedNode();
                    int mode = tle.getFailureMode();
                    if (TOTAL_TOKEN.this.isMember(failed)) continue;
                    Trace.error("TokenRetransmitter.run()", "Node " + failed + " lost token, node " + TOTAL_TOKEN.this.node + " sending its cached token " + this.cachedToken);
                    try {
                        TOTAL_TOKEN.this.node.passToken(this.cachedToken);
                        this.resetTimeout();
                        continue;
                    }
                    catch (TokenLostException e) {
                        Trace.error("TokenRetransmitter.run()", "Could start token circulation " + tle);
                        tle.printStackTrace();
                        continue;
                    }
                }
                break;
            }
        }
    }

    public static class TotalTokenHeader
    extends Header {
        private long seq;

        public TotalTokenHeader() {
        }

        public TotalTokenHeader(long seq) {
            this.seq = seq;
        }

        public TotalTokenHeader(Long seq) {
            this.seq = seq;
        }

        public long getSeq() {
            return this.seq;
        }

        public long size() {
            return 121L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.seq);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.seq = in.readLong();
        }

        public String toString() {
            return "[TotalTokenHeader=" + this.seq + "]";
        }
    }
}

