/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.TunnelHeader;
import org.javagroups.stack.Protocol;
import org.javagroups.stack.RouterStub;

public class TUNNEL
extends Protocol
implements Runnable {
    Properties properties = null;
    String channel_name = null;
    Vector members = new Vector();
    String router_host = null;
    int router_port = 0;
    Address local_addr = null;
    Thread receiver = null;
    RouterStub stub = null;

    public String toString() {
        return "Protocol TUNNEL(local_addr=" + this.local_addr + ")";
    }

    public synchronized void handleIncomingMessage(Message msg) {
        String ch_name;
        TunnelHeader hdr = (TunnelHeader)msg.removeHeader();
        if (Trace.trace) {
            Trace.info("TUNNEL.handleIncomingMessage()", "received msg " + msg);
        }
        String string = ch_name = hdr != null ? hdr.channel_name : null;
        if (ch_name != null && !this.channel_name.equals(ch_name)) {
            return;
        }
        this.passUp(new Event(5, msg));
    }

    void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 10: 
            case 21: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    int i = 0;
                    while (i < tmpvec.size()) {
                        this.members.addElement(tmpvec.elementAt(i));
                        ++i;
                    }
                    break;
                }
            }
            case 11: {
                this.passUp(new Event(12, this.local_addr));
                break;
            }
            case 13: {
                this.passUp(new Event(14));
                break;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.channel_name = (String)evt.getArg();
                if (this.stub == null) {
                    System.err.println("TUNNEL.handleDownEvent(CONNECT): router stub is null !");
                } else {
                    boolean rc = this.stub.register(this.channel_name);
                }
                this.receiver = new Thread((Runnable)this, "TUNNEL receiver thread");
                this.receiver.start();
                this.passUp(new Event(7));
                break;
            }
            case 8: {
                if (this.receiver != null) {
                    this.receiver = null;
                    if (this.stub != null) {
                        this.stub.disconnect();
                    }
                }
                this.teardownTunnel();
                this.passUp(new Event(9));
                break;
            }
            case 3: {
                if (this.receiver != null) {
                    this.receiver = null;
                    if (this.stub != null) {
                        this.stub.disconnect();
                    }
                }
                this.passUp(new Event(4));
                this.teardownTunnel();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        if (this.stub != null) ** GOTO lbl14
        System.err.println("TUNNEL.run(): router stub is null; cannot receive messages from router !");
        return;
lbl-1000:
        // 1 sources

        {
            msg = this.stub.receive();
            if (msg == null) {
                if (this.receiver == null) break;
                System.err.println("TUNNEL.run(): received a null message. Trying to reconnect to router");
                if (this.stub.reconnect()) {
                    this.stub.register(this.channel_name);
                }
                System.out.println("TUNNEL.run(): reconnected !");
                continue;
            }
            this.handleIncomingMessage(msg);
lbl14:
            // 3 sources

            ** while (this.receiver != null)
        }
lbl15:
        // 2 sources

    }

    public String getName() {
        return "TUNNEL";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("router_host");
        if (str != null) {
            this.router_host = new String(str);
            ((Hashtable)props).remove("router_host");
        }
        if ((str = props.getProperty("router_port")) != null) {
            this.router_port = new Integer(str);
            ((Hashtable)props).remove("router_port");
        }
        if (Trace.trace) {
            Trace.info("TUNNEL.setProperties()", "router_host=" + this.router_host + ";router_port=" + this.router_port);
        }
        if (this.router_host == null || this.router_port == 0) {
            System.err.println("TUNNEL.setProperties(): both router_host and router_port have to be set !");
            System.exit(-1);
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("TUNNEL.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        if (evt.getType() == 1) {
            this.passUp(evt);
            this.createTunnel();
            this.passUp(new Event(2));
            return;
        }
        this.passUp(evt);
    }

    public synchronized void down(Event evt) {
        boolean rc;
        if (Trace.trace) {
            Trace.info("TUNNEL.down()", "event is " + evt);
        }
        if (evt.getType() != 5) {
            this.handleDownEvent(evt);
            return;
        }
        TunnelHeader hdr = new TunnelHeader(this.channel_name);
        Message msg = (Message)evt.getArg();
        msg.addHeader(hdr);
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if (!(rc = this.stub.send(msg, this.channel_name)) && this.stub.reconnect()) {
            this.stub.register(this.channel_name);
        }
    }

    void createTunnel() {
        if (this.router_host == null || this.router_port == 0) {
            System.err.println("TUNNEL.createTunnel(): router_host and/or router_port not set correctly; tunnel cannot be created !");
            return;
        }
        this.stub = new RouterStub(this.router_host, this.router_port);
        this.local_addr = this.stub.connect();
        if (this.local_addr == null) {
            System.err.println("TUNNEL.createTunnel(): could not obtain local address !");
            return;
        }
        this.passUp(new Event(12, this.local_addr));
    }

    synchronized void teardownTunnel() {
        if (this.stub != null) {
            this.stub.disconnect();
            this.stub = null;
        }
    }
}

