/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.javagroups.Header;

class TotalHeader
extends Header {
    public static final int TOTAL_UNICAST = 0;
    public static final int TOTAL_BCAST = 1;
    public static final int TOTAL_REQUEST = 2;
    public static final int TOTAL_NEW_VIEW = 3;
    public static final int TOTAL_NEW_VIEW_ACK = 4;
    public static final int TOTAL_CUM_SEQ_ACK = 5;
    public static final int TOTAL_SEQ_ACK = 6;
    public static final int TOTAL_RESEND = 7;
    public int total_header_type;
    public long seq_id;

    public TotalHeader() {
    }

    public TotalHeader(int type, long seq) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.total_header_type = type;
                break;
            }
            default: {
                System.err.println("Error: TotalHeader.TotalHeader() - unknown TotalHeader type given: " + type);
                this.total_header_type = -1;
            }
        }
        this.seq_id = seq;
    }

    public static TotalHeader getRequestHeader() {
        return new TotalHeader(2, -1L);
    }

    public String toString() {
        String type = "";
        switch (this.total_header_type) {
            case 0: {
                type = "TOTAL_UNICAST";
                break;
            }
            case 1: {
                type = "TOTAL_BCAST";
                break;
            }
            case 2: {
                type = "TOTAL_REQUEST";
                break;
            }
            case 3: {
                type = "NEW_VIEW";
                break;
            }
            case 4: {
                type = "NEW_VIEW_ACK";
                break;
            }
            case 5: {
                type = "TOTAL_CUM_SEQ_ACK";
                break;
            }
            case 6: {
                type = "TOTAL_SEQ_ACK";
                break;
            }
            case 7: {
                type = "TOTAL_RESEND";
                break;
            }
            default: {
                type = "UNKNOWN TYPE (" + this.total_header_type + ")";
            }
        }
        return "[ TOTAL_OLD: type=" + type + ", seq=" + this.seq_id + " ]";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.total_header_type);
        out.writeLong(this.seq_id);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.total_header_type = in.readInt();
        this.seq_id = in.readLong();
    }
}

