/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.UdpHeader;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

public class UDP
extends Protocol
implements Runnable {
    DatagramSocket send_sock = null;
    DatagramSocket ucast_recv_sock = null;
    MulticastSocket mcast_sock = null;
    IpAddress local_addr = null;
    String group_addr = null;
    IpAddress mcast_addr = null;
    InetAddress bind_addr = null;
    InetAddress local_interface = null;
    int bind_port = 0;
    String mcast_addr_name = "224.0.0.200";
    int mcast_port = 7600;
    Thread mcast_receiver = null;
    UcastReceiver ucast_receiver = null;
    Properties properties = null;
    boolean ip_mcast = true;
    int ip_ttl = 32;
    Vector members = new Vector();
    ByteArrayOutputStream out_stream = new ByteArrayOutputStream(65535);
    int mcast_send_buf_size = 8195;
    int mcast_recv_buf_size = 8195;
    int ucast_send_buf_size = 8195;
    int ucast_recv_buf_size = 8195;

    public String toString() {
        return "Protocol UDP(local address: " + this.local_addr + ")";
    }

    public void run() {
        byte[] receive_buf = new byte[65000];
        Object tmp_addr = null;
        DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
        while (this.mcast_receiver != null && this.mcast_sock != null) {
            try {
                packet.setData(receive_buf, 0, receive_buf.length);
                this.mcast_sock.receive(packet);
                int len = packet.getLength();
                if (len == 1 && packet.getData()[0] == 0) {
                    Trace.info("UDP.run()", "received dummy packet");
                    continue;
                }
                Trace.info("UDP.receive()", "received (mcast) " + packet.getLength() + " bytes from " + packet.getAddress() + ":" + packet.getPort() + " (size=" + len + " bytes)");
                if (len > receive_buf.length) {
                    Trace.error("UDP.run()", "size of the received packet (" + len + ") is bigger than " + "allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length);
                }
            }
            catch (SocketException sock_ex) {
                if (!Trace.trace) break;
                Trace.info("UDP.run()", "multicast socket is closed, exception=" + sock_ex);
                break;
            }
            catch (Exception ex) {
                Trace.error("UDP.run()", "exception=" + ex + ", stack trace=" + Util.getStackTrace(ex));
                Util.sleep(1000L);
            }
            this.handleIncomingUdpPacket(packet);
        }
        if (Trace.trace) {
            Trace.info("UDP.run()", "multicast thread terminated");
        }
    }

    public String getName() {
        return "UDP";
    }

    public void init() throws Exception {
        InetAddress tmp = null;
        try {
            this.local_interface = tmp = InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            Trace.error("UDP.init()", "local interface could not be determined, exception=" + ex);
        }
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("bind_addr");
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                Trace.fatal("UDP.setProperties()", "(bind_addr): host " + str + " not known");
                return false;
            }
            ((Hashtable)props).remove("bind_addr");
        }
        if ((str = props.getProperty("bind_port")) != null) {
            this.bind_port = new Integer(str);
            ((Hashtable)props).remove("bind_port");
        }
        if ((str = props.getProperty("mcast_addr")) != null) {
            this.mcast_addr_name = new String(str);
            ((Hashtable)props).remove("mcast_addr");
        }
        if ((str = props.getProperty("mcast_port")) != null) {
            this.mcast_port = new Integer(str);
            ((Hashtable)props).remove("mcast_port");
        }
        if ((str = props.getProperty("ip_mcast")) != null) {
            this.ip_mcast = new Boolean(str);
            ((Hashtable)props).remove("ip_mcast");
        }
        if ((str = props.getProperty("ip_ttl")) != null) {
            this.ip_ttl = new Integer(str);
            ((Hashtable)props).remove("ip_ttl");
        }
        if ((str = props.getProperty("mcast_send_buf_size")) != null) {
            this.mcast_send_buf_size = Integer.parseInt(str);
            ((Hashtable)props).remove("mcast_send_buf_size");
        }
        if ((str = props.getProperty("mcast_recv_buf_size")) != null) {
            this.mcast_recv_buf_size = Integer.parseInt(str);
            ((Hashtable)props).remove("mcast_recv_buf_size");
        }
        if ((str = props.getProperty("ucast_send_buf_size")) != null) {
            this.ucast_send_buf_size = Integer.parseInt(str);
            ((Hashtable)props).remove("ucast_send_buf_size");
        }
        if ((str = props.getProperty("ucast_recv_buf_size")) != null) {
            this.ucast_recv_buf_size = Integer.parseInt(str);
            ((Hashtable)props).remove("ucast_recv_buf_size");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("UDP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void startUpHandler() {
    }

    public void up(Event evt) {
        if (evt.getType() == 1) {
            this.passUp(evt);
            try {
                this.startWork();
            }
            catch (Exception ex) {
                Trace.fatal("UDP.up()", "exception creating sockets: " + ex);
                return;
            }
            this.passUp(new Event(12, this.local_addr));
            this.passUp(new Event(2));
            return;
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        Trace.info("UDP.down()", "event is " + evt + ", group_addr=" + this.group_addr + ", time=" + System.currentTimeMillis() + ", hdrs are " + Util.printEvent(evt));
        if (evt.getType() != 5) {
            this.handleDownEvent(evt);
            return;
        }
        Message msg = (Message)evt.getArg();
        UdpHeader hdr = new UdpHeader(this.group_addr);
        msg.addHeader(hdr);
        Address dest_addr = msg.getDest();
        if (this.observer != null) {
            this.observer.passDown(evt);
        }
        if (dest_addr == null) {
            if (this.ip_mcast) {
                if (this.mcast_addr == null) {
                    Trace.error("UDP.down()", "dest address of message is null, and sending to default address fails as mcast_addr is null, too ! Discarding message " + Util.printEvent(evt));
                    return;
                }
                msg.setDest(this.mcast_addr);
            } else {
                this.sendMultipleUdpMessages(msg, this.members);
                return;
            }
        }
        try {
            this.sendUdpMessage(msg);
        }
        catch (Exception e) {
            Trace.error("UDP.down()", "exception=" + e + ", msg=" + msg + ", mcast_addr=" + this.mcast_addr);
        }
    }

    void startWork() throws Exception {
        if (Trace.trace) {
            Trace.info("UDP.startWork()", "creating sockets and starting threads");
        }
        this.createSockets();
        this.startThreads();
    }

    void stopWork() {
        if (Trace.trace) {
            Trace.info("UDP.stopWork()", "closing sockets and stopping threads");
        }
        this.stopThreads();
        this.closeSockets();
    }

    boolean checkForLinux() {
        String os = System.getProperty("os.name");
        return os != null && os.equals("Linux");
    }

    void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    void handleIncomingUdpPacket(DatagramPacket packet) {
        Event evt;
        Message msg = null;
        Object tmp_addr = null;
        UdpHeader hdr = null;
        if (packet == null) {
            Trace.error("UDP.handleIncomingUdpPacket()", "packet is null");
            return;
        }
        try {
            ByteArrayInputStream inp_stream = new ByteArrayInputStream(packet.getData());
            ObjectInputStream inp = new ObjectInputStream(inp_stream);
            msg = new Message();
            msg.readExternal(inp);
            evt = new Event(5, msg);
            Trace.info("UDP.handleIncomingUdpPacket()", "Message is " + msg + ", headers are " + msg.getHeaders());
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            hdr = (UdpHeader)msg.removeHeader();
        }
        catch (Exception e) {
            Trace.error("UDP.handleIncomingUdpPacket()", "exception=" + e + ". Packet was sent by " + packet.getAddress() + ":" + packet.getPort());
            return;
        }
        String ch_name = null;
        if (hdr.group_addr != null) {
            ch_name = hdr.group_addr;
        }
        if (this.group_addr == null) {
            if (Trace.trace) {
                Trace.warn("UDP.handleIncomingUdpPacket()", "my group_addr is null, discarding message " + msg + ", headers=" + msg.getHeaders());
            }
            return;
        }
        if (ch_name != null && !this.group_addr.equals(ch_name)) {
            if (Trace.trace) {
                Trace.warn("UDP.handleIncomingUdpPacket()", "discarded message from different group (" + ch_name + "). Sender was " + packet.getAddress() + ":" + packet.getPort());
            }
            return;
        }
        this.passUp(evt);
    }

    void sendUdpMessage(Message msg) throws Exception {
        IpAddress dest = (IpAddress)msg.getDest();
        if (!(dest instanceof IpAddress)) {
            throw new Exception("UdpSenderThread.sendUdpMessage(): destination address is not of type IpAddress (" + dest.getClass().getName() + ")!");
        }
        this.setSourceAddress(msg);
        this.out_stream.reset();
        ObjectOutputStream out = new ObjectOutputStream(this.out_stream);
        msg.writeExternal(out);
        out.flush();
        byte[] buf = this.out_stream.toByteArray();
        DatagramPacket packet = new DatagramPacket(buf, buf.length, dest.getIpAddress(), dest.getPort());
        Trace.info("UDP.sendUdpMessage()", "sending message " + msg);
        if (dest.getIpAddress().isMulticastAddress()) {
            try {
                this.mcast_sock.send(packet);
            }
            catch (Exception e) {
                Trace.error("UDP.sendUdpMessage()", "exception sending mcast message: " + e);
            }
        } else if (this.send_sock != null) {
            try {
                this.send_sock.send(packet);
            }
            catch (Exception e) {
                Trace.error("UDP.sendUdpMessage()", "exception sending ucast message: " + e);
            }
        } else if (Trace.trace) {
            Trace.error("UDP.sendUdpMessage()", "(unicast) send_sock is null. Message is " + msg + ", headers are " + msg.getHeaders());
        }
    }

    void sendMultipleUdpMessages(Message msg, Vector dests) {
        int i = 0;
        while (i < dests.size()) {
            Address dest = (Address)dests.elementAt(i);
            msg.setDest(dest);
            try {
                this.sendUdpMessage(msg);
            }
            catch (Exception e) {
                Trace.debug("UDP.sendMultipleUdpMessages()", "exception=" + e);
            }
            ++i;
        }
    }

    void createSockets() throws Exception {
        InetAddress tmp_addr = null;
        this.send_sock = new DatagramSocket();
        this.send_sock.setSendBufferSize(this.ucast_send_buf_size);
        if (this.bind_addr != null || this.bind_port > 0) {
            if (this.bind_addr == null && this.bind_port > 0) {
                this.ucast_recv_sock = new DatagramSocket(this.bind_port);
            } else if (this.bind_addr != null && this.bind_port > 0) {
                this.ucast_recv_sock = new DatagramSocket(this.bind_port, this.bind_addr);
            }
        }
        if (this.ucast_recv_sock == null) {
            this.ucast_recv_sock = new DatagramSocket();
        }
        if (this.ucast_recv_sock != null) {
            this.ucast_recv_sock.setReceiveBufferSize(this.ucast_recv_buf_size);
        }
        this.local_addr = new IpAddress(this.ucast_recv_sock.getLocalPort());
        if (this.ip_mcast) {
            this.mcast_sock = new MulticastSocket(this.mcast_port);
            this.mcast_sock.setTimeToLive(this.ip_ttl);
            this.mcast_sock.setSendBufferSize(this.mcast_send_buf_size);
            this.mcast_sock.setReceiveBufferSize(this.mcast_recv_buf_size);
            if (this.bind_addr != null) {
                this.mcast_sock.setInterface(this.bind_addr);
            }
            tmp_addr = InetAddress.getByName(this.mcast_addr_name);
            this.mcast_addr = new IpAddress(tmp_addr, this.mcast_port);
            this.mcast_sock.joinGroup(tmp_addr);
        }
        if (Trace.trace) {
            Trace.info("UDP.createSockets()", "local_addr=" + this.local_addr + ", mcast_addr=" + this.mcast_addr + ", ttl=" + this.ip_ttl);
        }
    }

    void closeSockets() {
        this.closeMulticastSocket();
        this.closeUnicastReceiverSocket();
        this.closeUnicastSenderSocket();
    }

    void closeMulticastSocket() {
        if (this.mcast_sock != null) {
            try {
                if (this.mcast_addr != null) {
                    this.mcast_sock.leaveGroup(this.mcast_addr.getIpAddress());
                }
                this.sendDummyPacket(this.mcast_sock.getLocalAddress(), this.mcast_sock.getLocalPort());
                this.mcast_sock.close();
                this.mcast_sock = null;
                if (Trace.trace) {
                    Trace.info("UDP.closeMulticastSocket()", "multicast socket closed");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mcast_addr = null;
        }
    }

    void closeUnicastReceiverSocket() {
        if (this.ucast_recv_sock != null) {
            this.sendDummyPacket(this.ucast_recv_sock.getLocalAddress(), this.ucast_recv_sock.getLocalPort());
            this.ucast_recv_sock.close();
            this.ucast_recv_sock = null;
            if (Trace.trace) {
                Trace.info("UDP.closeMulticastSocket()", "unicast receiver socket closed");
            }
        }
    }

    void closeUnicastSenderSocket() {
        if (this.send_sock != null) {
            this.send_sock.close();
            this.send_sock = null;
            if (Trace.trace) {
                Trace.info("UDP.closeMulticastSocket()", "unicast sender socket closed");
            }
        }
    }

    void sendDummyPacket(InetAddress dest, int port) {
        byte[] buf = new byte[]{0};
        if (dest == null) {
            try {
                dest = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Trace.info("UDP.sendDummyPacket()", "sending packet to " + dest + ":" + port);
        if (this.send_sock == null || dest == null) {
            Trace.warn("UDP.sendDummyPacket()", "send_sock was null or dest was null, cannot send dummy packet");
            return;
        }
        DatagramPacket packet = new DatagramPacket(buf, buf.length, dest, port);
        try {
            this.send_sock.send(packet);
        }
        catch (Exception e) {
            Trace.error("UDP.sendDummyPacket()", "exception sending dummy packet: " + e);
        }
    }

    void startThreads() throws Exception {
        if (this.ucast_receiver == null) {
            this.ucast_receiver = new UcastReceiver();
            this.ucast_receiver.start();
            if (Trace.trace) {
                Trace.info("UDP.startThreads()", "created unicast receiver thread");
            }
        }
        if (this.ip_mcast) {
            if (this.mcast_receiver != null) {
                if (this.mcast_receiver.isAlive()) {
                    if (Trace.trace) {
                        Trace.info("UDP.createThreads()", "did not create new multicastreceiver thread as existing multicast receiver thread is still running");
                    }
                } else {
                    this.mcast_receiver = null;
                }
            }
            if (this.mcast_receiver == null) {
                this.mcast_receiver = new Thread((Runnable)this, "UDP mcast receiver");
                this.mcast_receiver.setPriority(7);
                this.mcast_receiver.setDaemon(true);
                this.mcast_receiver.start();
            }
        }
    }

    void stopThreads() {
        if (this.mcast_receiver != null) {
            if (this.mcast_receiver.isAlive()) {
                Thread tmp = this.mcast_receiver;
                this.mcast_receiver = null;
                this.closeMulticastSocket();
                tmp.interrupt();
                try {
                    tmp.join(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tmp = null;
            }
            this.mcast_receiver = null;
        }
        if (this.ucast_receiver != null) {
            this.ucast_receiver.stop();
            this.ucast_receiver = null;
        }
    }

    void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 10: 
            case 21: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    int i = 0;
                    while (i < tmpvec.size()) {
                        this.members.addElement(tmpvec.elementAt(i));
                        ++i;
                    }
                    break;
                }
            }
            case 11: {
                this.passUp(new Event(12, this.local_addr));
                break;
            }
            case 13: {
                this.passUp(new Event(14));
                break;
            }
            case 3: {
                this.stopWork();
                this.passUp(new Event(4));
                break;
            }
            case 6: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(7));
                break;
            }
            case 8: {
                this.passUp(new Event(9));
            }
        }
    }

    public class UcastReceiver
    implements Runnable {
        boolean running = true;
        Thread thread = null;

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, "UDP.UcastReceiverThread");
                this.thread.setDaemon(true);
                this.running = true;
                this.thread.start();
            }
        }

        public void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                this.running = false;
                Thread tmp = this.thread;
                this.thread = null;
                UDP.this.closeUnicastReceiverSocket();
                tmp.interrupt();
                tmp = null;
            }
            this.thread = null;
        }

        public void run() {
            byte[] receive_buf = new byte[65535];
            Object tmp_addr = null;
            DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
            while (this.running && this.thread != null && UDP.this.ucast_recv_sock != null) {
                try {
                    packet.setData(receive_buf, 0, receive_buf.length);
                    UDP.this.ucast_recv_sock.receive(packet);
                    int len = packet.getLength();
                    if (len == 1 && packet.getData()[0] == 0) {
                        Trace.info("UDP.UcastReceiver.run()", "received dummy packet");
                        continue;
                    }
                    Trace.info("UDP.UcastReceiver.run()", "received (ucast) " + packet.getLength() + " bytes from " + packet.getAddress() + ":" + packet.getPort() + " (size=" + packet.getLength() + " bytes)");
                    if (len > receive_buf.length) {
                        Trace.error("UDP.UcastReceiver.run()", "size of the received packet (" + len + ") is bigger than " + "allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length);
                    }
                    UDP.this.handleIncomingUdpPacket(packet);
                }
                catch (SocketException sock_ex) {
                    if (!Trace.trace) break;
                    Trace.info("UDP.UcastReceiver.run()", "unicast receiver socket is closed, exception=" + sock_ex);
                    break;
                }
                catch (Exception ex) {
                    Trace.error("UDP.UcastReceiver.run()", "[" + UDP.this.local_addr + "] exception=" + ex + ", stack trace=" + Util.getStackTrace(ex));
                    Util.sleep(1000L);
                }
            }
            if (Trace.trace) {
                Trace.info("UDP.UcastReceiver.run()", "unicast receiver thread terminated");
            }
        }
    }
}

