/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.AckReceiverWindow;
import org.javagroups.stack.AckSenderWindow;
import org.javagroups.stack.Protocol;
import org.javagroups.util.List;
import org.javagroups.util.TimeScheduler;

public class UNICAST
extends Protocol
implements AckSenderWindow.RetransmitCommand {
    boolean operational = false;
    Vector members = new Vector();
    List prev_members = new List();
    int prev_members_max_size = 20;
    Hashtable connections = new Hashtable();
    long timeout = 5000L;
    long min_wait_time = 1000L;
    Address local_addr = null;
    TimeScheduler timer = null;

    public String getName() {
        return "UNICAST";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            ((Hashtable)props).remove("timeout");
        }
        if ((str = props.getProperty("min_wait_time")) != null) {
            this.min_wait_time = new Long(str);
            ((Hashtable)props).remove("min_wait_time");
        }
        if ((str = props.getProperty("prev_members_max_size")) != null) {
            this.prev_members_max_size = new Integer(str);
            ((Hashtable)props).remove("prev_members_max_size");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("UNICAST.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 5: {
                Header obj;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                Address src = msg.getSrc();
                if (dst == null || dst.isMulticastAddress() || (obj = msg.peekHeader()) == null || !(obj instanceof UnicastHeader)) break;
                UnicastHeader hdr = (UnicastHeader)msg.removeHeader();
                switch (hdr.type) {
                    case 0: {
                        this.handleDataReceived(src, hdr.seqno, hdr.first, msg);
                        this.sendAck(src, hdr.seqno);
                        break;
                    }
                    case 1: {
                        this.handleAckReceived(src, hdr.seqno);
                        break;
                    }
                    default: {
                        Trace.error("UNICAST.up()", "UnicastHeader type " + hdr.type + " not known !");
                    }
                }
                return;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
                if (this.timer != null) break;
                Trace.error("UNICAST.up()", "[START] timer is null");
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress()) break;
                Entry entry = (Entry)this.connections.get(dst);
                if (entry == null) {
                    entry = new Entry();
                    this.connections.put(dst, entry);
                }
                UnicastHeader hdr = new UnicastHeader(0, entry.sent_msgs_seqno);
                if (entry.sent_msgs == null) {
                    hdr.first = true;
                    entry.sent_msgs = new AckSenderWindow(this, entry.sent_msgs_seqno, this.timeout, this.min_wait_time, this.timer);
                }
                msg.addHeader(hdr);
                if (Trace.trace) {
                    Trace.info("UNICAST.down()", "[" + this.local_addr + "] --> DATA(" + dst + ": #" + entry.sent_msgs_seqno + ", first=" + hdr.first + ")");
                }
                entry.sent_msgs.add(entry.sent_msgs_seqno, msg.copy());
                ++entry.sent_msgs_seqno;
                break;
            }
            case 22: {
                this.operational = true;
                break;
            }
            case 10: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null) {
                        this.members.addAll(new_members);
                    }
                    int i = 0;
                    while (i < new_members.size()) {
                        Object tmp = new_members.elementAt(i);
                        if (!this.prev_members.contains(tmp)) {
                            this.prev_members.add(tmp);
                        }
                        ++i;
                    }
                    while (this.prev_members.size() > this.prev_members_max_size) {
                        this.prev_members.removeFromHead();
                    }
                }
                Hashtable hashtable = this.connections;
                synchronized (hashtable) {
                    Enumeration e = this.connections.keys();
                    while (e.hasMoreElements()) {
                        Object mbr = e.nextElement();
                        if (this.members.contains(mbr)) continue;
                        if (!this.prev_members.contains(mbr)) {
                            Trace.warn("UNICAST.down()", "will NOT remove " + mbr + ": not previous member (" + this.prev_members + ")");
                            continue;
                        }
                        Entry entry = (Entry)this.connections.get(mbr);
                        entry.reset();
                        this.connections.remove(mbr);
                    }
                    break;
                }
            }
            case 3: {
                this.removeAllConnections();
                this.operational = false;
            }
        }
        this.passDown(evt);
    }

    void removeAllConnections() {
        Hashtable hashtable = this.connections;
        synchronized (hashtable) {
            Enumeration e = this.connections.elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                entry.reset();
            }
            this.connections.clear();
        }
    }

    long getInitialSeqno() {
        long ret = (long)(Math.random() * 100.0 % 100.0);
        return ret;
    }

    public void retransmit(long seqno, Message msg, int num_tries) {
        Address dst = msg.getDest();
        if (!this.members.contains(dst)) {
            if (Trace.trace) {
                Trace.warn("UNICAST.retransmit()", "seqno=" + seqno + ":  dest " + dst + " is not member any longer; removing entry !");
            }
            Hashtable hashtable = this.connections;
            synchronized (hashtable) {
                Entry entry = (Entry)this.connections.get(dst);
                if (entry != null) {
                    entry.reset();
                }
                this.connections.remove(dst);
            }
            return;
        }
        if (Trace.trace) {
            Trace.info("UNICAST.retransmit()", "[" + this.local_addr + "] --> XMIT(" + dst + ": #" + seqno + ")");
        }
        this.passDown(new Event(5, msg.copy()));
    }

    /*
     * WARNING - void declaration
     */
    void handleDataReceived(Object sender, long seqno, boolean first, Message msg) {
        Entry entry;
        if (Trace.trace) {
            Trace.info("UNICAST.handleDataReceived()", "[" + this.local_addr + "] <-- DATA(" + sender + ": #" + seqno + ", first=" + first);
        }
        if ((entry = (Entry)this.connections.get(sender)) == null) {
            entry = new Entry();
            this.connections.put(sender, entry);
        }
        if (entry.received_msgs == null) {
            if (first) {
                entry.received_msgs = new AckReceiverWindow(seqno);
            } else if (this.operational) {
                if (Trace.trace) {
                    Trace.warn("UNICAST.handleDataReceived()", "[" + this.local_addr + "] seqno " + seqno + " from " + sender + " is not tagged as the first message sent by " + sender + "; however, the table for received messages from " + sender + " is still null ! We probably haven't received the first message from " + sender + " ! Discarding message (operational=" + this.operational + ")");
                }
                return;
            }
        }
        if (entry.received_msgs != null) {
            Message m;
            entry.received_msgs.add(seqno, msg);
            while ((m = entry.received_msgs.remove()) != null) {
                void var7_6;
                this.passUp(new Event(5, var7_6));
            }
        }
    }

    void handleAckReceived(Object sender, long seqno) {
        Entry entry;
        if (Trace.trace) {
            Trace.info("UNICAST.handleAckReceived()", "[" + this.local_addr + "] <-- ACK(" + sender + ": #" + seqno + ")");
        }
        if ((entry = (Entry)this.connections.get(sender)) == null || entry.sent_msgs == null) {
            return;
        }
        AckSenderWindow win = entry.sent_msgs;
        win.ack(seqno);
    }

    void sendAck(Address dst, long seqno) {
        Message ack = new Message(dst, null, null);
        ack.addHeader(new UnicastHeader(1, seqno));
        if (Trace.trace) {
            Trace.info("UNICAST.sendAck()", "[" + this.local_addr + "] --> ACK(" + dst + ": #" + seqno + ")");
        }
        this.passDown(new Event(5, ack));
    }

    private static class UnicastHeader
    extends Header {
        static final int DATA = 0;
        static final int DATA_ACK = 1;
        int type = 0;
        long seqno = 0L;
        boolean first = false;

        public UnicastHeader() {
        }

        public UnicastHeader(int type, long seqno) {
            this.type = type == 1 ? 1 : 0;
            this.seqno = seqno;
        }

        public String toString() {
            return "[UNICAST: " + this.type2Str(this.type) + ", seqno=" + this.seqno + "]";
        }

        public String type2Str(int t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "DATA_ACK";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.seqno);
            out.writeBoolean(this.first);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.seqno = in.readLong();
            this.first = in.readBoolean();
        }
    }

    class Entry {
        AckReceiverWindow received_msgs = null;
        AckSenderWindow sent_msgs = null;
        long sent_msgs_seqno = UNICAST.this.getInitialSeqno();

        Entry() {
        }

        void reset() {
            if (this.sent_msgs != null) {
                this.sent_msgs.reset();
            }
            if (this.received_msgs != null) {
                this.received_msgs.reset();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.sent_msgs != null) {
                sb.append("sent_msgs=" + this.sent_msgs + "\n");
            }
            if (this.received_msgs != null) {
                sb.append("received_msgs=" + this.received_msgs + "\n");
            }
            return sb.toString();
        }
    }
}

