/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.pbcast;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Membership;
import org.javagroups.MergeView;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.pbcast.Digest;
import org.javagroups.protocols.pbcast.GMS;
import org.javagroups.protocols.pbcast.GmsImpl;
import org.javagroups.protocols.pbcast.JoinRsp;
import org.javagroups.protocols.pbcast.MergeData;
import org.javagroups.util.Promise;

public class CoordGmsImpl
extends GmsImpl {
    boolean merging = false;
    boolean leaving = false;
    Promise leave_promise = null;
    MergeTask merge_task = new MergeTask();
    Vector merge_rsps = new Vector();
    Serializable merge_id = null;

    public CoordGmsImpl(GMS g) {
        this.gms = g;
    }

    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    public void leave(Address mbr) {
        if (mbr == null) {
            Trace.error("CoordGmsImpl.leave()", "member's address is null !");
            return;
        }
        if (this.leave_promise == null) {
            this.leave_promise = new Promise();
        } else {
            this.leave_promise.reset();
        }
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        this.handleLeave(mbr, false);
    }

    public void handleJoinResponse(JoinRsp join_rsp) {
        this.wrongMethod("handleJoinResponse");
    }

    public void handleLeaveResponse() {
        this.wrongMethod("handleLeaveResponse");
    }

    public void suspect(Address mbr) {
        this.handleSuspect(mbr);
    }

    public void unsuspect(Address mbr) {
    }

    public void merge(Vector other_coords) {
        Address leader = null;
        if (this.merging) {
            if (Trace.trace) {
                Trace.warn("CoordGmsImpl.merge()", "merge already in progress, discarded MERGE event");
            }
            return;
        }
        if (other_coords == null) {
            Trace.warn("CoordGmsImpl.merge()", "list of other coordinators is null. Will not start merge.");
            return;
        }
        if (other_coords.size() <= 1) {
            Trace.error("CoordGmsImpl.merge()", "number of coordinators found is " + other_coords.size() + "; will not perform merge");
            return;
        }
        Membership tmp = new Membership(other_coords);
        tmp.sort();
        leader = (Address)tmp.elementAt(0);
        Trace.info("CoordGmsImpl.merge()", "coordinators in merge protocol are: " + tmp);
        if (leader.equals(this.gms.local_addr)) {
            Trace.info("CoordGmsImpl.merge()", "I will be the leader. Starting the merge task");
            this.startMergeTask(other_coords);
        }
    }

    public void handleMergeRequest(Address sender, Object merge_id) {
        if (sender == null) {
            Trace.error("CoordGmsImpl.handleMergeRequest()", "sender == null; cannot send back a response");
            return;
        }
        if (this.merging) {
            Trace.error("CoordGmsImpl.handleMergeRequest()", "merge already in progress");
            this.sendMergeRejectedResponse(sender);
            return;
        }
        this.merging = true;
        this.merge_id = (Serializable)merge_id;
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.handleMergeRequest()", "sender=" + sender + ", merge_id=" + merge_id);
        }
        Digest digest = this.gms.getDigest();
        View view = new View(this.gms.view_id.copy(), this.gms.members.getMembers());
        this.sendMergeResponse(sender, view, digest);
    }

    public void handleMergeResponse(MergeData data, Object merge_id) {
        if (data == null) {
            Trace.error("CoordGmsImpl.handleMergeResponse()", "merge data is null");
            return;
        }
        if (merge_id == null || this.merge_id == null) {
            Trace.error("CoordGmsImpl.handleMergeResponse()", "merge_id (" + merge_id + ") or this.merge_id (" + this.merge_id + ") == null (sender=" + data.getSender() + ").");
            return;
        }
        if (!this.merge_id.equals(merge_id)) {
            Trace.error("CoordGmsImpl.handleMergeResponse()", "this.merge_id (" + this.merge_id + ") is different from merge_id (" + merge_id + ")");
            return;
        }
        Vector vector = this.merge_rsps;
        synchronized (vector) {
            if (!this.merge_rsps.contains(data)) {
                this.merge_rsps.addElement(data);
                this.merge_rsps.notifyAll();
            }
        }
    }

    public void handleMergeView(MergeData data, Object merge_id) {
        if (merge_id == null || this.merge_id == null || !this.merge_id.equals(merge_id)) {
            Trace.error("CoordGmsImpl.handleMergeView()", "merge_ids don't match (or are null); merge view discarded");
            return;
        }
        this.gms.castViewChange(data.view, data.digest);
        this.merging = false;
        merge_id = null;
    }

    public void handleMergeCancelled(Object merge_id) {
        if (merge_id != null && this.merge_id != null && this.merge_id.equals(merge_id)) {
            if (Trace.trace) {
                Trace.info("CoordGmsImpl.handleMergeCancelled()", "merge was cancelled (merge_id=" + merge_id + ")");
            }
            this.merge_id = null;
            this.merging = false;
        }
    }

    public synchronized JoinRsp handleJoin(Address mbr) {
        Vector<Address> new_mbrs = new Vector<Address>();
        View v = null;
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.handleJoin()", "mbr=" + mbr);
        }
        if (this.gms.local_addr.equals(mbr)) {
            Trace.error("CoordGmsImpl.handleJoin()", "cannot join myself !");
            return null;
        }
        if (this.gms.members.contains(mbr)) {
            if (Trace.trace) {
                Trace.error("CoordGmsImpl.handleJoin()", "member " + mbr + " already present; returning existing view " + this.gms.members.getMembers());
            }
            return new JoinRsp(new View(this.gms.view_id, this.gms.members.getMembers()), this.gms.getDigest());
        }
        new_mbrs.addElement(mbr);
        Trace.debug("CoordGmsImpl.handleJoin()", "getting digest");
        Digest tmp = this.gms.getDigest();
        Trace.debug("CoordGmsImpl.handleJoin()", "got digest=" + tmp);
        Digest d = new Digest(tmp.size() + 1);
        d.add(tmp);
        d.add(mbr, 0L, 0L);
        v = this.gms.getNextView(new_mbrs, null, null);
        if (Trace.trace) {
            Trace.debug("CoordGmsImpl.handleJoin()", "joined member " + mbr + ", view is " + v.getMembers());
        }
        return new JoinRsp(v, d);
    }

    public synchronized void handleLeave(Address mbr, boolean suspected) {
        Vector<Address> v = new Vector<Address>();
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.handleLeave()", "mbr=" + mbr);
        }
        if (!this.gms.members.contains(mbr)) {
            if (Trace.trace) {
                Trace.error("CoordGmsImpl.handleLeave()", "mbr " + mbr + " is not a member !");
            }
            return;
        }
        v.addElement(mbr);
        if (suspected) {
            this.gms.castViewChange(null, null, v);
        } else {
            this.gms.castViewChange(null, v, null);
        }
    }

    public void handleViewChange(View new_view, Digest digest) {
        Vector mbrs = new_view.getMembers();
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.handleViewChange()", "view=" + new_view);
        }
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            if (this.leave_promise != null) {
                this.leave_promise.setResult(new Boolean(true));
            }
            return;
        }
        this.gms.installView(new_view, digest);
    }

    public void handleSuspect(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            Trace.warn("CoordGmsImpl.handleSuspect()", "I am the coord and I'm being am suspected -- will probably leave shortly");
            return;
        }
        this.handleLeave(mbr, true);
    }

    public boolean handleDownEvent(Event evt) {
        if (evt.getType() == 3) {
            this.merge_task.stop();
        }
        return true;
    }

    void startMergeTask(Vector coords) {
        this.merge_task.start(coords);
    }

    void stopMergeTask() {
        this.merge_task.stop();
    }

    void getMergeDataFromSubgroupCoordinators(Vector coords, long timeout) {
        Object ret = null;
        long time_to_wait = 0L;
        int num_rsps_expected = 0;
        if (coords == null || coords.size() <= 1) {
            Trace.error("CoordGmsImpl.getMergeDataFromSubgroupCoordinators()", "coords == null or size <= 1");
            return;
        }
        Vector vector = this.merge_rsps;
        synchronized (vector) {
            this.merge_rsps.removeAllElements();
            if (Trace.trace) {
                Trace.info("CoordGmsImpl.getMergeDataFromSubgroupCoordinators()", "sending MERGE_REQ to " + coords);
            }
            int i = 0;
            while (i < coords.size()) {
                Address coord = (Address)coords.elementAt(i);
                Message msg = new Message(coord, null, null);
                GMS.GmsHeader hdr = new GMS.GmsHeader(6);
                hdr.mbr = this.gms.local_addr;
                hdr.merge_id = this.merge_id;
                msg.addHeader(hdr);
                this.gms.passDown(new Event(5, msg));
                ++i;
            }
            num_rsps_expected = coords.size();
            long curr_time = System.currentTimeMillis();
            long end_time = curr_time + timeout;
            while (end_time > curr_time) {
                time_to_wait = end_time - curr_time;
                if (Trace.trace) {
                    Trace.info("CoordGmsImpl.getMergeDataFromSubgroupCoordinators()", "waiting for " + time_to_wait + " msecs for merge responses");
                }
                try {
                    this.merge_rsps.wait(time_to_wait);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (Trace.trace) {
                    Trace.info("CoordGmsImpl.getMergeDataFromSubgroupCoordinators()", "received response: num_rsps_expected=" + num_rsps_expected + ", actual responses=" + this.merge_rsps.size());
                }
                if (this.merge_rsps.size() >= num_rsps_expected) break;
                curr_time = System.currentTimeMillis();
            }
        }
    }

    Serializable generateMergeId() {
        return new ViewId(this.gms.local_addr, System.currentTimeMillis());
    }

    MergeData consolidateMergeData(Vector v) {
        Address new_coord;
        MergeData ret = null;
        long logical_time = 0L;
        Membership new_mbrs = new Membership();
        int num_mbrs = 0;
        Digest new_digest = null;
        Vector<Object> subgroups = new Vector<Object>();
        int i = 0;
        while (i < v.size()) {
            ViewId tmp_vid;
            View tmp_view;
            MergeData tmp_data = (MergeData)v.elementAt(i);
            if (Trace.trace) {
                Trace.info("CoordGmsImpl.consolidateMergeData()", "merge data is " + tmp_data);
            }
            if ((tmp_view = tmp_data.getView()) != null && (tmp_vid = tmp_view.getVid()) != null) {
                logical_time = Math.max(logical_time, tmp_vid.getId());
            }
            new_mbrs.add(tmp_view.getMembers());
            subgroups.addElement(tmp_view.clone());
            ++i;
        }
        new_mbrs.sort();
        num_mbrs = new_mbrs.size();
        Address address = new_coord = num_mbrs > 0 ? (Address)new_mbrs.elementAt(0) : null;
        if (new_coord == null) {
            Trace.error("CoordGmsImpl.consolidateMergeData()", "new_coord == null");
            return null;
        }
        ViewId new_vid = new ViewId(new_coord, logical_time + 1L);
        MergeView new_view = new MergeView(new_vid, new_mbrs.getMembers(), subgroups);
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.consolidateMergeData()", "new merged view will be " + new_view);
        }
        if ((new_digest = this.consolidateDigests(v, num_mbrs)) == null) {
            Trace.error("CoordGmsImpl.consolidateMergeData()", "digest could not be consolidated");
            return null;
        }
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.consolidateMergeData()", "consolidated digest=" + new_digest);
        }
        ret = new MergeData(this.gms.local_addr, new_view, new_digest);
        return ret;
    }

    Digest consolidateDigests(Vector v, int num_mbrs) {
        Digest retval = new Digest(num_mbrs);
        int i = 0;
        while (i < v.size()) {
            MergeData data = (MergeData)v.elementAt(i);
            Digest tmp_digest = data.getDigest();
            if (tmp_digest == null) {
                Trace.error("CoordGmsImpl.consolidateDigests()", "tmp_digest == null; skipping");
            } else {
                retval.merge(tmp_digest);
            }
            ++i;
        }
        return retval;
    }

    void sendMergeView(Vector coords, MergeData combined_merge_data) {
        if (coords == null || combined_merge_data == null) {
            return;
        }
        View v = combined_merge_data.view;
        Digest d = combined_merge_data.digest;
        if (v == null || d == null) {
            Trace.error("CoordGmsImpl.sendMergeView()", "view or digest is null, cannot send consolidated merge view/digest");
            return;
        }
        int i = 0;
        while (i < coords.size()) {
            Address coord = (Address)coords.elementAt(i);
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(8);
            hdr.view = v;
            hdr.digest = d;
            hdr.merge_id = this.merge_id;
            msg.addHeader(hdr);
            this.gms.passDown(new Event(5, msg));
            ++i;
        }
    }

    void sendMergeResponse(Address sender, View view, Digest digest) {
        Message msg = new Message(sender, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_id = this.merge_id;
        hdr.view = view;
        hdr.digest = digest;
        msg.addHeader(hdr);
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.sendMergeResponse()", "response=" + hdr);
        }
        this.gms.passDown(new Event(5, msg));
    }

    void sendMergeRejectedResponse(Address sender) {
        Message msg = new Message(sender, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_rejected = true;
        hdr.merge_id = this.merge_id;
        msg.addHeader(hdr);
        if (Trace.trace) {
            Trace.info("CoordGmsImpl.sendMergeRejectedResponse()", "response=" + hdr);
        }
        this.gms.passDown(new Event(5, msg));
    }

    void sendMergeCancelledMessage(Vector coords, Serializable merge_id) {
        if (coords == null || merge_id == null) {
            Trace.error("CoordGmsImpl.sendMergeCancelledMessage()", "coords or merge_id == null");
            return;
        }
        int i = 0;
        while (i < coords.size()) {
            Address coord = (Address)coords.elementAt(i);
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(9);
            hdr.merge_id = merge_id;
            msg.addHeader(hdr);
            this.gms.passDown(new Event(5, msg));
            ++i;
        }
    }

    void removeRejectedMergeRequests(Vector coords) {
        Iterator it = ((AbstractList)this.merge_rsps).iterator();
        while (it.hasNext()) {
            MergeData data = (MergeData)it.next();
            if (!data.merge_rejected) continue;
            if (data.getSender() != null && coords != null) {
                coords.removeElement(data.getSender());
            }
            it.remove();
            if (!Trace.trace) continue;
            Trace.info("CoordGmsImpl.removeRejectedMergeRequests()", "removed element " + data);
        }
    }

    private class MergeTask
    implements Runnable {
        Thread t = null;
        Vector coords = null;

        private MergeTask() {
        }

        public void start(Vector coords) {
            this.coords = coords;
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "MergeTask thread");
                this.t.start();
            }
        }

        public void stop() {
            Thread tmp = this.t;
            if (this.t != null && this.t.isAlive()) {
                this.t = null;
                tmp.interrupt();
            }
            this.t = null;
            this.coords = null;
        }

        public boolean isRunning() {
            return this.t != null && this.t.isAlive();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block16: {
                block15: {
                    block13: {
                        block14: {
                            MergeData combined_merge_data = null;
                            if (CoordGmsImpl.this.merging) {
                                Trace.warn("CoordGmsImpl.MergeTask.run()", "merge is already in progress, terminating");
                                return;
                            }
                            if (Trace.trace) {
                                Trace.info("CoordGmsImpl.MergeTask.run()", "merge task started");
                            }
                            try {
                                try {
                                    CoordGmsImpl.this.merge_id = CoordGmsImpl.this.generateMergeId();
                                    CoordGmsImpl.this.getMergeDataFromSubgroupCoordinators(this.coords, CoordGmsImpl.this.gms.merge_timeout);
                                    CoordGmsImpl.this.removeRejectedMergeRequests(this.coords);
                                    if (CoordGmsImpl.this.merge_rsps.size() <= 1) {
                                        Trace.warn("CoordGmsImpl.MergeTask.run()", "merge responses from subgroup coordinators <= 1. Cancelling merge");
                                        CoordGmsImpl.this.sendMergeCancelledMessage(this.coords, CoordGmsImpl.this.merge_id);
                                        Object var4_2 = null;
                                        CoordGmsImpl.this.merging = false;
                                        if (!Trace.trace) break block13;
                                        break block14;
                                    }
                                    combined_merge_data = CoordGmsImpl.this.consolidateMergeData(CoordGmsImpl.this.merge_rsps);
                                    if (combined_merge_data == null) {
                                        Trace.error("CoordGmsImpl.MergeTask.run()", "combined_merge_data == null");
                                        CoordGmsImpl.this.sendMergeCancelledMessage(this.coords, CoordGmsImpl.this.merge_id);
                                        break block15;
                                    }
                                    CoordGmsImpl.this.sendMergeView(this.coords, combined_merge_data);
                                    break block16;
                                }
                                catch (Throwable ex) {
                                    Trace.error("CoordGmsImpl.MergeTask.run()", "exception=" + ex);
                                    Object var4_5 = null;
                                    CoordGmsImpl.this.merging = false;
                                    if (Trace.trace) {
                                        Trace.info("CoordGmsImpl.MergeTask.run()", "merge task terminated");
                                    }
                                    this.t = null;
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                CoordGmsImpl.this.merging = false;
                                if (Trace.trace) {
                                    Trace.info("CoordGmsImpl.MergeTask.run()", "merge task terminated");
                                }
                                this.t = null;
                                throw throwable;
                            }
                        }
                        Trace.info("CoordGmsImpl.MergeTask.run()", "merge task terminated");
                    }
                    this.t = null;
                    return;
                }
                Object var4_3 = null;
                CoordGmsImpl.this.merging = false;
                if (Trace.trace) {
                    Trace.info("CoordGmsImpl.MergeTask.run()", "merge task terminated");
                }
                this.t = null;
                return;
            }
            Object var4_4 = null;
            CoordGmsImpl.this.merging = false;
            if (Trace.trace) {
                Trace.info("CoordGmsImpl.MergeTask.run()", "merge task terminated");
            }
            this.t = null;
        }
    }
}

