/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.pbcast;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

public class FD
extends Protocol
implements Runnable {
    Address local_addr = null;
    Thread checker = null;
    long timeout = 6000L;
    Hashtable members = new Hashtable();
    Vector suspected_mbrs = new Vector();

    public String getName() {
        return "FD";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            ((Hashtable)props).remove("timeout");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("FD.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 5: {
                Message msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                this.updateSender(sender);
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 3: {
                this.stopChecker();
                break;
            }
            case 10: {
                View v = (View)evt.getArg();
                Vector mbrs = v.getMembers();
                this.passDown(evt);
                Enumeration e = this.members.keys();
                while (e.hasMoreElements()) {
                    Address mbr = (Address)e.nextElement();
                    if (mbrs.contains(mbr)) continue;
                    this.members.remove(mbr);
                }
                this.members.remove(this.local_addr);
                if (this.members.size() > 0 && this.checker == null) {
                    this.startChecker();
                }
                return;
            }
            case 56: {
                this.updateSenders((Vector)evt.getArg());
                return;
            }
        }
        this.passDown(evt);
    }

    public void run() {
        while (this.checker != null && this.members.size() > 0) {
            Enumeration e = this.members.keys();
            while (e.hasMoreElements()) {
                Address mbr = (Address)e.nextElement();
                long timestamp = ((Entry)this.members.get((Object)mbr)).timestamp;
                long diff = System.currentTimeMillis() - timestamp;
                if (diff < this.timeout) continue;
                Trace.info("FD.run()", "suspecting " + mbr);
                this.passUp(new Event(15, mbr));
                if (this.suspected_mbrs.contains(mbr)) continue;
                this.suspected_mbrs.addElement(mbr);
            }
            Util.sleep(this.timeout);
        }
        this.checker = null;
    }

    synchronized void startChecker() {
        if (this.checker == null) {
            this.checker = new Thread((Runnable)this, "FD.CheckerThread");
            this.checker.start();
        }
    }

    synchronized void stopChecker() {
        Thread tmp = null;
        if (this.checker != null && this.checker.isAlive()) {
            tmp = this.checker;
            this.checker = null;
            tmp.interrupt();
            try {
                tmp.join(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmp.isAlive()) {
                Trace.warn("FD.stopChecker()", "interrupted checker thread is still alive !");
            }
        }
        this.checker = null;
    }

    void updateSender(Address mbr) {
        long curr_time = 0L;
        if (mbr == null) {
            Trace.debug("FD.updateSender()", "member " + mbr + " not found");
            return;
        }
        if (this.suspected_mbrs.size() > 0 && this.suspected_mbrs.contains(mbr)) {
            this.passUp(new Event(57, mbr));
            this.suspected_mbrs.remove(mbr);
        }
        if (mbr.equals(this.local_addr)) {
            return;
        }
        Entry entry = (Entry)this.members.get(mbr);
        curr_time = System.currentTimeMillis();
        if (entry != null) {
            entry.timestamp = curr_time;
        } else {
            this.members.put(mbr, new Entry(curr_time));
        }
    }

    void updateSenders(Vector v) {
        if (v == null) {
            return;
        }
        int i = 0;
        while (i < v.size()) {
            Address mbr = (Address)v.elementAt(i);
            this.updateSender(mbr);
            ++i;
        }
    }

    String printTimestamps() {
        StringBuffer sb = new StringBuffer();
        Hashtable hashtable = this.members;
        synchronized (hashtable) {
            Enumeration e = this.members.keys();
            while (e.hasMoreElements()) {
                Address mbr = (Address)e.nextElement();
                sb.append("\n" + mbr + ": " + (System.currentTimeMillis() - ((Entry)this.members.get((Object)mbr)).timestamp));
            }
        }
        return sb.toString();
    }

    static class Entry {
        long timestamp;

        Entry(long timestamp) {
            this.timestamp = timestamp;
        }

        public String toString() {
            return new Long(this.timestamp).toString();
        }
    }
}

