/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.pbcast;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.pbcast.Digest;
import org.javagroups.protocols.pbcast.NakAckHeader;
import org.javagroups.stack.NakReceiverWindow;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Range;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

public class NAKACK
extends Protocol
implements NakReceiverWindow.RetransmitCommand {
    long[] retransmit_timeout = new long[]{2000L, 3000L, 5000L, 8000L};
    boolean is_server = false;
    Address local_addr = null;
    Vector members = new Vector();
    long seqno = 0L;
    long deleted_up_to = 0L;
    int gc_lag = 20;
    Hashtable received_msgs = new Hashtable();
    Hashtable sent_msgs = new Hashtable();
    boolean leaving = false;
    TimeScheduler timer = null;

    public String getName() {
        return "NAKACK";
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(45));
        retval.addElement(new Integer(48));
        retval.addElement(new Integer(47));
        retval.addElement(new Integer(59));
        return retval;
    }

    public Vector providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(45));
        return retval;
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                this.send(msg);
                return;
            }
            case 45: {
                Digest digest = this.getDigest();
                this.passUp(new Event(46, digest));
                return;
            }
            case 48: {
                Digest digest = this.getDigest();
                this.passUp(new Event(49, digest));
                return;
            }
            case 47: {
                this.setDigest((Digest)evt.getArg());
                return;
            }
            case 59: {
                this.mergeDigest((Digest)evt.getArg());
                return;
            }
            case 21: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members.removeAllElements();
                this.members.addAll(mbrs);
                break;
            }
            case 10: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members.removeAllElements();
                this.members.addAll(mbrs);
                this.adjustReceivers();
                this.is_server = true;
                break;
            }
            case 22: {
                this.is_server = true;
                break;
            }
            case 8: {
                this.leaving = true;
                break;
            }
            case 3: {
                if (this.timer != null) {
                    try {
                        this.timer.stop();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.removeAll();
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 36: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 1: {
                TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
                if (this.timer != null) break;
                Trace.error("NAKACK.up()", "[START] timer is null");
                break;
            }
            case 45: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(46, digest));
                return;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 5: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.peekHeader();
                if (obj == null || !(obj instanceof NakAckHeader)) break;
                if (!this.is_server) {
                    if (Trace.trace) {
                        Trace.debug("NAKACK.up()", "message was discarded (not yet server)");
                    }
                    return;
                }
                NakAckHeader hdr = (NakAckHeader)msg.removeHeader();
                switch (hdr.type) {
                    case 1: {
                        this.handleMessage(msg, hdr);
                        return;
                    }
                    case 2: {
                        if (hdr.range == null) {
                            if (Trace.trace) {
                                Trace.error("NAKACK.up()", "XMIT_REQ: range of xmit msg == null; discarding request from " + msg.getSrc());
                            }
                            return;
                        }
                        this.handleXmitReq(msg.getSrc(), hdr.range.low, hdr.range.high);
                        return;
                    }
                }
                Trace.error("NAKACK.up()", "NakAck header type " + hdr.type + " not known !");
                return;
            }
        }
        this.passUp(evt);
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("retransmit_timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            ((Hashtable)props).remove("retransmit_timeout");
            if (tmp != null && tmp.length > 0) {
                this.retransmit_timeout = tmp;
            }
        }
        if ((str = props.getProperty("gc_lag")) != null) {
            this.gc_lag = new Integer(str);
            if (this.gc_lag < 1) {
                System.err.println("NAKACK.setProperties(): gc_lag has to be at least 1 (set to 1)");
                this.gc_lag = 1;
            }
            ((Hashtable)props).remove("gc_lag");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("NAKACK.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    long getNextSeqno() {
        return this.seqno++;
    }

    void send(Message msg) {
        long msg_id = this.getNextSeqno();
        if (Trace.trace) {
            Trace.info("NAKACK.send()", "sending msg #" + msg_id);
        }
        msg.addHeader(new NakAckHeader(1, msg_id));
        this.sent_msgs.put(new Long(msg_id), msg.copy());
        this.passDown(new Event(5, msg));
    }

    /*
     * WARNING - void declaration
     */
    void handleMessage(Message msg, NakAckHeader hdr) {
        Message msg_to_deliver;
        NakReceiverWindow win = null;
        if (msg == null || hdr == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.handleMessage()", "msg or header is null");
            }
            return;
        }
        Address sender = msg.getSrc();
        if (sender == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.handleMessage()", "sender of message is null");
            }
            return;
        }
        if (Trace.trace) {
            Trace.info("NAKACK.handleMessage()", "[" + this.local_addr + "] received <" + sender + "#" + hdr.seqno + ">");
        }
        msg.addHeader(hdr);
        win = (NakReceiverWindow)this.received_msgs.get(sender);
        if (win == null) {
            if (this.leaving) {
                return;
            }
            if (Trace.trace) {
                Trace.warn("NAKACK.handleMessage()", "[" + this.local_addr + "] discarded message from non-member " + sender);
            }
            return;
        }
        win.add(hdr.seqno, msg);
        while ((msg_to_deliver = win.remove()) != null) {
            void var4_5;
            if (var4_5.peekHeader() instanceof NakAckHeader) {
                var4_5.removeHeader();
            }
            this.passUp(new Event(5, var4_5));
        }
        if (Trace.trace) {
            Trace.info("NAKACK.handleMessage()", "win for " + sender + " is \n" + win + "\nsent_msgs=" + this.sent_msgs.size());
        }
    }

    void handleXmitReq(Address dest, long first_seqno, long last_seqno) {
        if (first_seqno > last_seqno) {
            if (Trace.trace) {
                Trace.error("NAKACK.handleXmitReq()", "first_seqno (" + first_seqno + ") > last_seqno (" + last_seqno + "): not able to retransmit");
            }
            return;
        }
        if (Trace.trace) {
            Trace.info("NAKACK.handleXmitReq()", "sender=" + dest + " [" + first_seqno + " - " + last_seqno + "]");
        }
        long i = first_seqno;
        while (i <= last_seqno) {
            Message m = (Message)this.sent_msgs.get(new Long(i));
            if (m == null) {
                Trace.error("NAKACK.handleXmitReq()", "(requester=" + dest + ") message with " + "seqno=" + i + " not found in sent_msgs ! sent_msgs=" + this.printSentMsgs());
            } else {
                Message retr_msg = m.copy();
                retr_msg.setDest(dest);
                if (Trace.trace) {
                    Trace.debug("NAKACK.handleXmitReq()", "xmitting msg #" + i + " to " + dest);
                }
                this.passDown(new Event(5, retr_msg));
            }
            ++i;
        }
    }

    void adjustReceivers() {
        NakReceiverWindow win;
        Address sender;
        Enumeration e = this.received_msgs.keys();
        while (e.hasMoreElements()) {
            sender = (Address)e.nextElement();
            if (this.members.contains(sender)) continue;
            win = (NakReceiverWindow)this.received_msgs.get(sender);
            win.reset();
            if (Trace.trace) {
                Trace.info("NAKACK.adjustReceivers()", "removing " + sender + " from received_msgs (not member anymore)");
            }
            this.received_msgs.remove(sender);
        }
        int i = 0;
        while (i < this.members.size()) {
            sender = (Address)this.members.elementAt(i);
            if (!this.received_msgs.containsKey(sender)) {
                win = new NakReceiverWindow(sender, this, 0L, this.timer);
                win.setRetransmitTimeouts(this.retransmit_timeout);
                this.received_msgs.put(sender, win);
            }
            ++i;
        }
    }

    Digest getDigest() {
        Digest digest = new Digest(this.members.size());
        int i = 0;
        while (i < this.members.size()) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, false);
            if (range == null) {
                if (Trace.trace) {
                    Trace.error("NAKACK.getDigest()", "range is null");
                }
            } else {
                digest.add(sender, range.low, range.high);
            }
            ++i;
        }
        return digest;
    }

    Digest getDigestHighestDeliveredMsgs() {
        long high_seqno_seen = 0L;
        Digest digest = new Digest(this.members.size());
        int i = 0;
        while (i < this.members.size()) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, true);
            if (range == null) {
                if (Trace.trace) {
                    Trace.error("NAKACK.getDigest()", "range is null");
                }
            } else {
                high_seqno_seen = this.getHighSeqnoSeen(sender);
                digest.add(sender, range.low, range.high, high_seqno_seen);
            }
            ++i;
        }
        return digest;
    }

    void setDigest(Digest d) {
        this.clear();
        if (d == null || d.senders == null) {
            Trace.error("NAKACK.setDigest()", "digest or digest.senders is null");
            return;
        }
        int i = 0;
        while (i < d.size()) {
            Address sender = d.senderAt(i);
            if (sender == null) {
                Trace.error("NAKACK.setDigest()", "sender at index " + i + " in digest is null");
            } else {
                long initial_seqno = d.highSeqnoAt(i);
                NakReceiverWindow win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
                win.setRetransmitTimeouts(this.retransmit_timeout);
                this.received_msgs.put(sender, win);
            }
            ++i;
        }
    }

    void mergeDigest(Digest d) {
        if (d == null || d.senders == null) {
            Trace.error("NAKACK.mergeDigest()", "digest or digest.senders is null");
            return;
        }
        int i = 0;
        while (i < d.size()) {
            Address sender = d.senderAt(i);
            if (sender == null) {
                Trace.error("NAKACK.mergeDigest()", "sender at index " + i + " in digest is null");
            } else {
                long initial_seqno = d.highSeqnoAt(i);
                NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
                if (win == null) {
                    win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
                    win.setRetransmitTimeouts(this.retransmit_timeout);
                    this.received_msgs.put(sender, win);
                } else if (win.getHighestReceived() < initial_seqno) {
                    win.reset();
                    this.received_msgs.remove(sender);
                    win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
                    win.setRetransmitTimeouts(this.retransmit_timeout);
                    this.received_msgs.put(sender, win);
                }
            }
            ++i;
        }
    }

    Range getLowestAndHighestSeqno(Address sender, boolean stop_at_gaps) {
        Range r = null;
        if (sender == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.getLowestAndHighestSeqno()", "sender is null");
            }
            return r;
        }
        NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
        if (win == null) {
            Trace.error("NAKACK.getLowestAndHighestSeqno()", "sender " + sender + " not found in received_msgs");
            return r;
        }
        r = stop_at_gaps ? new Range(win.getLowestSeen(), win.getHighestSeen()) : new Range(win.getLowestSeen(), win.getHighestReceived() + 1L);
        return r;
    }

    long getHighSeqnoSeen(Address sender) {
        long ret = 0L;
        if (sender == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.getHighSeqnoSeen()", "sender is null");
            }
            return ret;
        }
        if (sender.equals(this.local_addr)) {
            return this.seqno - 1L;
        }
        NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
        if (win == null) {
            Trace.error("NAKACK.getHighSeqnoSeen()", "sender " + sender + " not found in received_msgs");
            return ret;
        }
        ret = win.getHighestReceived();
        return ret;
    }

    void stable(Digest d) {
        if (this.members == null || this.local_addr == null || d == null) {
            if (Trace.trace) {
                Trace.warn("NAKACK.stable()", "members, local_addr or digest are null !");
            }
            return;
        }
        if (Trace.trace) {
            Trace.info("NAKACK.stable()", "received digest " + d);
        }
        int i = 0;
        while (i < d.size()) {
            Address sender = d.senderAt(i);
            long seqno = d.highSeqnoAt(i);
            if (sender != null) {
                NakReceiverWindow recv_win = (NakReceiverWindow)this.received_msgs.get(sender);
                if (recv_win != null) {
                    long my_highest_rcvd = recv_win.getHighestReceived();
                    long stability_highest_rcvd = d.highSeqnoSeenAt(i);
                    if (stability_highest_rcvd >= 0L && stability_highest_rcvd > my_highest_rcvd) {
                        if (Trace.trace) {
                            Trace.debug("NAKACK.stable()", "my_highest_rcvd (" + my_highest_rcvd + ") < stability_highest_rcvd (" + stability_highest_rcvd + "): requesting retransmission of " + sender + "#" + stability_highest_rcvd);
                        }
                        this.retransmit(stability_highest_rcvd, stability_highest_rcvd, sender);
                    }
                }
                if ((seqno -= (long)this.gc_lag) >= 0L) {
                    if (Trace.trace) {
                        Trace.info("NAKACK.stable()", "deleting stable msgs < " + sender + "#" + seqno);
                    }
                    if (sender.equals(this.local_addr)) {
                        if (Trace.trace) {
                            Trace.info("NAKACK.stable()", "removing [" + this.deleted_up_to + " - " + seqno + "] from sent_msgs");
                        }
                        long j = this.deleted_up_to;
                        while (j <= seqno) {
                            this.sent_msgs.remove(new Long(j));
                            ++j;
                        }
                        this.deleted_up_to = seqno;
                    }
                    if (recv_win != null) {
                        recv_win.stable(seqno);
                    }
                }
            }
            ++i;
        }
    }

    public synchronized void retransmit(long first_seqno, long last_seqno, Address sender) {
        Message retransmit_msg = new Message(sender, null, null);
        if (Trace.trace) {
            Trace.info("NAKACK.retransmit()", "sending XMIT_REQ ([" + first_seqno + ", " + last_seqno + "]) to " + sender);
        }
        NakAckHeader hdr = new NakAckHeader(2, first_seqno, last_seqno);
        retransmit_msg.addHeader(hdr);
        this.passDown(new Event(5, retransmit_msg));
    }

    void clear() {
        this.sent_msgs.clear();
        Enumeration e = this.received_msgs.elements();
        while (e.hasMoreElements()) {
            NakReceiverWindow win = (NakReceiverWindow)e.nextElement();
            win.reset();
        }
        this.received_msgs.clear();
    }

    void removeAll() {
        this.sent_msgs.clear();
        Enumeration e = this.received_msgs.keys();
        while (e.hasMoreElements()) {
            Address key = (Address)e.nextElement();
            NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(key);
            win.destroy();
        }
        this.received_msgs.clear();
    }

    String dumpContents() {
        StringBuffer ret = new StringBuffer();
        ret.append("\nsent_msgs: " + this.sent_msgs.size());
        ret.append("\nreceived_msgs: ");
        Enumeration e = this.received_msgs.keys();
        while (e.hasMoreElements()) {
            Address key = (Address)e.nextElement();
            NakReceiverWindow w = (NakReceiverWindow)this.received_msgs.get(key);
            ret.append("\n" + w.toString());
        }
        return ret.toString();
    }

    String printSentMsgs() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.sent_msgs.keys();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement() + " ");
        }
        return sb.toString();
    }
}

